#include "main.h"
#include "nuke.h"

void FScanNukeShowBuild ()
{
	int namelen;
	char * line, * ptr, * name;
	int lcm, hcm, oil, rad, ava, tech, cost;
	int nr;

	FeedEmpire ("show nuke build", PRINT);
	MessageAtEmpire ("scanning nuke build data");

	nr = 0;
	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			set_nt_name (nr, (char *) 0);
			nr_nuke_types = nr;
			return;
		}

		if (line == (char *) 0)
			return;

		ptr = StrStr (line, "lcm hcm  oil  rad avail");
		if (ptr != (char *) 0)
		{
			namelen = ptr - line - 1;
			continue;
		}

		if (strlen (line) < namelen + 2)
		{
			PrintAtEmpire ("Strange line in show nuke build");
			PrintAtEmpire (line);
			continue;
		}

		if (sscanf (line + namelen + 1, "%d %d %d %d %d %d $ %d", 
		      & lcm, & hcm, & oil, & rad, & ava, & tech, & cost) != 7)
		{
			PrintAtEmpire ("Strange line in show nuke build");
			PrintAtEmpire (line);
			continue;
		}

		set_nt_lcm (nr, lcm);
		set_nt_hcm (nr, hcm);
		set_nt_oil (nr, oil);
		set_nt_rad (nr, rad);
		set_nt_ava (nr, ava);
		set_nt_tech (nr, tech);
		set_nt_cost (nr, cost);

		name = doalloc ((unsigned) namelen + 1);
		ptr = line + namelen;
		while (* -- ptr == ' ' && ptr > line);
		(void) strncpy (name, line, ptr - line + 1);
		* (name + (ptr - line) + 1) = '\0';
		set_nt_name (nr, name);
		nr ++;
	}
}

void FScanNukeShowCap ()
{
	int nr;
	int index_i, ability_index;
	char * line, * ptr;
	int blst, dam, lbs, tech;
	char word [100];

	FeedEmpire ("show nuke cap", PRINT);
	MessageAtEmpire ("scanning nuke build data");
	nr = 0;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		if (line == (char *) 0)
			return;

		ptr = StrStr (line, "blst dam lbs tec");
		if (ptr != (char *) 0)
		{
			if (ksu_version)
			{
				index_i = ptr - line;
				ptr = StrStr (line, "abilities");

				if (ptr == (char *) 0)
				{
					PrintAtEmpire (Fmt 
						("show nuke cap: %s",
						"abilities not found"));
					EmpireMore ();
					return;
				}

				ability_index = ptr - line;
				continue;
			}
			else {
				index_i = ptr - line;
				continue;
			}

		}

		if (strlen (line) < index_i + 2)
		{
			PrintAtEmpire ("Strange line in show nuke cap");
			PrintAtEmpire (line);
			EmpireMore ();
			continue;
		}

		if (sscanf (line + index_i, "%d %d %d %d",
			& blst, & dam, & lbs, & tech) != 4)
		{
			PrintAtEmpire ("Strange line in show nuke cap");
			PrintAtEmpire (line);
			EmpireMore ();
			continue;
		}

		set_nt_blst (nr, blst);
		set_nt_dam (nr, dam);
		set_nt_lbs (nr, lbs);
		set_nt_tech (nr, tech);

		if (ksu_version)
		{
			ptr = line + ability_index;
			while (ScanWord (& ptr, word))
			{
				if (strcmp (word, "neutron") == 0)
					set_nt_abil (nr, NK_NEUTRON);
				else
				{
					PrintAtEmpire (Fmt (
						"unknown ability: %s",
						word));
					Bell ();
					EmpireMore ();
					continue;
				}
			}
		}

		nr ++;
	}
}
