.Sh PARSER Syntax
.Np EXPRESSION
\fBXemp\fP has a very powerful highlight expression mechanism. Practically
everything you want to highlight can be entered as an expression.
The expression parser will identify variables like \fIcivilians\fP or
\fIfood\fP and substitute it with the actual value from the sector currently
being examined.
.s1
An expression is made up of compare expressions separated by the Boolean
operators \fIand\fP and \fIor\fP. And has a higher priority than or, so
the expression
.Sr
0 and 0 or 1
.Sl
will be parsed as ((0 and 0) or 1) which evaluates to 1 whereas you might
have expected it would be parsed as (0 and (0 or 1)) which evaluates to 0.
Both sides of an Boolean operator must be either boolean or Numeric, where a
non-zero Numeric value means \fITRUE\fP and a zero numeric value means
\fIFALSE\fP.
.s1
The exceptional case of an expression is the one with only a compare expression,
without Boolean operator. Therefore the expression can either assume a 
Numeric or a Boolean type.
.s1
A compare expression consists of a term optionally followed by a compare
operator and another term. Compare operators are '>', '<=', '=', etc.
where both sides of the compare operator must be of the same type. 
.s1
The exceptional case of a compare expressions is the one with only a term,
without an operator. Therefore a compare expression can either assume a Numeric
or a Boolean type;
.s1
A special compare operator is '~' which accepts only strings. It
will match the left hand side string with the right hand side string 
and evaluates to 1 if either the left hand side string as a whole is a
part of the right hand side or vica versa.
.s1
Terms are normal everyday Numeric expressions like 1 + 2 * 4 etc. with
the usual operator precedence.
.s1
Every subexpression (a expression between parentheses) can be preceded by
a expression modifier. Each of these modifiers identifies the object
which the variables within the expressions reference. Valid modifiers
are "sector(...)", "ship(...)", "plane(...)" and "nuke(...)". Variables
in the outermost layer (no modifiers given) are assumed to be referencing
the sector.
.Np EXAMPLES
.Sr
\fBplague_stage <> healty\fP
.Sl
Evaluates to \fITRUE\fP if the sector is infected.
.s1
.Sr
\fBoccupied and (mil < (civ / 20))\fP
.Sl
Evaluates to \fITRUE\fP if the sector is occupied and does not have enough
military in it to control it.
.s1
.Sr
\fBship(name ~ "cargo")\fP
.Sl
Evaluates to the number of ships in the current sector which name begins
with "cargo".
.s1
.Sr
\fBship(name ~ "cargo" and mob > 0) == 2\fP
.Sl
Evaluates to \fITRUE\fP if the sector contains exactly two ships whose names
starts with "cargo" and have some mobility left.
.s1
.Sr
\fBplane((name ~ "transport") && (mobility > 0)) > 10 && mil > 100\fP
.Sl
Evaluates to \fITRUE\fP if there are at least 10 planes in the sector whose
name start with "transport" and have some mobility left. The sector must
contain at least 100 military.
.br
\fBN.B.\fP Note that the "plane(...)" modifier only examines the planes
in the sector and not planes on ships in the sector.
.s1
.Sr
\fBship(military > 100 && plane(name ~ "transport"))\fP
.Sl
Evaluates to \fITRUE\fP if there is a ship in the sector with more
than 100 military and contains a plane which name starts with "transport".
.br
\fBN.B.\fP Note that the "plane(...)" modifier within the "ship(...)"
modifier only looks at the planes of the ship and not the planes of the
sector.
.s1
.Sr
\fBship(plane(nuke(name = "10 kt fission")))\fP
.Sl
Evaluates to the number of ships that carries at least one plane that is
loaded with a 10 kt fission nuclear warhead.
.Np KEYWORDS
\fPXEMP\fP has a lot of variables predefined. Below are tables explaining
all valid variables and characters within expressions. The alias field can
contain another name, which denotes the same variable.
.s1
Expressions can be entered in \fBC\fP, \fBPASCAL\fP or mixed style. I would
suggest you use either \fIC\fP or \fIPASCAL\fP and not a mixture of both.
.Lt
.KS
.in 0
.B "Table 1:  Expression Keywords"
.TS
center,box;
c|c|c
l|l|l.
Name	Alias	Description
_
'c'		Character constant <c>
"<text>"		String constant <text>
<constant>		Numerical constant
*		Times operator
+		Plus operator
\-		Minus/negate operator
/		Divide operator
\\=	==	Equals operator
<>	!=	Does not equal operator
<		Smaller then operator
>		Larger then operator
<=		Smaller or equal operator
>=		Larger or equal operator
and	&&	Boolean and
or	||	Boolean or
not	!	Boolean not
true		Boolean true
false		Boolean false
population	pop	(civs + mils + uws) of sector
current_sector	@	Stands for current sector coordinates
warehouse		Current sector's warehouse
[<expr>, <expr>]		Specifies sector coordinates
threshold(commodity)	t()	Returns commodity threshold
resource(resource_val)	r()	Returns resouce_val value
round(expr)		Round off number
floor(expr)		Round off to nearest lowest integer
ceil(expr)		Round off to nearest highest integer
.TE
.KE
.Le
.Lt
.KS
.B "Table 2:  Resource and Commodity variables"
.TS
box,center;
c|c|c
l|l|l.
Name	Alias	Is resource
_
ura	uranium	
food		x
dust	gold_dust	x
oil		x
iron	iron_ore	x
uw	uncompensated_workers	
guns		
bars	gold_bars	
petrol	petroleum	
lcms	lcm	
hcms	hcm	
she	shells	
rads	radioactive	
.TE
.KE
.Le
.Lt
.KS
.B "Table 3:  Sector census values"
.TS
box,center;
c|c|c
l|l|l.
Name	Alias	Type
_
xloc		Numeric
yloc		Numeric
owner		String
designation	des	Character (see table 10)
newdesignation	newdes	Character
efficiency	eff	Numeric
work		Numeric
available	avail	Numeric
mobility	mob	Numeric
civilians	civ/civs	Numeric
militairs	mil/mils	Numeric
planes		Numeric
ships		Numeric
nukes		Numeric
distribute	dist	Coords
occupied	occ	Boolean
owned		Boolean
coast		Boolean
food_used		Numeric
starvation		Boolean
mines		Boolean
territory	terr	Numeric
plague		Numeric
plague_stage	pstage	Plague (see table 4)
happy		Boolean
happiness	hstate	Happy (see table 5)
.TE
.KE
.Le
.KS
.B "Table 4:  Plague Type Constants"
.TS
box,center;
c|c
l|l.
Name	Description
_
healthy	Sector not infected
infected	Sector is battling plague
dying	Sector has plague deaths
.TE
.KE
.s1
.KS
.B "Table 5:  Happiness Type Constants"
.TS
box,center;
c|c|c
l|l|l.
Name	Alias	Description
_
loyal		Sector population is loyal to you
unrest		Sector has unrest
revolutionaries	revol	Sector has revolutionaries
terrorists	terror	Sector has terrorists
guerrillas	guerre	Sector has guerillas
.TE
.KE
.s1
.KS
.B "Table 6:  Variables valid within nuke(...) modifier"
.TS
box,center;
c|c
l|l.
Usage	Result type
_
xloc	Numeric
yloc	Numeric
_
name	String
type	Numeric (index in nuke type table)
stockpile	Numeric
.TE
.KE
.s1
.Lt
.KS
.B "Table 7:  Variables valid within ship(...) modifier"
.TS
box,center;
c|c|c
l|l|l.
Usage	Alias	Result type
_
xloc		Numeric
yloc		Numeric
owner		String
owned		Boolean
efficiency	eff	Numeric
mobility	mob	Numeric
civilians	civ/civs	Numeric
militairs	mil/mils	Numeric
_
food		Numeric
dust	gold_dust	Numeric
oil		Numeric
iron	iron_ore	Numeric
uw	uncompensated_workers	Numeric
guns		Numeric
bars	gold_bars	Numeric
petrol	petroleum	Numeric
lcms		Numeric
hcms		Numeric
she	shells	Numeric
rads	radioactive	Numeric
population	pop	Numeric ((civs+mils+uws) of ship)
planes		Numeric
food_used		Numeric
starvation		Boolean
_
fleet		Character
name		String
type		Numeric (index in ship table)
technology	tech	Numeric
number		Numeric
radar		Numeric
sonar		Numeric
moves		Numeric
.TE
.KE
.Le
.Lt
.KS
.B "Table 8:  Variables valid within plane(...) modifier"
.TS
center,box;
c|c|c
l|l|l.
Usage	Alias	Result type
_
xloc		Numeric
yloc		Numeric
efficiency	eff	Numeric
mobility	mob	Numeric
_
wing		Character
name		String
type		Numeric (index in plane table)
number		Numeric
technology	tech	Numeric
maxrange		Numeric
max_range		Numeric
attack		Numeric
defense		Numeric
harden		Numeric
load		Numeric
.TE
.KE
.Le
.Lt
.KS
.B "Table 9:  Empire constants"
.TS
box,center;
c|c|c
l|l|l.
Usage	Alias	Description
_
secs_per_etu	spe	Seconds per Empire Time Unit (etu)
etus_per_update	epu	ETU's per update
interest_rate	irate	Interest per gold bar
civ_tax_rate	ctrate	Income per civilian
uw_tax_rate	utrate	Income per uncompensated worker
active_mil_cost	amcrate	Cost per active militair
reserve_mil_cost	rmcrate	Cost per militair on reserve
fertility_rate	frate	Food a non-aggi sector grows per fert. unit
harvest_rate	hrate	Amount of food a one civilian will harvest
civ_birth_rate	cbrate	Number of babies one civilian will make
uw_birth_rate	ubrate	Number of babies one uw will make
eat_rate	erate	Amount of food a grownup will eat
baby_eat_rate	berate	Amount of food a baby will eat
.TE
.KE
.Le
.Lt
.KS
.B "Table 10:  Designation characters"
.TS
box,center;
c|c
l|l.
Character	Description
_
?	Unknown
\.	Sea
^	Mountain
s	Sanctuary
\	Wasteland
-	Wilderness
c	Capital
u	Uranium mine
p	Park
d	Defense plant
i	Shell industry
m	Mine
g	Gold mine
h	Harbor
w	Warehouse
*	Airfield
a	Agribusiness
o	Oil field
j	Light manufacturing
k	Heavy manufacturing
f	Fortress
t	Technical center
r	Research lab
n	Nuclear plant
l	Library/school
+	Highway
)	Radar installation
!	Weather stn
#	Bridge head
\\=	Bridge span
b	Bank
%	Refinery
e	Enlistment center
.TE
.KE
.Le
