/*********************************************************************
  Title: emp_mux
  Author: Alan M. Levi (levi@cs.psu.edu)
  Last date of modification: March 10, 1993
*********************************************************************/
   
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "main.h"
#include "client.h"

char client_buf[MAX_BUF_SIZE + 1];
char another_buf[MAX_BUF_SIZE + 1];
int socket_queue[MAX_NUM_OUTSTANDING_MSGS]; /* holds list of clients waiting
					       for command completion. */
int head = 0;
int tail = 0;

void process_cmd(sock)
int sock;
{
  int size, t, i;
  fd_set t_fds, t2_fds;
  int found_4747 = 0;

  num_commands_since_last_reconnect++;

/*  printf("entering process_cmd with sock = %d\n", sock);
  printf("old socket_queue:\n");
  for(i=head;i!=tail;) {
    printf("%d ", socket_queue[head]);
    i++;
    i %= MAX_NUM_OUTSTANDING_MSGS;
  }
  printf("\n");
*/
  if(((tail+1)% MAX_NUM_OUTSTANDING_MSGS) == head) {
    fprintf(stderr, "yipes!  We have more than %d outstanding messages\n",
	    MAX_NUM_OUTSTANDING_MSGS);
    return;
  }
  socket_queue[tail] = sock;
  tail++;
  tail %= MAX_NUM_OUTSTANDING_MSGS;


  if(expect(sock, "quit")) {
    client_logout(sock);
    if(tail != head) {
      tail--;
      tail %= MAX_NUM_OUTSTANDING_MSGS;
    }
    return;
  }
  if(!strncmp(entire_line, "474747", 6)) {
/*    printf("ignoring msg: 474747\n");*/
    if(tail != head) {
      tail--;
      tail %= MAX_NUM_OUTSTANDING_MSGS;
    }
    return;
  }
  put_line(server_sock, entire_line, strlen(entire_line));

  FD_ZERO(&t_fds);
  FD_SET(server_sock, &t_fds);
  FD_SET(sock, &t_fds);
/*  FD_SET(0, &t_fds);*/

  while(1) {
    descpy(&t2_fds, &t_fds);
/*    printf("select in client.c...\n");*/
    while(select(FD_SETSIZE, &t2_fds, (fd_set *)NULL, (fd_set *)NULL,
		 (struct timeval *)NULL) <= 0);
    if(FD_ISSET(server_sock, &t2_fds))
      process_server_msg();
    else if(FD_ISSET(sock, &t2_fds)) {
      t = get_line(sock, client_buf, MAX_BUF_SIZE, 0);
      if(!strncmp(client_buf, "474747", 6)) {
/*	printf("found 474747\n");*/
	found_4747 = 1;
      }
      while((t == MAX_BUF_SIZE) && (client_buf[MAX_BUF_SIZE-1] != '\n')) {
	if(!found_4747)
	  put_line(server_sock, client_buf, t);
	t = get_line(sock, client_buf, MAX_BUF_SIZE, 0);
      }
      if(!found_4747)
	put_line(server_sock, client_buf, t);
      else
	return;
    }
    else {
      fprintf(stderr, "hmmm... expecting stuff from client in process_cmd\n");
    }
/*    printf("select in client.c...\n");*/
  }
}


/* ???????????????????????????????????????????????? */
/****************************************************/
void process_server_msg()
{
  int t, temp_sock, is_prompt = 0;
  int size;

/*  printf("in process_server_msg\n");*/

  if(head == tail)
    temp_sock = 1;
  else
    temp_sock = socket_queue[head];


  size = get_line(server_sock, another_buf, MAX_BUF_SIZE, 0);
  (void)strncpy(entire_line, another_buf, size);
  entire_line[size] = '\0';
  if(!strncmp("6 ", another_buf, 2))
    is_prompt = 1;
  put_line(temp_sock, another_buf, size);
  while(another_buf[size-1] != '\n') {
    size = get_line(server_sock, another_buf, MAX_BUF_SIZE, 0);
    my_strncat(entire_line, another_buf, size);
    put_line(temp_sock, another_buf, size);
  }

  if(is_prompt) {
    int t;
/*    printf("**PROMPT in client**: %s\n", entire_line);*/
    (void)strcpy(prompt, entire_line);
    if(head != tail) {
      head++;
      head %= MAX_NUM_OUTSTANDING_MSGS;
    }
    sscanf(prompt, "%*d %*d %d\n", &t);
    if(t<=0)
      server_reconnect(0);
  }
}

/* return 0 if failure
   return number of characters read if success
*/
int get_line(sock, buf, size, flag)
int sock;
char *buf;
int size;
int flag;
{
  int n, t, retval;
  char *temp;

  if((n = recv(sock, buf, size, MSG_PEEK)) <= 0)
    return FAILURE;

  if(flag && should_echo(sock))
    printf("<- socket #%2d | ", sock);

  t = nstrnchr(buf, '\n', n);

  if(t==n) {
    if(recv(sock, buf, n, 0) < 0) {
      perror("recv:");
      return -1;
    }
    retval = n + get_line(sock, buf+n, size-n, 1);
  }
  else {
    if(recv(sock, buf, t+1, 0) < 0) {
      perror("recv:");
      return -1;
    }
    retval = t+1;
  }
  if(flag && should_echo(sock))
    print_n_str(buf, retval);
  return retval;
}


int nstrnchr(str, c, n)
char *str;
char c;
int n;
{
  char *temp;
  int retval = 0;

  for(temp = str;(retval < n) && (*temp != c) && (*temp != '\0'); temp++)
    retval++;
  return retval;
}

