/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 * $Revision: 2.2 $ $Date: 91/03/14 22:56:25 $
 */

#define signed
#include <sys/types.h>

#ifdef hpux
#include <string.h>
#else
#include <strings.h>
#endif

#define MAXNOC		128	/* must be a multiple of 32, and less than */
				/* or equal to 224 while nat_t is a u_char */

typedef unsigned char nat_t;	/* also change NSC_NATID in nsc.h */
typedef	short coord_t;		/* also change NSC_COORD in nsc.h */
typedef unsigned short id_t;	/* unit identifier */
typedef unsigned long locid_t;	/* location identifier */

#define LOC_TYPE(loc)		((loc) >> 24)
#define LOC_UID(loc)		((loc) & 0x00ffffff)
#define LOC_SET(type, uid)	(((type) << 24) | (uid))

/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#endif

typedef void (*voidfunc_t)();
typedef int (*intfunc_t)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
extern	long random();

extern	double dmax();
extern	double dmin();

extern	char *fmt(/* char * */);
extern	char *copy();
extern	char *numstr();
extern	char *esplur();
extern	char *splur();
extern	char *iesplur();
extern	char *plur();
extern	char *getstarg();
extern	char *getstring();

extern	char *malloc();
extern	char *calloc();
extern	char *ctime();

extern	time_t time();
extern	double atof();
