#include "corewar.h"


int GetLabel(input, output, rest)
char *input, *output, *rest;
{
	char buffer[81], *p, *q, *r;

	if (!*input) return (0);
	strcpy(buffer,input);

	p = buffer;
	while (*p && isspace(*p)) p++;

	q = p;
	while (*q && !isspace(*q)) q++;
	if (*q) r = q + 1;
	else r = q;
	*q = '\0';

	while (*r && isspace(*r)) r++;
	strcpy(rest,r);

	q = p;
	if (!isalpha(*q++))
		return (0);

	while (*q) {
		if (!isalnum(*q))
			return (0);
		q++;
	}

	strcpy(output,p);

	return (1);
}

int GetInstr(input, output, rest)
char *input;
int *output;
char *rest;
{
	char buffer[81], *p, *q, *r;
	int i = 0;

	if (!*input) return (0);
	strcpy(buffer,input);

	p = buffer;
	while (*p && isspace(*p)) p++;

	q = p;
	while (*q && !isspace(*q)) q++;
	if (*q) r = q + 1;
	else r = q;
	*q = '\0';

	while (*r && isspace(*r)) r++;
	strcpy(rest,r);

	q = p;
	while (*q) {
		if (isupper(*q)) *q = tolower(*q);
		q++;
	}

	while (*OpcodeString[i]) {
		if (!strcmp(OpcodeString[i],p)) {
			*output = i;
			return (1);
		}
		i++;
	}

	return (0);
}

int GetMode(input, output, rest)
char *input;
char *output;
char *rest;
{
	char buffer[81], *p, *q, *r;

	if (!*input) return (0);
	strcpy(buffer,input);

	p = buffer;
	while (*p && isspace(*p)) p++;
	r = p;

	while (*r && isspace(*r)) r++;
	strcpy(rest,r);

	if (q = index("#$@<",*p)) {
		if (*p == '#') *output = IMMEDIATE;
		else if (*p == '$') *output = DIRECT;
		else if (*p == '@') *output = INDIRECT;
		else *output = PREDECREMENT;

		r = p + 1;
		while (*r && isspace(*r)) r++;
		strcpy(rest,r);

		return (1);
	}

	*output = DIRECT;
	if (isalnum(*p)) return (1);
	if ((*p == '+') || (*p == '-')) return (1);

	return (0);
}

int GetField(labels, input, output, rest, count, n)
LABEL *labels;
char *input;
int *output;
char *rest;
int count, n;
{
	char buffer[81], label[81], *p, *q, *r;
	int total = 0, address;
	char operation = '+';

	if (!*input) return (0);
	strcpy(buffer,input);

	p = buffer;
	while (1) {
		while (*p && isspace(*p)) p++;

		if ((*p == '+') || (*p == '-') || (isdigit(*p))) {
			if (*p == '+') {
				p++;
				address = atoi(p);
			} else if (*p == '-') {
				p++;
				address = -atoi(p);
			} else address = atoi(p);

			if (operation == '+') total += address;
			else if (operation == '-') total -= address;
			else if (operation == '*') total *= address;
			else if (operation == '/') total /= address;

			while (*p && isdigit(*p)) p++;
		} else if (isalpha(*p)) {
			strcpy(label,p);
			q = label;
			while (*q && isalnum(*q)) q++;
			*q = '\0';

			if (!FindLabel(labels,label,&address)) {
				printf("-- Invalid field in operand #%d.\n",n);
				printf("-- Undefined label \"%s\"\n",label);
				return (0);
			}

			if (operation == '+') total += address - count;
			else if (operation == '-') total -= address - count;
			else if (operation == '*') total *= address - count;
			else if (operation == '/') total /= address - count;

			while (*p && isalnum(*p)) p++;
		} else {
			printf("-- Invalid field in operand #%d.\n",n);
			printf("-- Buffer = \"%s\"\n",p);
			return (0);
		}

		while (*p && isspace(*p)) p++;
		if (!(q = index("+-*/",*p)) || (!*q)) break;
		operation = *p++;
	}

	*output = total;
	while (*p && isspace(*p)) p++;
	strcpy(rest,p);
		
	return (1);
}
