#include "corewar.h"


int CreateCore(Core, size)
CORE **Core;
int size;
{
	if (!(*Core = (CORE *)malloc(sizeof(CORE)*size))) {
		printf("Could not allocate enough memory for the Core!\n");
		return (0);
	}
}

int InitCore(Core, size)
CORE *Core;
int size;
{
	register int i;

	for (i = 0; i < size; i++) {
		Core[i].Control = 0;
		Core[i].AField = 0;
		Core[i].BField = 0;
		Core[i].Owner = 0;
		Core[i].Aging = 0;
	}

	return (1);
}

int PrintCore(Core, start, length, size)
CORE *Core;
int start, length, size;
{
	register int i;
	int location;

	for (i = 0; i < length; i++) {
		location = (start + i)%size;
		printf("%5d:\t",location);
		printf("%s\t",OpcodeString[(Core[location].Control&0xF0)/16]);
		printf("%s",ModeString[(Core[location].Control&0x0C)/4]);
		printf("%d\t",Core[location].AField);
		printf("%s",ModeString[Core[location].Control&0x03]);
		printf("%d\t",Core[location].BField);
		printf("%d\n",Core[location].Owner);
	}

	printf("\n");

	return (1);
}
