#include "corewar.h"


int CreateProgram(program, filename)
PROGRAM **program;
char *filename;
{
	int lines = 0, index = 0;
	char buffer[81];
	PROGRAM *p, *q;
	FILE *fp;

	if (!(q = (PROGRAM *)malloc(sizeof(PROGRAM)))) {
		printf("Could not allocate memory for the program!\n");
		return (0);
	}

	if (!(fp = fopen(filename,"r"))) {
		printf("Could not open file %s!\n",filename);
		return (0);
	}

	strcpy(q->filename,filename);
	while (fgets(buffer,80,fp))
		if (FixInput(buffer,&p)) lines++;
	q->length = lines;
	fclose(fp);

	q->start = 0;
	q->index = 0;
	q->wins = 0;
	q->losses = 0;
	q->ties = 0;
	q->twins = 0;
	q->tlosses = 0;
	q->tties = 0;
	q->next = NULL;

	if (!*program) {
		*program = q;
		return (1);
	}

	p = *program;
	while (index++, p->next) p = p->next;
	q->index = index;
	p->next = q;

	return (1);
}

int LoadProgram(Core, program, size)
CORE *Core;
PROGRAM *program;
int size;
{
	int end = 0, instr, mode1, addr1, mode2, addr2;
	char buffer[81], rest[81], label[81], *p, *q;
	int location, count, line;
	LABEL *labels;
	FILE *fp;

	if (!(fp = fopen(program->filename,"r"))) {
		printf("Could not open file \"%s\"!\n",program->filename);
		return (0);
	}

	if (!GetAddress(Core,program,size)) {
		printf("Could not assign address for %s!\n",program->filename);
		return (0);
	}

	program->start = 0;
	location = program->address % size;

	line = count = 0;
	while (line++, fgets(buffer,80,fp)) {
		if (!FixInput(buffer,&p)) continue;

		if (!GetInstr(p,&instr,rest)) {
			if (GetLabel(p,label,rest)) {
				if (FindLabel(labels,label,&addr1)) {
					PrintError(1,line,buffer);
					return(CleanUp(0,fp,&labels));
				}

				if (!AddLabel(&labels,label,count)) {
					return(CleanUp(0,fp,&labels));
				}
			}
		}

		count++;
	}

	if (fseek(fp,0L,0)) {
		return(CleanUp(0,fp,&labels));
	}

	line = count = 0;
	while (line++, fgets(buffer,80,fp)) {
		if (!FixInput(buffer,&p)) continue;

		strcpy(label," ");
		instr = -1;
		mode1 = mode2 = IMMEDIATE;
		addr1 = addr2 = 0;

		if (!GetInstr(p,&instr,rest)) {
			if (!GetLabel(p,label,rest)) {
				PrintError(2,line,buffer);
				return(CleanUp(0,fp,&labels));
			}

			if (!*rest) {
				instr = DAT;
				mode1 = mode2 = IMMEDIATE;
				addr1 = addr2 = 0;
			}

			if ((!GetInstr(rest,&instr,rest)) && (*rest)) {
				PrintError(3,line,buffer);
				return(CleanUp(0,fp,&labels));
			}
		}

		if ((!GetMode(rest,&mode1,rest)) && (*rest)) {
			if (instr != END) {
				PrintError(4,line,buffer);
				return(CleanUp(0,fp,&labels));
			}

			mode1 = DIRECT;
			addr1 = 0;
		}

		if ((!GetField(labels,rest,&addr1,rest,count,1)) && (*rest)) {
			if (instr != END) {
				PrintError(0,line,buffer);
				return(CleanUp(0,fp,&labels));
			}
		}

		if (*rest) {
			if (!GetMode(rest,&mode2,rest)) {
				PrintError(5,line,buffer);
				return(CleanUp(0,fp,&labels));
			}

			if (!GetField(labels,rest,&addr2,rest,count,2)) {
				PrintError(0,line,buffer);
				return(CleanUp(0,fp,&labels));
			}
		} else {
			if (instr == DAT) {
				mode2 = mode1;
				addr2 = addr1;
				mode1 = IMMEDIATE;
				addr1 = 0;
			} else {
				mode2 = IMMEDIATE;
				addr2 = 0;
			}
		}

		if (instr == END) {
			if (addr1 != 0) program->start = count + addr1;
			end = 1;
		}

		count++;
	
		if ((instr >= 0) && (instr != END)) {
			Core[location].Control = instr*16 + mode1*4 + mode2;
			Core[location].AField = addr1;
			Core[location].BField = addr2;
			Core[location].Owner = program->index + 1;
			location = (location + 1) % size;
		}
	}

	if (end) program->length = count - 1;

	return(CleanUp(1,fp,&labels));
}

int FixInput(input, output)
char *input, **output;
{
	char *p, *q;

	p = input;
	while (*p && isspace(*p)) p++;
	if (!*p || *p == ';') return (0);
	*output = p;

	if (p = index(input,';')) *p = '\0';
	if (p = index(input,'\r')) *p = '\0';
	if (p = index(input,'\n')) *p = '\0';
	while (p = index(input,':')) *p = ' ';
	while (p = index(input,',')) *p = ' ';

	if (q = index(input,'\0')) q--;
	while ((q > input) && (isspace(*q))) *q-- = '\0';

	return (1);
}


int GetAddress(Core, program, size)
CORE *Core;
PROGRAM *program;
int size;
{
	int location, tries = 64;
	register int i;

	while (tries--) {
		location = random()%size;
		for (i = location; i < location+program->length; i++) {
			if (Core[i].Control != 0) continue;
			if (Core[i].AField != 0) continue;
			if (Core[i].BField != 0) continue;
			program->address = location;
			return (1);
		}
	}

	tries = size;
	while (tries--) {
		location++;
		for (i = location; i < location+program->length; i++) {
			if (Core[i].Control != 0) continue;
			if (Core[i].AField != 0) continue;
			if (Core[i].BField != 0) continue;
			program->address = location;
			return (1);
		}
	}

	return (0);
}

int InitProgram(program, CLL, Tasks)
PROGRAM *program;
TASKS **CLL;
int *Tasks;
{
	TASKS *task;

	if (!(task = (TASKS *)malloc(sizeof(TASKS)))) {
		printf("Could not allocate memory for tasks!\n");
		return(0);
	}

	task->last = task;
	task->PC = program->address + program->start;
	task->next = task;
	*CLL = task;
	*Tasks = 1;

	return (1);
}
