#include "corewar.h"


int AddLabel(labels, label, address)
LABEL **labels;
char *label;
int address;
{
	LABEL *p, *q;

	if (!(q = (LABEL *)malloc(sizeof(LABEL)))) {
		printf("Could not allocate memory for labels!\n");
		return (0);
	}

	strcpy(q->label,label);
	q->address = address;
	q->next = NULL;

	if (!*labels) {
		*labels = q;
		return (1);
	}

	p = *labels;
	while (p->next) p = p->next;
	p->next = q;

	return (1);
}

int PrintLabels(labels)
LABEL *labels;
{
	LABEL *p;

	if (!labels) {
		printf("No labels have been found!\n");
		return (0);
	}

	p = labels;
	while (p) {
		printf("%s at address %d\n",p->label,p->address);
		p = p->next;
	}

	return (1);
}

int FreeLabels(labels)
LABEL **labels;
{
	LABEL *p, *q;

	p = *labels;
	while (p) {
		q = p->next;
		free(p);
		p = q;
	}

	*labels = NULL;
}

int FindLabel(labels, label, address)
LABEL *labels;
char *label;
int *address;
{
	LABEL *p;

	if (!labels) return (0);

	p = labels;
	while (p) {
		if (!strcmp(p->label,label)) {
			*address = p->address;
			return (1);
		}
		p = p->next;
	}

	return (0);
}
