#include <curses.h>
#include "corewar.h"


int InitDisplay()
{
	initscr();

	clear();
	refresh();

	return (1);
}

int EndDisplay()
{
	move(23,0);
	refresh();

	endwin();

	return (1);
}

int DisplayCore(Core, size, cycles, update, fade, programs, Tasks)
CORE *Core;
int size, cycles, update, fade, programs, *Tasks;
{
	int modulo, offset, owner[MAX_PROG+1];
	int current, age, row, colm;
	register int i, j, k;
	char ch;

	if ((update > 0) && (cycles % update)) return (1);

	modulo = size / 1500;

	for (i = 0; i < 20; i++) {
		for (j = 0; j < 79; j++) {
			for (k = 0; k <= programs; k++) owner[k] = 0;

			offset = ((i*79 + j) * modulo) % size;
			for (k = 0; k < modulo; k++) {
				offset = (offset + k) % size;
				if (Core[offset].Owner <= programs) {
					age = cycles - Core[offset].Aging;
					if ((fade) && (age > fade)) owner[0]++;
					else owner[Core[offset].Owner]++;
				} else owner[0]++;
			}

			owner[0] = 0;
			for (k = 1, current = 0; k <= programs; k++)
				if (owner[k] > owner[current]) current = k;

			if (current < 10) ch = current + '0';
			else ch = current - 10 + 'A';
			if (current == 0) ch = ' ';
			mvaddch(i,j,ch);
		}
	}

	mvprintw(21,63,"Cycles: %8d",cycles);
	mvprintw(21,0,"Tasks:");

	for (i = 1; i <= programs; i++) {
		if (i%2) row = 21;
		else row = 22;
		colm = 7*(i/2 + i%2);
		if (i < 10) ch = i + '0';
		else ch = i - 10 + 'A';
		mvprintw(row,colm,"%c=%3d",ch,Tasks[i-1]);
	}
		
	refresh();

	return (1);
}

int DisplayString(string)
char *string;
{
	mvprintw(22,79-strlen(string),string);
	refresh();
}
