#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>


#define MAX_PROG	16

#define ON		1
#define OFF		0

#define SINGLES		0
#define CHALLENGE	1
#define ROUNDS		2
#define DEBUG		3

#define DEF_SIZE	8000
#define DEF_CYCLES	100000
#define DEF_BATTLES	1
#define DEF_DISPLAY	100
#define DEF_FADE	0
#define DEF_ARENA	3
#define DEF_STATS	ON
#define DEF_CONFIG	ON
#define DEF_RESULTS	ON
#define DEF_TOTALS	ON
#define DEF_FIGHT	SINGLES


static enum Opcode {
	DAT, MOV, ADD, SUB, JMP, JMZ, JMN,
	DJN, CMP, SLT, SPL, EQU, END
};

static char *OpcodeString[] = {
	"dat", "mov", "add", "sub", "jmp", "jmz", "jmn",
	"djn", "cmp", "slt", "spl", "equ", "end", ""
};

static enum Mode {
	IMMEDIATE, DIRECT, INDIRECT, PREDECREMENT
};

static char *ModeString[] = {
	"#", " ", "@", "<"
};


typedef struct label {
	char label[81];			/* Label in the program */
	int address;			/* Address the label occures at */
	struct label *next;		/* Next label in the program */
} LABEL;

typedef struct program {
	char filename[81];		/* Name of the program */
	int length;			/* Length of the program */
	int address;			/* Start address in core */
	int start;			/* Start line in program */
	int index;			/* Index into the list */
	int wins;			/* Winning results */
	int losses;			/* Losing results */
	int ties;			/* Tying results */
	int twins;			/* Total wins */
	int tlosses;			/* Total losses */
	int tties;			/* Total ties */
	struct program *next;		/* Next program */
} PROGRAM;

typedef struct Statement_Register {
	int Control;			/* Opcodes and modes */
	int AField;			/* Address of operand #1 */
	int BField;			/* Address of operand #2 */
	int Owner;			/* Ownership of the code */
	int Aging;			/* How long since last change */
} CORE;

typedef struct CoreNode {
	struct CoreNode *last;		/* Last task to execute */
	int PC;				/* Pointer counter for task */
	struct CoreNode *next;		/* Next task to execute; */
} TASKS;
