#include "corewar.h"

extern int Size;
extern int Cycles;
extern int Battles;
extern int Refresh;
extern int Display;
extern int Stats;
extern int Config;
extern int Results;
extern int Totals;
extern int Fight;
extern int Fade;
extern int Arena;


int ReadConfig(filename)
char *filename;
{
	char buffer[81], *p, *q, *r;
	FILE *fp;
	
	if (!(fp = fopen(filename,"r"))) {
		printf("Could not open configuration file %s!\n",filename);
		return (0);
	}

	while (fgets(buffer,80,fp)) {
		if (!FixInput(buffer,&p)) continue;

		q = p;
		while (*q && !isspace(*q)) q++;
		if (*q) r = q+1;
		else r = q;
		*q++ = '\0';

		while (*r && !isspace(*r)) r++;
		*r++ = '\0';

		if (!strcasecmp(p,"SIZE")) {
			if (!*q) {
				printf("Missing value for SIZE command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for SIZE command.\n");
				return (0);
			}

			Size = atoi(q);
			if (Size < 0) {
				printf("Value negative for SIZE command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"CYCLES")) {
			if (!*q) {
				printf("Missing value for CYCLES command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for CYCLES command.\n");
				return (0);
			}

			Cycles = atoi(q);
			if (Cycles < 0) {
				printf("Value negative for CYCLES command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"BATTLES")) {
			if (!*q) {
				printf("Missing value for BATTLES command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for BATTLES command.\n");
				return (0);
			}

			Battles = atoi(q);
			if (Battles < 0) {
				printf("Value negative for BATTLES command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"DISPLAY")) {
			if (!*q) {
				printf("Missing value for DISPLAY command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for DISPLAY command.\n");
				return (0);
			}

			Display = atoi(q);
			if (Display < 0) {
				printf("Value negative for DISPLAY command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"FADE")) {
			if (!*q) {
				printf("Missing value for FADE command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for FADE command.\n");
				return (0);
			}

			Fade = atoi(q);
			if (Fade < 0) {
				printf("Value negative for FADE command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"ARENA")) {
			if (!*q) {
				printf("Missing value for ARENA command.\n");
				return (0);
			}

			if (!isdigit(*q)) {
				printf("Bad value used for ARENA command.\n");
				return (0);
			}

			Arena = atoi(q);
			if (Arena < 0) {
				printf("Value negative for ARENA command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"STATS")) {
			if (!*q) {
				printf("Missing value for STATS command.\n");
				return (0);
			}

			if (!strcasecmp(q,"ON")) Stats = ON;
			else if (!strcasecmp(q,"OFF")) Stats = OFF;
			else {
				printf("Bad value used for STATS command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"CONFIG")) {
			if (!*q) {
				printf("Missing value for CONFIG command.\n");
				return (0);
			}

			if (!strcasecmp(q,"ON")) Config = ON;
			else if (!strcasecmp(q,"OFF")) Config = OFF;
			else {
				printf("Bad value used for CONFIG command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"RESULTS")) {
			if (!*q) {
				printf("Missing value for RESULTS command.\n");
				return (0);
			}

			if (!strcasecmp(q,"ON")) Results = ON;
			else if (!strcasecmp(q,"OFF")) Results = OFF;
			else {
				printf("Bad value used for RESULTS command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"TOTALS")) {
			if (!*q) {
				printf("Missing value for TOTALS command.\n");
				return (0);
			}

			if (!strcasecmp(q,"ON")) Totals = ON;
			else if (!strcasecmp(q,"OFF")) Totals = OFF;
			else {
				printf("Bad value used for TOTALS command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"FIGHT")) {
			if (!*q) {
				printf("Missing value for FIGHT command.\n");
				return (0);
			}

			if (!strcasecmp(q,"SINGLES")) Fight = SINGLES;
			else if (!strcasecmp(q,"CHALLENGE")) Fight = CHALLENGE;
			else if (!strcasecmp(q,"ROUNDS")) Fight = ROUNDS;
			else if (!strcasecmp(q,"DEBUG")) Fight = DEBUG;
			else {
				printf("Bad value used for FIGHT command.\n");
				return (0);
			}
		} else if (!strcasecmp(p,"REDCODE")) {
			if (!*q) {
				printf("Missing value for REDCODE command.\n");
				return (0);
			}

			if (chdir(q)) {
				printf("Could not find directory %s!\n",q);
				return (0);
			}
		}
	}

	return (1);
}

int PrintConfig()
{
	printf("Size      %8d\n",Size);
	printf("Cycles    %8d\n",Cycles);
	printf("Battles   %8d\n",Battles);
	printf("Display   %8d\n",Display);
	if (Stats) printf("Stats           ON\n");
	else printf("Stats          OFF\n");
	if (Config) printf("Config          ON\n");
	else printf("Config         OFF\n");
	if (Results) printf("Results         ON\n");
	else printf("Results        OFF\n");
	if (Totals) printf("Totals          ON\n");
	else printf("Totals         OFF\n");
	if (Fight == SINGLES) printf("Fight      SINGLES\n");
	else if (Fight == CHALLENGE) printf("Fight    CHALLENGE\n");
	else if (Fight == ROUNDS) printf("Fight       ROUNDS\n");
	else if (Fight == DEBUG) printf("Fight        DEBUG\n");
	printf("\n");

	return (1);
}
