/* 
************************************************************************
*   File: constants.c                                   Part of CircleMUD *
*  Usage: Numeric and string contants used by the MUD                     *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */
/*  Changed only for earring items */

#include "structs.h"

const char circlemud_version[] = {
"CircleMUD, version 3.00 beta patchlevel 3\r\n"};


/* strings corresponding to ordinals/bitvectors in structs.h ***********/


/* (Note: strings for class definitions in class.c instead of here) */


/* cardinal directions */
const char *dirs[] =
{
  "north",
  "east",
  "south",
  "west",
  "up",
  "down",
  "\n"
};

/* Trap Types */
const char *trap_types[] = {
  "Unknown",
  "Sleep Trap",
  "Poison Gas Trap",
  "Dart Trap",
  "Arrow Trap",
  "Boulder Trap",
  "Pit Trap",
  "Teleport Trap",
  "Fear Trap",
  "\n"
};

/* ROOM_x */
const char *room_bits[] = {
  "DARK",
  "DEATH",
  "!MOB",
  "INDOORS",
  "PEACEFUL",
  "SOUNDPROOF",
  "!TRACK",
  "!MAGIC",
  "TUNNEL",
  "PRIVATE",
  "GODROOM",
  "HOUSE",
  "HCRSH",
  "ATRIUM",
  "CHAOS",
  "*",				/* BFS MARK */
  "\n"
};


/* EX_x */
const char *exit_bits[] = {
  "DOOR",
  "CLOSED",
  "LOCKED",
  "PICKPROOF",
  "\n"
};


/* SECT_ */
const char *sector_types[] = {
  "INSIDE",
  "CITY",
  "FIELD",
  "FOREST",
  "HILLS",
  "MOUNTAINS",
  "WATER-SWIM",
  "WATER-NO-SWIM",
  "UNDERWATER",
  "MID-AIR",
  "\n"
};


/* SEX_x */
const char *genders[] =
{
  "Neutral",
  "Male",
  "Female"
};


/* POS_x */
const char *position_types[] = {
  "Dead",
  "Mortally wounded",
  "Incapacitated",
  "Stunned",
  "Sleeping",
  "Resting",
  "Sitting",
  "Fighting",
  "Standing",
  "Mounted",
  "\n"
};

/* Immortal level abbrevs */
const char *immort_abbrevs[] = {
  "PRPT",
  "SANT",
  "SPRT",
  "DIVN",
  "ANGL", 
  "ARCH",
  "GRTA",
  "AVTR",
  "DEIT",
  "LORD",
  "\n"
};

/* Immortal levels */
const char *immort_levels[] = {
  "Prophet",
  "Saint",
  "Holy Spirit",
  "Divine",
  "Angel",
  "Archangel",
  "Greatest Angel",
  "Avatar",
  "Deity",
  "Lord",
  "\n"
};

/* PLR_x */
const char *player_bits[] = {
  "KILLER",
  "THIEF",
  "FROZEN",
  "DONTSET",
  "WRITING",
  "MAILING",
  "CSH",
  "SITEOK",
  "NOSHOUT",
  "NOTITLE",
  "DELETED",
  "LOADRM",
  "!WIZL",
  "!DEL",
  "INVST",
  "CRYO",
  "\n"
};

/* MOUNT_TYPE_x */
const char *mount_type[] = {
  "Riding",
  "Draft",
  "Light War",
  "Medium War",
  "Heavy War",
  "\n"
};


/* MOB_x */
const char *action_bits[] = {
  "SPEC",
  "SENTINEL",
  "SCAVENGER",
  "ISNPC",
  "NICE-THIEF",
  "AGGR",
  "STAY-ZONE",
  "WIMPY",
  "AGGR_EVIL",
  "AGGR_GOOD",
  "AGGR_NEUTRAL",
  "MEMORY",
  "HELPER",
  "!CHARM",
  "!SUMMN",
  "!SLEEP",
  "!BASH",
  "!BLIND",
  "AWARE",
  "DOUBLE_HIT",
  "TRIPLE_HIT",
  "MOUNT",
  "5X_HIT",
  "7X_HIT",
  "9X_HIT",
  "HUNTER",
  "\n"
};

/* MOB2_x */
const char *action_bits2[] = {
  "\n"
};

/* PRF_x */
const char *preference_bits[] = {
  "BRIEF",
  "COMPACT",
  "DEAF",
  "!TELL",
  "D_HP",
  "D_MANA",
  "D_MOVE",
  "AUTOEX",
  "!HASS",
  "QUEST",
  "SUMN",
  "!REP",
  "LIGHT",
  "C1",
  "C2",
  "!WIZ",
  "L1",
  "L2",
  "!AUC",
  "!GOS",
  "!GTZ",
  "RMFLG",
  "AUTOSPLIT",
  "LOOTALL",
  "LOOTGOLD",
  "AUTOCOND",
  "BATL_BRF",
  "D_EXP",
  "\n"
};


/* AFF_x */
const char *affected_bits[] = 
{
  "BLIND",
  "INVIS",
  "DET-ALIGN",
  "DET-INVIS",
  "DET-MAGIC",
  "SENSE-LIFE",
  "WATERWALK",
  "SANCT",
  "GROUP",
  "CURSE",
  "INFRA",
  "POISON",
  "PROT-EVIL",
  "PROT-GOOD",
  "SLEEP",
  "!TRACK",
  "DODGE",
  "SUPER-SANCT",
  "SNEAK",
  "HIDE",
  "INSPIRE",
  "CHARM",
  "AID",
  "FLY",
  "HASTE",
  "FIRESHIELD",
  "MUTE",
  "MIRROR-IMAGE",
  "SLOW",
  "WATERBREATHE",
  "\n"
};

/* AFF2_x */
const char *affected_bits2[] =
{
  "SUP-INVIS",
  "TURNED",
  "DEAF",
  "REGENERATION",
  "IMMUNE_FIRE",
  "IMMUNE_COLD",
  "RESIST-FIRE",
  "RESIST-COLD",
  "TRUESIGHT",
  "DISEASE-LEPROSY",
  "DISEASE-INFLUENZA",
  "DISEASE-PLAGUE",
  "FEAR",
  "CONFUSED",
  "INVIS-UNDEAD",
  "ASTRAL-SPELL",
  "SYNAPTIC-STATIC",
  "HEIGHTENED-SENSES",
  "MENTAL-INVIS",
  "MEDITATING",
  "\n"
};
  
/* CON_x */
const char *connected_types[] = {
  "Playing",
  "Disconnecting",
  "Get name",
  "Confirm name",
  "Get password",
  "Get new PW",
  "Confirm new PW",
  "Select sex",
  "Select class",
  "Reading MOTD",
  "Main Menu",
  "Get descript.",
  "Changing PW 1",
  "Changing PW 2",
  "Changing PW 3",
  "Self-Delete 1",
  "Self-Delete 2",
  "Fake password",
  "\n"
};


/* WEAR_x - for eq list */
const char *where[] = {
  "<used as light>      ",
  "<worn on finger>     ",
  "<worn on finger>     ",
  "<worn around neck>   ",
  "<worn around neck>   ",
  "<worn on body>       ",
  "<worn on head>       ",
  "<worn on legs>       ",
  "<worn on feet>       ",
  "<worn on hands>      ",
  "<worn on arms>       ",
  "<worn as shield>     ",
  "<worn about body>    ",
  "<worn about waist>   ",
  "<worn around wrist>  ",
  "<worn around wrist>  ",
  "<wielded>            ",
  "<held>               ",
  "<worn as earring>    ",
  "<worn as earring>    "
};


/* WEAR_x - for stat */
const char *equipment_types[] = {
  "Used as light",
  "Worn on right finger",
  "Worn on left finger",
  "First worn around Neck",
  "Second worn around Neck",
  "Worn on body",
  "Worn on head",
  "Worn on legs",
  "Worn on feet",
  "Worn on hands",
  "Worn on arms",
  "Worn as shield",
  "Worn about body",
  "Worn around waist",
  "Worn around right wrist",
  "Worn around left wrist",
  "Wielded",
  "Held",
  "Worn on right ear",
  "Worn on left ear",
  "\n"
};


/* ITEM_x (ordinal object types) */
const char *item_types[] = {
  "UNDEFINED",
  "LIGHT",
  "SCROLL",
  "WAND",
  "STAFF",
  "WEAPON",
  "FIRE WEAPON",
  "MISSILE",
  "TREASURE",
  "ARMOR",
  "POTION",
  "WORN",
  "OTHER",
  "TRASH",
  "TRAP",
  "CONTAINER",
  "NOTE",
  "LIQ CONTAINER",
  "KEY",
  "FOOD",
  "MONEY",
  "PEN",
  "BOAT",
  "FOUNTAIN",
  "INSTRUMENT",
  "CRYSTAL",
  "HOLY-SYMBOL",
  "\n"
};


/* ITEM_WEAR_ (wear bitvector) */
const char *wear_bits[] = {
  "TAKE",
  "FINGER",
  "NECK",
  "BODY",
  "HEAD",
  "LEGS",
  "FEET",
  "HANDS",
  "ARMS",
  "SHIELD",
  "ABOUT",
  "WAIST",
  "WRIST",
  "WIELD",
  "HOLD",
  "EAR",
  "\n"
};


/* ITEM_x (extra bits) */
const char *extra_bits[] = {
  "GLOW",
  "HUM",
  "!RENT",
  "!DONATE",
  "!INVIS",
  "INVISIBLE",
  "MAGIC",
  "!DROP",
  "BLESS",
  "!GOOD",
  "!EVIL",
  "!NEUTRAL",
  "!MAGE",
  "!CLERIC",
  "!THIEF",
  "!WARRIOR",
  "!SELL",
  "!RANGER",
  "!BARD",
  "!PALADIN",
  "!PSIONICIST",
  "NOMORT",
  "2HND",
  "WSPELL",
  "\n"
};

/* ITEM2_x */
const char *extra2_bits[] = {
  "ANTI_PIXIE",
  "ANTI_DRACON",
  "ANTI_VAMPYRE",
  "FLAMING",
   "\n"
};

/* APPLY_x */
const char *apply_types[] = {
  "NONE",
  "STR",
  "DEX",
  "INT",
  "WIS",
  "CON",
  "CHA",
  "CLASS",
  "LEVEL",
  "AGE",
  "CHAR_WEIGHT",
  "CHAR_HEIGHT",
  "MAXMANA",
  "MAXHIT",
  "MAXMOVE",
  "GOLD",
  "EXP",
  "ARMOR",
  "HITROLL",
  "DAMROLL",
  "SAVING_PARA",
  "SAVING_ROD",
  "SAVING_PETRI",
  "SAVING_BREATH",
  "SAVING_SPELL",
  "MANA_REGEN",
  "HIT_REGEN",
  "MOVE_REGEN",
  "GOLD_WEIGHT",
  "SAVING_ALL",
  "STEAL %",
  "BACKSTAB %",
  "KICK %",
  "PUMMEL %",
  "BASH %",
  "CIRCLE %",
  "BERSERK %",
  "SNEAK %",
  "HIDE %",
  "CLAW %",
  "SAVE_FIRE",
  "SAVE_COLD",
  "SAVE_MENTAL",
  "SAVE_POISON",
  "SAVE_CHARM",
  "SAVE_BLIND",
  "SAVE_FEAR",
  "SAVE_SHOCK",
  "SAVE_ACID",
  "SAVE_DEATH",
  "SAVE_DISEASE",
  "\n"
};


/* CONT_x */
const char *container_bits[] = {
  "CLOSEABLE",
  "PICKPROOF",
  "CLOSED",
  "LOCKED",
  "\n",
};


/* LIQ_x */
const char *drinks[] =
{
  "water",
  "beer",
  "wine",
  "ale",
  "dark ale",
  "whisky",
  "lemonade",
  "firebreather",
  "local speciality",
  "slime mold juice",
  "milk",
  "tea",
  "coffee",
  "blood",
  "salt water",
  "clear water",
  "\n"
};


/* other constants for liquids ******************************************/


/* one-word alias for each drink */
const char *drinknames[] =
{
  "water",
  "beer",
  "wine",
  "ale",
  "ale",
  "whisky",
  "lemonade",
  "firebreather",
  "local",
  "juice",
  "milk",
  "tea",
  "coffee",
  "blood",
  "salt",
  "water",
  "\n"
};


/* effect of drinks on hunger, thirst, and drunkenness -- see values.doc */
const int drink_aff[][3] = {
  {0, 1, 10},
  {3, 2, 5},
  {5, 2, 5},
  {2, 2, 5},
  {1, 2, 5},
  {6, 1, 4},
  {0, 1, 8},
  {10, 0, 0},
  {3, 3, 3},
  {0, 4, -8},
  {0, 3, 6},
  {0, 1, 6},
  {0, 1, 6},
  {0, 2, -1},
  {0, 1, -2},
  {0, 0, 13}
};


/* color of the various drinks */
const char *color_liquid[] =
{
  "clear",
  "brown",
  "clear",
  "brown",
  "dark",
  "golden",
  "red",
  "green",
  "clear",
  "light green",
  "white",
  "brown",
  "black",
  "red",
  "clear",
  "crystal clear"
};


/* level of fullness for drink containers */
const char *fullness[] =
{
  "less than half ",
  "about half ",
  "more than half ",
  ""
};


/* str, int, wis, dex, con applies **************************************/


/* [ch] strength apply (all) */
const struct str_app_type str_app[] = {
  {-5, -4, 0, 0},  /* level 0 */
  {-5, -4, 3, 1},
  {-3, -2, 3, 2},
  {-3, -1, 10, 3},
  {-2, -1, 25, 4},
  {-2, -1, 55, 5},
  {-1, 0, 80, 6},
  {-1, 0, 90, 7},
  {0, 0, 100, 8},
  {0, 0, 100, 9},
  {0, 0, 115, 10},
  {1, 0, 115, 11},
  {4, 0, 140, 12},
  {7, 0, 140, 13},
  {10, 0, 170, 14},
  {13, 1, 170, 15},
  {15, 1, 195, 16},
  {17, 1, 220, 17},
  {19, 2, 255, 18},   /* str is 18 */
  {32, 7, 640, 19},  /* str = 19 */
  {35, 8, 700, 20},
  {40, 9, 810, 21},
  {45, 10, 970, 22},
  {50, 11, 1130, 23},
  {60, 12, 1440, 24},
  {70, 14, 1750, 25},  /* str = 25 */
  {19, 3, 280, 50},   /* str is 18 and stradd is from 0-50 */
  {23, 3, 305, 75},   /* str is 18 and stradd is from 51-75 */
  {25, 4, 330, 90},  /* you get the point..76-90 */
  {27, 5, 380, 99},  /* 91-99 */
  {30, 6, 480, 100} /* 100 */
};


/* [dex] skill apply (thieves only) */
const struct dex_skill_type dex_app_skill[36] = {
  {-99, -99, -90, -99, -60},
  {-90, -90, -60, -90, -50},
  {-80, -80, -40, -80, -45},
  {-70, -70, -30, -70, -40},
  {-60, -60, -30, -60, -35},
  {-50, -50, -20, -50, -30},
  {-40, -40, -20, -40, -25},
  {-30, -30, -15, -30, -20},
  {-20, -20, -15, -20, -15},
  {-15, -10, -10, -20, -10},
  {-10, -5, -10, -15, -5},
  {-5, 0, -5, -10, 0},
  {0, 0, 0, -5, 0},
  {0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0},
  {0, 5, 0, 0, 0},
  {5, 10, 0, 5, 5},
  {10, 15, 5, 10, 10},
  {15, 20, 10, 15, 15},
  {15, 20, 10, 15, 15},
  {20, 25, 10, 15, 20},
  {20, 25, 15, 20, 20},
  {25, 25, 15, 20, 20},
  {25, 30, 15, 25, 25},
  {25, 30, 15, 25, 25},
  {30, 30, 20, 25, 25},
  {30, 30, 20, 25, 25},
  {30, 35, 20, 30, 30},
  {30, 35, 20, 30, 30},
  {35, 35, 25, 30, 30},
  {35, 35, 25, 35, 35},
  {35, 35, 25, 35, 35},
  {35, 40, 25, 35, 35},
  {35, 40, 30, 35, 35},
  {40, 40, 30, 35, 35}		/* 35 */
};



/* [level] backstab multiplyer (thieves only) */
const byte backstab_mult[MAX_LEVELS] = {
  1,				/* 0 */
  2,				/* 1 */
  2,
  2,
  2,	/* 5 */
  2,
  2,
  2,
  2,
  3,
  3,
  3,
  3,	
  3,
  3,
  3,
  4,
  4,	
  4,
  4,  /* 20 */
  4,
  4,
  4,	
  5,
  5,
  5,
  5,
  5,
  5,
  5,
  5,
  5,
  6, 
  6,
  6,
  6,
  6,
  6,
  6,	
  6, /* 40 */
  6,
  6,
  7, 
  7,
  7,
  7,
  7,
  7,
  7,
  8, /* 50 */
  8,
  8,
  8,
  8,
  8,
  8,
  8,
  8,
  8,
  8,
  20
};



/* [dex] apply (all) */
struct dex_app_type dex_app[36] = {
  {-7, -7, 6},
  {-6, -6, 5},
  {-4, -4, 5},
  {-3, -3, 4},
  {-2, -2, 3},
  {-1, -1, 2},
  {0, 0, 1},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, -1},
  {1, 1, -2},
  {2, 2, -3},
  {2, 2, -4},
  {3, 3, -4},
  {3, 3, -4},
  {4, 4, -5},
  {4, 4, -5},
  {4, 4, -5},
  {5, 5, -6},
  {5, 5, -6},
  {5, 5, -6},
  {5, 5, -6},
  {6, 6, -7},
  {6, 6, -7},
  {6, 6, -7},
  {6, 6, -7},
  {7, 7, -8},
  {7, 7, -8},
  {7, 7, -8},
  {7, 7, -6}			/* 35 */
};



/* [con] apply (all) */
struct con_app_type con_app[36] = {
  {-4, 20},
  {-3, 25},
  {-3, 30},
  {-3, 35},
  {-3, 40},
  {-2, 45},
  {-2, 50},
  {-2, 55},
  {-1, 60},
  {-1, 65},
  {-1, 70},
  {0, 75},
  {0, 80},
  {0, 85},
  {1, 88},
  {1, 90},
  {2, 95},
  {3, 97},
  {4, 99},
  {3, 99},
  {4, 99},
  {5, 99},
  {5, 99},
  {5, 99},
  {6, 99},
  {6, 99},
  {6, 100},
  {7, 100},
  {7, 100},
  {7, 100},
  {7, 100},
  {8, 100},
  {8, 100},
  {8, 100},
  {8, 100},
  {9, 100}			/* 35 */
};



/* [int] apply (all) */
struct int_app_type int_app[36] = {
  {3},
  {5},				/* 1 */
  {7},
  {8},
  {9},
  {10},				/* 5 */
  {11},
  {12},
  {13},
  {15},
  {17},				/* 10 */
  {19},
  {22},
  {25},
  {30},
  {35},				/* 15 */
  {40},
  {45},
  {50},
  {53},
  {55},				/* 20 */
  {56},
  {57},
  {58},
  {59},
  {60},				/* 25 */
  {61},
  {62},
  {63},
  {64},
  {65},				/* 30 */
  {66},
  {69},
  {70},
  {80},
  {99}				/* 35 */
};


/* [wis] apply (all) */
struct wis_app_type wis_app[36] = {
  {0},				/* 0 */
  {0},				/* 1 */
  {0},
  {0},
  {0},
  {0},				/* 5 */
  {0},
  {0},
  {0},
  {0},
  {0},				/* 10 */
  {0},
  {2},
  {2},
  {3},
  {3},				/* 15 */
  {3},
  {4},
  {5},				/* 18 */
  {6},
  {6},				/* 20 */
  {6},
  {6},
  {7},
  {7},
  {7},				/* 25 */
  {7},
  {8},
  {8},
  {8},
  {8},				/* 30 */
  {8},
  {8},
  {8},
  {9},
  {9}				/* 35 */
};



const char *spell_wear_off_msg[] = {
  "RESERVED DB.C",		/* 0 */
  "You feel less protected.",	/* 1 */
  "!Teleport!",
  "You feel less righteous.",
  "You feel a cloak of blindness disolve.",
  "!Burning Hands!",		/* 5 */
  "!Call Lightning",
  "You feel more self-confident.",
  "You feel your strength return.",
  "!Clone!",
  "!Color Spray!",		/* 10 */
  "!Control Weather!",
  "!Create Food!",
  "!Create Water!",
  "!Cure Blind!",
  "!Cure Critic!",		/* 15 */
  "!Cure Light!",
  "You feel more optimistic.",
  "You feel less aware.",
  "Your eyes stop tingling.",
  "The detect magic wears off.",/* 20 */
  "The detect poison wears off.",
  "!Dispel Evil!",
  "!Earthquake!",
  "!Enchant Weapon!",
  "!Energy Drain!",		/* 25 */
  "!Fireball!",
  "!Harm!",
  "!Heal!",
  "You feel yourself exposed.",
  "!Lightning Bolt!",		/* 30 */
  "!Locate object!",
  "!Magic Missile!",
  "You feel less sick.",
  "You feel less protected.",
  "!Remove Curse!",		/* 35 */
  "The white aura around your body fades.",
  "!Shocking Grasp!",
  "You feel less tired.",
  "You feel weaker.",
  "!Summon!",			/* 40 */
  "!Ventriloquate!",
  "!Word of Recall!",
  "!Remove Poison!",
  "You feel less aware of your suroundings.",
  "!Animate Dead!",		/* 45 */
  "!Dispel Good!",
  "!Group Armor!",
  "!Group Heal!",
  "!Group Recall!",
  "Your night vision seems to fade.",	/* 50 */
  "Your feet seem less boyant.",
  "!EnchantArmor!",
  "!Restore!",
  "Your shimmering golden aura fades away.",
  "!Succor!",
  "!Petrify!",
  "You feel less inspired.",
  "You slowly float back to the ground.",
  "You once again move at a normal pace.",
  "!Calm!",
  "You are no longer protected from fire.",
  "Your protection from light fades.",
  "!Mental Blast!",
  "!Remove Sanct!",
  "You regain your speech!",
  "You duplicate images fade away.",
  "You feel less aided.",
  "!CAUSECRITIC!",
  "!CAUSELIGHT!",
  "!CAUSESERIOUS!",
  "!FLAMESTRIKE!",
  "Your actions speed back up to normal.",
  "You no longer feel the affects of the acid touch.",
  "You no longer feel pumped for battle.",
  "Your lent health returns to you.",
  "Your psyche unscrambles.",
  "!WRATHOFGOD!",
  "Your bodies displacement returns to normal.",
  "!Self Heal!",
  "Your strength returns to normal.",
  "Your flesh becomes soft again.",
  "Your magical gills dissappear!!",
  "You are no longer held against your will.",
  "Your sense of bravery subsides.",
  "!DISINTEGRATE!",		/* 85 */
  "!ENERGYBLAST!",
  "!ABSOLUTEZERO!",
  "!PRISMATICMISSILE!",
  "!WORDOFDEATH!",
  "!INCENDIARYCLOUD!",	/* 90 */
  "!ACIDSPRAY!",
  "!CHAINLIGHTNING!",
  "!ICESTORM!",
  "!METEORSWARM!",
  "!SUPERNOVA!",		/* 95 */
  "!Cure Serious!",
  "You become visible again",
  "Your adrenalin boost fades",
  "Your susceptibility to fire fades",
  "Your susceptibility to cold fades",   /* 100 */
  "Your hearing returns",
  "!TURNUNDEAD!",
  "Your bodies healing returns to normal",
  "You become vulnerable to fire again",
  "You become vulnerable to cold again", /* 105 */
  "!SPIRITUALHAMMER!",
  "!CUREDEAFNESS!",
  "Your sight returns to normal.",
  "Your purple flames evaporate.",
  "!POWERHEAL!",			/* 110 */
  "Your globe of minor spell immunity expires.",
  "!GROUPPOWERHEAL!",
  "!ATONEMENT!",
  "!CORRUPTION!",
  "You strength returns to your body.",	/* 115 */
  "!MONSUM_I!.",
  "The magical vestment around your body fades.",
  "The wonderous prayer's effects fade.",
  "!CONTINUALLIGHT!",
  "Your body's immune system finally purges the disease.", /* 120 */
  "!CUREDISEASE!",
  "The magically induced fear subsides.",
  "!REMOVEFEAR!",
  "You are no longer confused.",
  "!FLAMEBLADE!",					/* 125 */
  "Your body is now visible to the ranks of the dead.",
  "!HOLYWORD!",
  "!UNHOLYWORD",
  "Your body returns to the normal plane of existance.",
  "!RESURRECTION!",
/* The list of skills 131 - 200 */
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
"!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!", "!SKILL!",
  "!IDENTIFY!",  /* 200 */
  "Your mental static ends abruptly.",  
  "!PSISWORD!",
  "!MINDTHRUST!",
  "!PROJECTFORCE!",
  "Your heightened charisma fades.",  /* 205 */
  "!ATTRACTION!",
  "You lose your mental state of focusness.",
  "!CANNIBALIZE!",
  "!EGOWHIP!",
  "!BALLISTICATTACK!",		/* 210 */
  "Your heightened senses return to normal.",
  "!COMPLETEHEALING!",
  "!IDINSINUATION!",
  "!ULTRABLASE!",
  "Your mind no longer blocks your awarness of your attackers.",
  "!DETONATE!"
};


/* Itch is trying to add classes for mobs...dont hold your breath */

const char *npc_class_types[] = {
  "Normal",
  "Undead",
  "Humanoid",
  "Animal",
  "Dragon",
  "Giant",
  "Elemental",
  "Planar",
  "Golem",
  "Statue",
  "Tiny",
  "Dark",
  "Godly",
  "\n"
};

const int rev_dir[] =
{
  2,
  3,
  0,
  1,
  5,
  4
};


const int movement_loss[] =
{
  1,				/* Inside     */
  1,				/* City       */
  2,				/* Field      */
  3,				/* Forest     */
  4,				/* Hills      */
  6,				/* Mountains  */
  4,				/* Swimming   */
  1				/* Unswimable */
};


const char *weekdays[7] = {
  "the Day of the Moon",
  "the Day of the Bull",
  "the Day of the Deception",
  "the Day of Thunder",
  "the Day of Freedom",
  "the day of the Great Gods",
"the Day of the Sun"};


const char *month_name[17] = {
  "Month of Winter",		/* 0 */
  "Month of the Winter Wolf",
  "Month of the Frost Giant",
  "Month of the Old Forces",
  "Month of the Grand Struggle",
  "Month of the Spring",
  "Month of Nature",
  "Month of Futility",
  "Month of the Dragon",
  "Month of the Sun",
  "Month of the Heat",
  "Month of the Battle",
  "Month of the Dark Shades",
  "Month of the Shadows",
  "Month of the Long Shadows",
  "Month of the Ancient Darkness",
  "Month of the Great Evil"
};


const int sharp[] = {
  0,
  0,
  0,
  1,				/* Slashing */
  0,
  0,
  0,
  0,				/* Bludgeon */
  0,
  0,
  0,
0};				/* Pierce   */

const char *COLOR_HELP =
"\r\n"
"COLOR HELP\r\n"
"\r\n"
"Types:\r\n"
"  0 - Normal,    1 - Room Title,  2 - Room Exits,  3 - Tell\r\n"
"  4 - Gossip,    5 - Say,         6 - Shouts,      7 - Wiznet\r\n"
"  8 - Persons,   9 - Objects,    10 - Syslog,     11 - Poof In/Out\r\n"
" 12 - GroupSay, 13 - Interwiz\r\n"
"\r\n"
"Colors:\r\n"
"  0 - Black,           1 - Red,          2 - Green\r\n"
"  3 - Gold,            4 - Blue          5 - Magenta\r\n"
"  6 - Cyan,            7 - Gray,         8 - Light Red\r\n"
"  9 - Light Green,    10 - Yellow,      11 - Bright Blue\r\n"
" 12 - Bright Magenta, 13 - Bright Cyan, 14 - Bright White\r\n"
"\r\n"
"SYNTAX:  colorset <type> <color>\r\n";

/*  TO BE ADDED LATER
"Background Colors:\r\n"
"  0 - Black,		1 - Red,	  2 - Green\r\n"
"  3 - Gold,		4 - Blue,	  5 - Magenta\r\n"
"  6 - Cyan,		7 - Gray\r\n"
"\r\n"
*/
