/* skin skill
   by dsw june 1996
  1- be sure to  #define SKILL_SKIN <number> in spells.h
  2- 
 */

#include <stdio.h>
#include <string.h>
#include "conf.h"
#include "sysdep.h"
#include "structs.h"
#include "utils.h"
#include "comm.h"
#include "interpreter.h"
#include "handler.h"
#include "db.h"
#include "spells.h"

extern struct room_data *world;
void extract_obj(struct obj_data *obj);
struct obj_data *read_object(int rnum, int number);

ACMD(do_skin)
{
    char arg1[MAX_INPUT_LENGTH];
    struct obj_data *cont, *obj;
    int temp, i, found=0;

    one_argument(argument, arg1);

    if (!*arg1)
    { send_to_char("Skin what?\r\n", ch);
      return;
    }
 /* need to check to make sure they are trying to skin a corpse */
    if(strcmp(arg1, "corpse"))
    { send_to_char("Just skin corpses.\r\n", ch);
      return;
    }
 /* need to make sure they are wielding an object before checking its type */
    if(!GET_EQ(ch, WEAR_WIELD))
    { send_to_char("Not with your bare hands.\r\n", ch);
      return;
    } 
 /* of course if you have races, maybe clawed races could skin corpses
     without a weapon */
 /* You may want to change this to some type of cutting weapon. */
    if(GET_OBJ_TYPE(GET_EQ(ch, WEAR_WIELD)) != ITEM_WEAPON)
    { send_to_char("Can't skin with that!\r\n", ch);
      return; 
    }
    if((cont = get_obj_in_list_vis(ch, &arg1[0],world[ch->in_room].contents)))
      found = 1;
         
    if (found)
    {   
      if ((number(0, GET_SKILL(ch, SKILL_SKIN))) < 10)
      {
 /* Don't bother imms with skill checks */
      if(GET_LEVEL(ch) < LVL_IMMORT)
      {
        send_to_char("You crudely hack at the corpse awhile.\r\n", ch);
        act("$n spends some time crudely hacking at the corpse.", TRUE, ch, 0,
          0, TO_ROOM);
        return;
      }
     }
   found = 0;
   for(i = 0; i < 4; i++)
   {
   if(cont->obj_flags.skin_data[i] == 0)
     continue;
/* Note: you can't use object vnum 0 with this. */
   if((temp = real_object(cont->obj_flags.skin_data[i])) > 0)
    {   
    found = 1;
    obj = read_object( temp, REAL);
    obj_to_room(obj, ch->in_room);
    act("You skin $p from the corpse!", TRUE, ch, obj, 0, TO_CHAR);
    act("$n skins $p from the corpse!", TRUE, ch, obj, 0, TO_ROOM);
    }
   }
   if(!found)
   {
   act("You spend some time crudely hacking that the corpse.", TRUE, ch, 0,
     0, TO_CHAR);
   act("$n spends some time crudely hacking at the corpse.", TRUE, ch, 0,
      0, TO_ROOM);
   }
   extract_obj(cont);
   return; 
 }
send_to_char("Just skin corpses ok?\r\n", ch);
}

void assign_skin_value(struct char_data *ch, struct obj_data *corpse)
{ int i;
/* DON'T pass  PC to this routine! */
for(i = 0; i < 4; i++)
 corpse->obj_flags.skin_data[i] = ch->mob_specials.skin_data[i];
return;
}
