#ifndef __WATCOMC__
#include <grx20.h>

/* Graphics emulation libraries to simulate missing Watcom graphics
 * calls for DJGPP
 *
 * Used by gredit.c
 *
 * Copyright (c) 1991-1996 Mike Marcelais
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 *
 */

/*
 * Modified From DFLTFONT.C
 */

static char far fnt8x8bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 
   0xbd, 0x99, 0x81, 0x7e, 0x7e, 0xff, 0xdb, 0xff, 0xc3, 0xe7, 0xff, 0x7e, 
   0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 
   0x3e, 0x1c, 0x08, 0x00, 0x1c, 0x1c, 0x1c, 0x7f, 0x7f, 0x6b, 0x08, 0x1c, 
   0x10, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x10, 0x38, 0x00, 0x00, 0x18, 0x3c, 
   0x3c, 0x18, 0x00, 0x00, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 
   0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0xff, 0xc3, 0x99, 0xbd, 
   0xbd, 0x99, 0xc3, 0xff, 0x0f, 0x07, 0x0f, 0x7d, 0xcc, 0xcc, 0xcc, 0x78, 
   0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x3f, 0x33, 0x3f, 0x30, 
   0x30, 0x70, 0xf0, 0xe0, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x67, 0xe6, 0xc0, 
   0x18, 0xdb, 0x3c, 0xe7, 0xe7, 0x3c, 0xdb, 0x18, 0x80, 0xe0, 0xf8, 0xfe, 
   0xf8, 0xe0, 0x80, 0x00, 0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00, 
   0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x66, 0x66, 0x66, 0x66, 
   0x66, 0x00, 0x66, 0x00, 0x7f, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x00, 
   0x3e, 0x63, 0x38, 0x6c, 0x6c, 0x38, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00, 
   0x7e, 0x7e, 0x7e, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0xff, 
   0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 
   0x7e, 0x3c, 0x18, 0x00, 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00, 
   0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 
   0xc0, 0xfe, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00, 
   0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 
   0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00, 0x6c, 0x6c, 0x6c, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 
   0x18, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x18, 0x00, 0x00, 0x63, 0x66, 0x0c, 
   0x18, 0x33, 0x63, 0x00, 0x1c, 0x36, 0x1c, 0x3b, 0x6e, 0x66, 0x3b, 0x00, 
   0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 
   0x30, 0x18, 0x0c, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 
   0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x30, 0x30, 0xfc, 
   0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 
   0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x18, 0x18, 0x00, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x40, 0x00, 
   0x3e, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x3e, 0x00, 0x18, 0x38, 0x58, 0x18, 
   0x18, 0x18, 0x7e, 0x00, 0x3c, 0x66, 0x06, 0x1c, 0x30, 0x66, 0x7e, 0x00, 
   0x3c, 0x66, 0x06, 0x1c, 0x06, 0x66, 0x3c, 0x00, 0x0e, 0x1e, 0x36, 0x66, 
   0x7f, 0x06, 0x0f, 0x00, 0x7e, 0x60, 0x7c, 0x06, 0x06, 0x66, 0x3c, 0x00, 
   0x1c, 0x30, 0x60, 0x7c, 0x66, 0x66, 0x3c, 0x00, 0x7e, 0x66, 0x06, 0x0c, 
   0x18, 0x18, 0x18, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x3c, 0x00, 
   0x3c, 0x66, 0x66, 0x3e, 0x06, 0x0c, 0x38, 0x00, 0x00, 0x18, 0x18, 0x00, 
   0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, 
   0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x7e, 0x00, 
   0x00, 0x7e, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 
   0x3c, 0x66, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x00, 0x3e, 0x63, 0x6f, 0x69, 
   0x6f, 0x60, 0x3e, 0x00, 0x18, 0x3c, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x00, 
   0x7e, 0x33, 0x33, 0x3e, 0x33, 0x33, 0x7e, 0x00, 0x1e, 0x33, 0x60, 0x60, 
   0x60, 0x33, 0x1e, 0x00, 0x7c, 0x36, 0x33, 0x33, 0x33, 0x36, 0x7c, 0x00, 
   0x7f, 0x31, 0x34, 0x3c, 0x34, 0x31, 0x7f, 0x00, 0x7f, 0x31, 0x34, 0x3c, 
   0x34, 0x30, 0x78, 0x00, 0x1e, 0x33, 0x60, 0x60, 0x67, 0x33, 0x1f, 0x00, 
   0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 
   0x18, 0x18, 0x3c, 0x00, 0x0f, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00, 
   0x73, 0x33, 0x36, 0x3c, 0x36, 0x33, 0x73, 0x00, 0x78, 0x30, 0x30, 0x30, 
   0x31, 0x33, 0x7f, 0x00, 0x63, 0x77, 0x7f, 0x7f, 0x6b, 0x63, 0x63, 0x00, 
   0x63, 0x73, 0x7b, 0x6f, 0x67, 0x63, 0x63, 0x00, 0x3e, 0x63, 0x63, 0x63, 
   0x63, 0x63, 0x3e, 0x00, 0x7e, 0x33, 0x33, 0x3e, 0x30, 0x30, 0x78, 0x00, 
   0x3c, 0x66, 0x66, 0x66, 0x6e, 0x3c, 0x0e, 0x00, 0x7e, 0x33, 0x33, 0x3e, 
   0x36, 0x33, 0x73, 0x00, 0x3c, 0x66, 0x30, 0x18, 0x0c, 0x66, 0x3c, 0x00, 
   0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x66, 0x66, 0x66, 0x66, 
   0x66, 0x66, 0x7e, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 
   0x63, 0x63, 0x63, 0x6b, 0x7f, 0x77, 0x63, 0x00, 0x63, 0x63, 0x36, 0x1c, 
   0x1c, 0x36, 0x63, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x3c, 0x00, 
   0x7f, 0x63, 0x46, 0x0c, 0x19, 0x33, 0x7f, 0x00, 0x3c, 0x30, 0x30, 0x30, 
   0x30, 0x30, 0x3c, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01, 0x00, 
   0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x08, 0x1c, 0x36, 0x63, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
   0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x06, 
   0x3e, 0x66, 0x3b, 0x00, 0x70, 0x30, 0x30, 0x3e, 0x33, 0x33, 0x6e, 0x00, 
   0x00, 0x00, 0x3c, 0x66, 0x60, 0x66, 0x3c, 0x00, 0x0e, 0x06, 0x06, 0x3e, 
   0x66, 0x66, 0x3b, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00, 
   0x1c, 0x36, 0x30, 0x78, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x3b, 0x66, 
   0x66, 0x3e, 0x06, 0x7c, 0x70, 0x30, 0x36, 0x3b, 0x33, 0x33, 0x73, 0x00, 
   0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x06, 0x00, 0x06, 0x06, 
   0x06, 0x66, 0x66, 0x3c, 0x70, 0x30, 0x33, 0x36, 0x3c, 0x36, 0x73, 0x00, 
   0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x66, 0x7f, 
   0x7f, 0x6b, 0x63, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x00, 
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x6e, 0x33, 
   0x33, 0x3e, 0x30, 0x78, 0x00, 0x00, 0x3b, 0x66, 0x66, 0x3e, 0x06, 0x0f, 
   0x00, 0x00, 0x6e, 0x3b, 0x33, 0x30, 0x78, 0x00, 0x00, 0x00, 0x3e, 0x60, 
   0x3c, 0x06, 0x7c, 0x00, 0x08, 0x18, 0x3e, 0x18, 0x18, 0x1a, 0x0c, 0x00, 
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3b, 0x00, 0x00, 0x00, 0x66, 0x66, 
   0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x63, 0x6b, 0x7f, 0x7f, 0x36, 0x00, 
   0x00, 0x00, 0x63, 0x36, 0x1c, 0x36, 0x63, 0x00, 0x00, 0x00, 0x66, 0x66, 
   0x66, 0x3e, 0x06, 0x7c, 0x00, 0x00, 0x7e, 0x4c, 0x18, 0x32, 0x7e, 0x00, 
   0x0e, 0x18, 0x18, 0x70, 0x18, 0x18, 0x0e, 0x00, 0x0c, 0x0c, 0x0c, 0x00, 
   0x0c, 0x0c, 0x0c, 0x00, 0x70, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x70, 0x00, 
   0x3b, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 
   0x63, 0x63, 0x7f, 0x00, 0x3c, 0x66, 0x60, 0x66, 0x3c, 0x0c, 0x06, 0x3c, 
   0x00, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x1c, 0x00, 0x78, 0xcc, 
   0xfc, 0xc0, 0x78, 0x00, 0x7e, 0xc3, 0x3c, 0x06, 0x3e, 0x66, 0x3f, 0x00, 
   0x66, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x3f, 0x00, 0x70, 0x00, 0x3c, 0x06, 
   0x3e, 0x66, 0x3f, 0x00, 0x18, 0x18, 0x3c, 0x06, 0x3e, 0x66, 0x3f, 0x00, 
   0x00, 0x00, 0x3c, 0x60, 0x60, 0x3c, 0x06, 0x1c, 0x7e, 0xc3, 0x3c, 0x66, 
   0x7e, 0x60, 0x3c, 0x00, 0xcc, 0x00, 0x78, 0xcc, 0xfc, 0xc0, 0x78, 0x00, 
   0x70, 0x00, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00, 0x66, 0x00, 0x38, 0x18, 
   0x18, 0x18, 0x3c, 0x00, 0x3e, 0x63, 0x1c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 
   0x70, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x63, 0x1c, 0x36, 0x63, 
   0x7f, 0x63, 0x63, 0x00, 0x18, 0x18, 0x00, 0x3c, 0x66, 0x7e, 0x66, 0x00, 
   0x1c, 0x00, 0xfc, 0x60, 0x78, 0x60, 0xfc, 0x00, 0x00, 0x00, 0x7f, 0x0c, 
   0x7f, 0xcc, 0x7f, 0x00, 0x1f, 0x36, 0x66, 0x7f, 0x66, 0x66, 0x67, 0x00, 
   0x3c, 0x66, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x66, 0x00, 0x3c, 
   0x66, 0x66, 0x3c, 0x00, 0x00, 0x70, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00, 
   0x3c, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3f, 0x00, 0x00, 0x70, 0x00, 0x66, 
   0x66, 0x66, 0x3f, 0x00, 0x00, 0xcc, 0x00, 0xcc, 0xcc, 0x7c, 0x0c, 0xf8, 
   0xc3, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x66, 0x00, 0x66, 0x66, 
   0x66, 0x66, 0x3c, 0x00, 0x0c, 0x0c, 0x3f, 0x60, 0x60, 0x3f, 0x0c, 0x0c, 
   0x1c, 0x36, 0x32, 0x78, 0x30, 0x73, 0x7e, 0x00, 0x66, 0x66, 0x3c, 0x7e, 
   0x18, 0x7e, 0x18, 0x18, 0xf8, 0xcc, 0xcc, 0xfa, 0xc6, 0xcf, 0xc6, 0xc7, 
   0x0e, 0x1b, 0x18, 0x3c, 0x18, 0x18, 0xd8, 0x70, 0x0e, 0x00, 0x3c, 0x06, 
   0x3e, 0x66, 0x3f, 0x00, 0x1c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
   0x00, 0x0e, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x0e, 0x00, 0x66, 
   0x66, 0x66, 0x3f, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x00, 
   0x7e, 0x00, 0x66, 0x76, 0x7e, 0x6e, 0x66, 0x00, 0x1e, 0x36, 0x36, 0x1f, 
   0x00, 0x3f, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x3e, 0x00, 0x00, 
   0x18, 0x00, 0x18, 0x30, 0x60, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x7e, 
   0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0c, 0x0c, 0x00, 0x00, 
   0xc3, 0xc6, 0xcc, 0xde, 0x33, 0x66, 0xcc, 0x0f, 0xc3, 0xc6, 0xcc, 0xdb, 
   0x37, 0x6f, 0xcf, 0x03, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 
   0x00, 0x33, 0x66, 0xcc, 0x66, 0x33, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x33, 
   0x66, 0xcc, 0x00, 0x00, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 
   0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0xdb, 0x77, 0xdb, 0xee, 
   0xdb, 0x77, 0xdb, 0xee, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
   0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 
   0xf8, 0x18, 0x18, 0x18, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 0x00, 0x00, 0xf8, 0x18, 
   0xf8, 0x18, 0x18, 0x18, 0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 
   0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0xfe, 0x06, 
   0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 
   0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 0x18, 0x18, 0xf8, 0x18, 
   0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 
   0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 
   0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
   0xff, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 
   0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x36, 0x36, 0x36, 0x36, 
   0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 
   0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 0x00, 0x00, 0xff, 0x00, 
   0xff, 0x00, 0x00, 0x00, 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 
   0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 
   0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
   0x3f, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
   0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 
   0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
   0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
   0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 
   0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x64, 0x6e, 0x3b, 0x00, 
   0x00, 0x3c, 0x66, 0x7c, 0x66, 0x7c, 0x60, 0x60, 0x00, 0x7e, 0x66, 0x60, 
   0x60, 0x60, 0x60, 0x00, 0x00, 0x7f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 
   0x7e, 0x66, 0x30, 0x18, 0x30, 0x66, 0x7e, 0x00, 0x00, 0x00, 0x3f, 0x6c, 
   0x6c, 0x6c, 0x38, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x60, 
   0x00, 0x3b, 0x6e, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x7e, 0x18, 0x3c, 0x66, 
   0x66, 0x3c, 0x18, 0x7e, 0x1c, 0x36, 0x63, 0x7f, 0x63, 0x36, 0x1c, 0x00, 
   0x1c, 0x36, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00, 0x0e, 0x18, 0x0c, 0x3e, 
   0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 
   0x06, 0x0c, 0x7e, 0xdb, 0xdb, 0x7e, 0x60, 0xc0, 0x1c, 0x30, 0x60, 0x7c, 
   0x60, 0x30, 0x1c, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 
   0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 
   0x18, 0x00, 0x7e, 0x00, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 
   0x0c, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 
   0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70, 
   0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x3b, 0x6e, 0x00, 
   0x3b, 0x6e, 0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x18, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x3c, 0x1c, 
   0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x70, 0x18, 0x30, 0x60, 
   0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

struct {
    GrFont	  theFont;
    GrFontChrInfo rest[255];
} Std8x8Font = {
    {
	{			/* font header */
	    "pc8x8",		/* font name */
	    "ibmpc",		/* font family name */
	    0,			/* characters have varying width */
	    0,			/* derived from a scalable font */
	    1,			/* font permanently linked into program */
	    GR_FONTCVT_NONE,	/* "tweaked" font (resized, etc..) */
	    8,			/* width (average when proportional) */
	    8,			/* font height */
	    6,			/* baseline pixel pos (from top) */
	    7,			/* underline pixel pos (from top) */
	    1,			/* underline width */
	    0,			/* lowest character code in font */
	    256			/* number of characters in font */
	},
	fnt8x8bits,		/* character bitmap array */
	(void *)0,		/* auxilary bitmap */
	8,			/* width of narrowest character */
	8,			/* width of widest character */
	0,			/* allocated size of auxilary bitmap */
	0,			/* free space in auxilary bitmap */
	{ (void *)0	   },	/* converted character bitmap offsets */
	{ { 8,   8*0	 } }	/* first character info */
    },
    {
	{ 8,	 8*1	   },	/* remaining 255 characters */
	{ 8,	 8*2	   },
	{ 8,	 8*3	   },
	{ 8,	 8*4	   },
	{ 8,	 8*5	   },
	{ 8,	 8*6	   },
	{ 8,	 8*7	   },
	{ 8,	 8*8	   },
	{ 8,	 8*9	   },
	{ 8,	 8*10	   },
	{ 8,	 8*11	   },
	{ 8,	 8*12	   },
	{ 8,	 8*13	   },
	{ 8,	 8*14	   },
	{ 8,	 8*15	   },
	{ 8,	 8*16	   },
	{ 8,	 8*17	   },
	{ 8,	 8*18	   },
	{ 8,	 8*19	   },
	{ 8,	 8*20	   },
	{ 8,	 8*21	   },
	{ 8,	 8*22	   },
	{ 8,	 8*23	   },
	{ 8,	 8*24	   },
	{ 8,	 8*25	   },
	{ 8,	 8*26	   },
	{ 8,	 8*27	   },
	{ 8,	 8*28	   },
	{ 8,	 8*29	   },
	{ 8,	 8*30	   },
	{ 8,	 8*31	   },
	{ 8,	 8*32	   },
	{ 8,	 8*33	   },
	{ 8,	 8*34	   },
	{ 8,	 8*35	   },
	{ 8,	 8*36	   },
	{ 8,	 8*37	   },
	{ 8,	 8*38	   },
	{ 8,	 8*39	   },
	{ 8,	 8*40	   },
	{ 8,	 8*41	   },
	{ 8,	 8*42	   },
	{ 8,	 8*43	   },
	{ 8,	 8*44	   },
	{ 8,	 8*45	   },
	{ 8,	 8*46	   },
	{ 8,	 8*47	   },
	{ 8,	 8*48	   },
	{ 8,	 8*49	   },
	{ 8,	 8*50	   },
	{ 8,	 8*51	   },
	{ 8,	 8*52	   },
	{ 8,	 8*53	   },
	{ 8,	 8*54	   },
	{ 8,	 8*55	   },
	{ 8,	 8*56	   },
	{ 8,	 8*57	   },
	{ 8,	 8*58	   },
	{ 8,	 8*59	   },
	{ 8,	 8*60	   },
	{ 8,	 8*61	   },
	{ 8,	 8*62	   },
	{ 8,	 8*63	   },
	{ 8,	 8*64	   },
	{ 8,	 8*65	   },
	{ 8,	 8*66	   },
	{ 8,	 8*67	   },
	{ 8,	 8*68	   },
	{ 8,	 8*69	   },
	{ 8,	 8*70	   },
	{ 8,	 8*71	   },
	{ 8,	 8*72	   },
	{ 8,	 8*73	   },
	{ 8,	 8*74	   },
	{ 8,	 8*75	   },
	{ 8,	 8*76	   },
	{ 8,	 8*77	   },
	{ 8,	 8*78	   },
	{ 8,	 8*79	   },
	{ 8,	 8*80	   },
	{ 8,	 8*81	   },
	{ 8,	 8*82	   },
	{ 8,	 8*83	   },
	{ 8,	 8*84	   },
	{ 8,	 8*85	   },
	{ 8,	 8*86	   },
	{ 8,	 8*87	   },
	{ 8,	 8*88	   },
	{ 8,	 8*89	   },
	{ 8,	 8*90	   },
	{ 8,	 8*91	   },
	{ 8,	 8*92	   },
	{ 8,	 8*93	   },
	{ 8,	 8*94	   },
	{ 8,	 8*95	   },
	{ 8,	 8*96	   },
	{ 8,	 8*97	   },
	{ 8,	 8*98	   },
	{ 8,	 8*99	   },
	{ 8,	 8*100	   },
	{ 8,	 8*101	   },
	{ 8,	 8*102	   },
	{ 8,	 8*103	   },
	{ 8,	 8*104	   },
	{ 8,	 8*105	   },
	{ 8,	 8*106	   },
	{ 8,	 8*107	   },
	{ 8,	 8*108	   },
	{ 8,	 8*109	   },
	{ 8,	 8*110	   },
	{ 8,	 8*111	   },
	{ 8,	 8*112	   },
	{ 8,	 8*113	   },
	{ 8,	 8*114	   },
	{ 8,	 8*115	   },
	{ 8,	 8*116	   },
	{ 8,	 8*117	   },
	{ 8,	 8*118	   },
	{ 8,	 8*119	   },
	{ 8,	 8*120	   },
	{ 8,	 8*121	   },
	{ 8,	 8*122	   },
	{ 8,	 8*123	   },
	{ 8,	 8*124	   },
	{ 8,	 8*125	   },
	{ 8,	 8*126	   },
	{ 8,	 8*127	   },
	{ 8,	 8*128	   },
	{ 8,	 8*129	   },
	{ 8,	 8*130	   },
	{ 8,	 8*131	   },
	{ 8,	 8*132	   },
	{ 8,	 8*133	   },
	{ 8,	 8*134	   },
	{ 8,	 8*135	   },
	{ 8,	 8*136	   },
	{ 8,	 8*137	   },
	{ 8,	 8*138	   },
	{ 8,	 8*139	   },
	{ 8,	 8*140	   },
	{ 8,	 8*141	   },
	{ 8,	 8*142	   },
	{ 8,	 8*143	   },
	{ 8,	 8*144	   },
	{ 8,	 8*145	   },
	{ 8,	 8*146	   },
	{ 8,	 8*147	   },
	{ 8,	 8*148	   },
	{ 8,	 8*149	   },
	{ 8,	 8*150	   },
	{ 8,	 8*151	   },
	{ 8,	 8*152	   },
	{ 8,	 8*153	   },
	{ 8,	 8*154	   },
	{ 8,	 8*155	   },
	{ 8,	 8*156	   },
	{ 8,	 8*157	   },
	{ 8,	 8*158	   },
	{ 8,	 8*159	   },
	{ 8,	 8*160	   },
	{ 8,	 8*161	   },
	{ 8,	 8*162	   },
	{ 8,	 8*163	   },
	{ 8,	 8*164	   },
	{ 8,	 8*165	   },
	{ 8,	 8*166	   },
	{ 8,	 8*167	   },
	{ 8,	 8*168	   },
	{ 8,	 8*169	   },
	{ 8,	 8*170	   },
	{ 8,	 8*171	   },
	{ 8,	 8*172	   },
	{ 8,	 8*173	   },
	{ 8,	 8*174	   },
	{ 8,	 8*175	   },
	{ 8,	 8*176	   },
	{ 8,	 8*177	   },
	{ 8,	 8*178	   },
	{ 8,	 8*179	   },
	{ 8,	 8*180	   },
	{ 8,	 8*181	   },
	{ 8,	 8*182	   },
	{ 8,	 8*183	   },
	{ 8,	 8*184	   },
	{ 8,	 8*185	   },
	{ 8,	 8*186	   },
	{ 8,	 8*187	   },
	{ 8,	 8*188	   },
	{ 8,	 8*189	   },
	{ 8,	 8*190	   },
	{ 8,	 8*191	   },
	{ 8,	 8*192	   },
	{ 8,	 8*193	   },
	{ 8,	 8*194	   },
	{ 8,	 8*195	   },
	{ 8,	 8*196	   },
	{ 8,	 8*197	   },
	{ 8,	 8*198	   },
	{ 8,	 8*199	   },
	{ 8,	 8*200	   },
	{ 8,	 8*201	   },
	{ 8,	 8*202	   },
	{ 8,	 8*203	   },
	{ 8,	 8*204	   },
	{ 8,	 8*205	   },
	{ 8,	 8*206	   },
	{ 8,	 8*207	   },
	{ 8,	 8*208	   },
	{ 8,	 8*209	   },
	{ 8,	 8*210	   },
	{ 8,	 8*211	   },
	{ 8,	 8*212	   },
	{ 8,	 8*213	   },
	{ 8,	 8*214	   },
	{ 8,	 8*215	   },
	{ 8,	 8*216	   },
	{ 8,	 8*217	   },
	{ 8,	 8*218	   },
	{ 8,	 8*219	   },
	{ 8,	 8*220	   },
	{ 8,	 8*221	   },
	{ 8,	 8*222	   },
	{ 8,	 8*223	   },
	{ 8,	 8*224	   },
	{ 8,	 8*225	   },
	{ 8,	 8*226	   },
	{ 8,	 8*227	   },
	{ 8,	 8*228	   },
	{ 8,	 8*229	   },
	{ 8,	 8*230	   },
	{ 8,	 8*231	   },
	{ 8,	 8*232	   },
	{ 8,	 8*233	   },
	{ 8,	 8*234	   },
	{ 8,	 8*235	   },
	{ 8,	 8*236	   },
	{ 8,	 8*237	   },
	{ 8,	 8*238	   },
	{ 8,	 8*239	   },
	{ 8,	 8*240	   },
	{ 8,	 8*241	   },
	{ 8,	 8*242	   },
	{ 8,	 8*243	   },
	{ 8,	 8*244	   },
	{ 8,	 8*245	   },
	{ 8,	 8*246	   },
	{ 8,	 8*247	   },
	{ 8,	 8*248	   },
	{ 8,	 8*249	   },
	{ 8,	 8*250	   },
	{ 8,	 8*251	   },
	{ 8,	 8*252	   },
	{ 8,	 8*253	   },
	{ 8,	 8*254	   },
	{ 8,	 8*255	   }
    }
};


GrTextOption stdText = { &Std8x8Font.theFont, {0}, {0}, 0, 0, 0, 0 };

/* Symbolic Constants used */
#define _DEFAULTMODE   0  /* Should be a text mode */
#define _VRES16COLOR   1  /* Should be 640x480x16 */

/* Unused */
#define _GCLEARSCREEN  0

/* how to fill */
#define _GBORDER       0  /* Just draw the border */
#define _GFILLINTERIOR 1  /* Fill in the interior */

short __grcolor = 1;
short __grlocx = 0;
short __grlocy = 0;

inline void _setcolor(short x)      { __grcolor = x; };
inline void _moveto(short x,short y){ __grlocx = x; __grlocy = y; };

#define _setpixel(x,y) GrPlot(x,y,__grcolor)

void _outgtext(const char *s)
{
   
   stdText.txo_fgcolor.v = __grcolor;
   GrDrawString((void *)s, strlen(s), __grlocx, __grlocy, &stdText);
   __grlocx += 8*strlen(s);
};

short _setvideomode(short m)
{
   if (m)
      return(GrSetMode(GR_width_height_color_graphics, 640, 480, 16));
   else
      return(GrSetMode(GR_default_text));
};

void _lineto(short x, short y)
{
   GrLine(__grlocx, __grlocy, x, y, __grcolor);
   __grlocx = x;
   __grlocy = y;
};

void _rectangle(short fill, short x1, short y1, short x2, short y2)
{
   if (fill == _GBORDER)
      GrBox(x1,y1,x2,y2,__grcolor);
   else
      GrFilledBox(x1,y1,x2,y2,__grcolor);
};

#define _clearscreen(x)       ScreenClear();

#endif /* __WATCOMC__ */
