/*
 * humandate - convert an NTP time to something readable
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#ifdef RS6000
#include <time.h>
#endif
#include <sys/socket.h>
#include <netinet/in.h>

#include "ntp_fp.h"
#include "ntp_unixtime.h"
#include "lib_strbuf.h"

char *
humandate(ntptime)
	u_long ntptime;
{
	char *bp;
	struct tm *tm;
	u_long sec;
	static char *months[] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
	static char *days[] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	};

	LIB_GETBUF(bp);
	
	sec = ntptime - JAN_1970;
	tm = localtime((long *)&sec);

	(void) sprintf(bp, "%s, %s %2d %4d %2d:%02d:%02d",
	    days[tm->tm_wday], months[tm->tm_mon], tm->tm_mday,
	    1900+tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec);
	
	return bp;
}
