/*
 *  md5crypt - MD5 based authentication routines
 */

#include <sys/types.h>
#include "md5.h"

extern u_long cache_keyid;
extern char *cache_key;
extern int cache_keylen;

/*
 * Stat counters, imported from data base module
 */
extern u_long authencryptions;
extern u_long authdecryptions;
extern u_long authkeyuncached;
extern u_long authdecryptok;
extern u_long authnokey;

/*
 * For our purposes an NTP packet looks like:
 *
 *	a variable amount of encrypted data, multiple of 8 bytes, followed by:
 *	NOCRYPT_OCTETS worth of unencrypted data, followed by:
 *	BLOCK_OCTETS worth of ciphered checksum.
 */ 
#define	NOCRYPT_OCTETS	4
#define	BLOCK_OCTETS	16

#define	NOCRYPT_LONGS	((NOCRYPT_OCTETS)/sizeof(u_long))
#define	BLOCK_LONGS	((BLOCK_OCTETS)/sizeof(u_long))

int
MD5authdecrypt(keyno, pkt, length)
    u_long keyno;
    u_long *pkt;
    int length;		/* length of variable data in octets */
{
    MD5_CTX ctx;

    authdecryptions++;

    if (keyno != cache_keyid) {
	authkeyuncached++;
	if (!authhavekey(keyno))
	    return 0;
    }

    MD5Init(&ctx);
    MD5Update(&ctx, cache_key, cache_keylen);
    MD5Update(&ctx, (char *)pkt, length);
    MD5Final(&ctx);

    return (0 == bcmp(ctx.digest, (char *)pkt + length + 4, BLOCK_OCTETS));
}

