/*
 *  $Header: /src/NTP/v3/xntp/kernel/RCS/dcftest.c,v 1.2 1992/07/06 13:42:42 kardel Exp $
 *
 *  $Id: dcftest.c,v 1.2 1992/07/06 13:42:42 kardel Exp $
 *
 *  Copyright (c) 1989,1990,1991,1992
 *  Frank Kardel Friedrich-Alexander Universitaet Erlangen-Nuernberg
 *                                    
 *  This code can be modified and used freely provided that the
 *  credits remain intact.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  $Log: dcftest.c,v $
 * Revision 1.2  1992/07/06  13:42:42  kardel
 * ver for new STREAM module
 *
 * Revision 1.1  1992/07/05  16:43:01  kardel
 * Initial revision
 *
 *  Revision 1.3  1992/03/13  16:57:32  kardel
 *  legal terms changed
 *
 *  Revision 1.2  1991/12/16  11:07:29  kardel
 *  RCS Id in startup printf
 *
 *  Revision 1.1  1991/12/16  11:03:17  kardel
 *  Initial revision
 *
 */

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/errno.h>
#include <sundev/mbvar.h>
#include <sun/autoconf.h>
#include <sys/time.h>
#ifdef u3b2
#include <sys/psw.h>
#include <sys/pcb.h>
#endif
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/dir.h>
#include <sys/signal.h>
#include <sys/user.h>
#include <sys/errno.h>
#include <fcntl.h>
#include "dcf77.h"

char *strstatus(buffer, state)
  char *buffer;
  unsigned long state;
{
  static struct bits
    {
      unsigned long bit;
      char         *name;
    } flagstrings[] =
    {
      { DCFB_ANNOUNCE, "DST SWITCH WARNING" },
      { DCFB_POWERUP,  "NOT SYNCHONIZED" },
      { DCFB_NOSYNC,   "TIME CODE NOT CONFIRMED" },
      { DCFB_DST,      "DST IN EFFECT" },
      { DCFB_UTC,      "UTC DISPLAY" },
      { DCFB_LEAP,     "LEAP WARNING" },
      { DCFB_ALTERNATE,"ALTERNATE ANTENNA" },
      { 0 }
    };
  int i;

  *buffer = '\0';
  
  i = 0;
  while (flagstrings[i].bit)
    {
      if (flagstrings[i].bit & state)
	{
	  if (buffer[0])
	    strcat(buffer, ", ");
	  strcat(buffer, flagstrings[i].name);
	}
      i++;
    }
  if (state & (DCFB_S_LEAP|DCFB_S_LOCATION))
    {
      if (buffer[0])
	strcat(buffer, ", ");
      strcat(buffer, "supported: ");
      if (DCF_S_LEAP(state)) strcat(buffer, "LEAP");
      if (buffer[0])
	strcat(buffer, ", ");
      if (DCF_S_LOCATION(state)) strcat(buffer, "LOCATION");
    }
  return buffer;
}

main(argc, argv)
  int argc;
  char **argv;
{
  if (argc != 2)
    {
      fprintf(stderr,"usage: %s <dcf-device>\n", argv[0]);
      exit(1);
    }
  else
    {
      int fd;
      
      fd = open(argv[1], O_RDWR);
      if (fd == -1)
	{
	  perror(argv[1]);
	  exit(1);
	}
      else
	{
	  dcfctl_t  dct;
	  dcftime_t dcftime;
	  struct strioctl strioc;
	  
	  char ch;
	  
	  printf("dcftest $Id: dcftest.c,v 1.2 1992/07/06 13:42:42 kardel Exp $\n");
	  
	  while (ioctl(fd, I_POP, 0) == 0)
	    ;

	  if (ioctl(fd, I_PUSH, "dcf") == -1)
	    {
	      perror("ioctl(I_PUSH,\"dcf\")");
	      exit(1);
	    }

	  strioc.ic_cmd = DCFIOC_GETSTAT;
	  strioc.ic_timout = 0;
	  strioc.ic_dp = (char *)&dct;
	  strioc.ic_len = sizeof(dcfctl_t);

	  if (ioctl(fd, I_STR, &strioc) == -1)
	    {
	      perror("ioctl(fd, I_STR(DCFIOC_GETSTAT))");
	      exit(1);
	    }
	  printf("dcf status: %04x\n", dct.dcfstatus.flags);

	  dct.dcfstatus.flags |= DCF_STAT_FILTER;
	  strioc.ic_cmd = DCFIOC_SETSTAT;
	  
	  if (ioctl(fd, I_STR, &strioc) == -1)
	    {
	      perror("ioctl(fd, I_STR(DCFIOC_SETSTAT))");
	      exit(1);
	    }
	  printf("DCF clock FILTERMODE\n");
	  
	  if (ioctl(fd, I_STR, &strioc) == -1)
	    {
	      perror("ioctl(fd, I_STR(DCFIOC_GETSTAT))");
	      exit(1);
	    }
	  printf("dcf status: %04x\n", dct.dcfstatus.flags);

	  while (read(fd, &dcftime, sizeof(dcftime)) == sizeof(dcftime))
	    {
	      char tmp[60], tmp1[60];

	      strncpy(tmp, asctime(localtime(&dcftime.dcf_time.tv_sec)), 30);
              strncpy(tmp1,asctime(localtime(&dcftime.dcf_stime.tv_sec)), 30);
	      tmp[24]  = '\0';
	      tmp1[24] = '\0';

	      printf("%s (+%06dus) %s ", tmp1, dcftime.dcf_stime.tv_usec, tmp);

	      strstatus(tmp, dcftime.dcf_state);
	      printf("flags: 0x%2x, status: %08x (%s) error: %d usec dispersion: %d\n",
		     dcftime.dcf_flags,
		     dcftime.dcf_state,
		     tmp,
		     dcftime.dcf_usecerror,
		     dcftime.dcf_usecdisp);
	    }
	  
	  close(fd);
	}
    }
}

