
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

static char rcsid[]=
  "$Header: /nfs/u5/braden/NNStat/src/RCS/hostname.c,v 3.2 92/12/02 16:22:30 braden Rel $";
 
#include <sys/types.h> 
#include <sys/param.h>
#include <stdio.h>

#ifdef ISI4_2
#include <netdb.h-bind>
#else
#include <netdb.h>
#endif

#include <ctype.h>
#include <netinet/in.h>
#include "collect.h"

/* dotted10
   Checks that a string is a legal (4-part dotted decimal) internet address. 
   Returns the address in network byte order if successful, otherwise, -1.
*/

u_long
dotted10(cp)
   register char *cp;
{
   register u_long val;
   register char c;
   u_long parts[4], *pp = parts;
   int i;

again:
   /* Collect number up to ``.''.  */
   val = 0;
   while (c = *cp) {
      if (isdigit(c)) {
         val = (val * 10) + (c - '0');
         cp++;
         continue;
         }
      break;
      }
   if (*cp == '.') {
      /* Internet format: a.b.c.d  */
      if (pp >= parts + 4)
         return (-1);
      *pp++ = val, cp++;
      goto again;
      }
   /* Check for trailing characters. */
   if (*cp && !isspace(*cp))
      return (-1);
   *pp++ = val;
   
   /*  Address must have four parts. */
   if ((pp - parts) != 4)
      return (-1);
      
   /* a.b.c.d -- 8.8.8.8 bits */
   for (i=0;i<4;i++) if (parts[i] > 0xff) return(-1);
   val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |
            ((parts[2] & 0xff) << 8) | (parts[3] & 0xff);
   val = htonl(val);
   return (val);
} /* dotted10 */

boolean
isbroadcast(ipaddr)
   u_long *ipaddr;
{
   u_long class, host, mask;
   
   class= (*ipaddr >> 28) & 0xd;
   mask = (class == 0)? (0xffffff): 	/* class a */
   	  (class == 0x8)? (0xffff): 	/* class b */
	  (0xff);			/* class c */
   /* *** what about subnet mask? *** */
   host = (*ipaddr & mask);

   return((host==0) || (host==mask)); 
} /* isbroadcast */

/*
*   resolve_name(namep, adrlist, length)
*
*   Resolves host name given in specified server structure, to
*   fill in list of IP addresses and host name.  Returns number of
*   addresses if OK, else zero.
*/
                  
int
resolve_name( namep, adrlist, listlen)
   char *namep;
   u_long adrlist[];
   int listlen;
{
   register struct hostent *hp;
   u_long ipaddr;
   
#ifdef BSD4_3   
   register int i, count;
   char **ap;
#endif
   
   bzero((char *) adrlist, listlen * sizeof(u_long));

  if ((ipaddr = dotted10(namep)) != -1) {
     /* Dotted-decimal... */
     adrlist[0] = ipaddr;
     if (!isbroadcast(&adrlist[0]))
        return(1);
     }
  else	if (hp = gethostbyname(namep)) {
#ifndef BSD4_3   
     adrlist[0] = *(u_long *) (hp->h_addr);
     if (!isbroadcast(&adrlist[0]))
          return(1);
#else
     count = 0;
     ap = hp->h_addr_list;
     for (i=0;i<listlen && *ap ;i++) {
	count++;
	adrlist[i] = * (u_long *) *ap++;
	if (isbroadcast(&adrlist[i]))
	   adrlist[i--] = 0;
        }
     return(count);
#endif
     }

  adrlist[0] = 0;
  return(0);
} /* resolve_name */


/* Error check a string that contains a port number:
	if okay, return(port)
	if bad, return(0) and print to stderr
*/

int
get_port(arg, program)
   char *arg, *program;
{
   int port;
   char *cp;
	
   for (cp = arg; *cp; cp++) 
      if (! isdigit(*cp)) {
	 fprintf(stderr,"%s: Bad port: %s\n", program, arg);
	 return(0);
         }
   if (((port = atoi(arg)) < 1024) || (port > 0xffff)) {
      fprintf(stderr,"%s: Port out of range: %s\n", program, arg);
      return(0);
      }
   return(port);
} /* get_port */
