
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

       /* 
        *               stat.h
        *  Define external interface of statspy
        *
        *   $Header: /nfs/u5/braden/NNStat/src/RCS/stat.h,v 3.2 92/12/02 16:23:15 braden Rel $
        */
 
 /* CHANGES:
  *   17Nov88 ISI: Add eqf object class 
  *   29Nov88 ISI: Larger MAX_OBJNAME, MAX_LABELS
  *   17Oct89 AKS/ISI: add subnets, other ops.
  *      Rel 2.4:
  *   01Nov89 ISI: Add MAB, MSB, FAB, and FOB objects.
  *   30Mov89 ISI: Add VERSION_op.
  *      Rel 3.0:
  *   ISI: Add SELECT object
  *   ISI: Move addr(parm list) into struct invokes.
  *   ISI: Move some XDR specs into corresponding sobjXX.c files
  *   ISI: Add new DTYP for host,port pair.
  */
 
#define STATD_PORT  2222   /* Default Port */
#define WORDS(L)   ((L+3)>>2)
typedef int boolean;

    /* Request & Response Operation Codes
     */ 
#define EndofReq   0
#define EndofResp  0
#define ATTACH_op  1
#define DETACH_op  2
#define READ_op    3
#define CLEAR_op   4
#define READCL_op  5
#define SHOW_op    6
#define SHOWnames_op  7
#define SUBNET_op  8
#define Error      9
  /* Following are used for ATTACH parm strings */
#define Record     10
#define If         11
#define Ifnot      12   /* (Obsolete) */
#define IfInvoke   13
#define StartList  14
#define AppendList 15
#define And        16
#define Or         17
#define SymIf      18
#define SymIfNot   19   /* (Obsolete) */
  /* Following are used for SHOW replies */
#define StartTsubl 20
#define StartFsubl 21 
#define EndofSubl  22
#define VERSION_op 23   /* Remote inquiry of version */

#define NotIfInv   24
#define SelInvoke  25
#define Case       26
#define Select     27
#define Default    28   /* Used only for show command */


    /* Encoding of object classes 
     *  (MUST AGREE with declarations:
     *     char * class_name[] in scan.c
     *     char * class_nick[] in scan.c
     *     GENERICOP *GenOpPtr[] in attach.c)
     */
#define FOOBJ  1   /* freq-only */
#define HIOBJ  2   /* hist */
#define P2OBJ  3   /* hist-pwr2 */
#define FAOBJ  4   /* freq-all */
#define BPOBJ  5   /* bin-pkt */
#define FA2OBJ 6   /* freq-all2 */
#define RFOBJ  7   /* rangef */
#define SFOBJ  8   /* setf */
#define MAOBJ  9   /* matrix-all */
#define WSOBJ  10  /* working-set */
#define MSOBJ  11  /* matrix-sym */
#define MA2OBJ 12  /* matrix-all */
#define EQOBJ  13  /* eqf */
#define FABOBJ 14  /* freq-all-bytes */ 
#define FOBOBJ 15  /* freq-only-bytes */ 
#define MABOBJ 16  /* matrix-all-bytes */
#define MSBOBJ 17  /* matrix-sym-bytes */
#define SELECTOBJ 18 /* select statement */
#define COOBJ  19  /* Conn-stat (experimental) */ 

    /* Maximum  sizes... */
#define MAX_LABELS  128  /* max length (bytes) of an enum label */
#define MAX_OBJNAME  64  /* max length (bytes) of an object name */
#define MAX_FLDNAME  16  /* max length (bytes) of a field name */
#define MAXPARMS   256  /* Maximum number of parameter vals to object */
#define MAX_NCASES  64  /* Max number of cases in SELECT statement */

#define MAX_DLENG    8  /* Max length (bytes) of a field value */
#define LONGPERVAL  ((MAX_DLENG+3)/4)

   /* Used within STATSPY: */
#define CMD_OK    0
#define CMD_EOF  -1
#define CMD_ERR  -2
#define CMD_QUIT -3


     
struct Obj_state  {  /* Standard object state information */
    long  currtime,
            maketime,
            cleartime;
    
    u_long  totalno ;
    u_long  orphans ;
        
    int  datatype;
        /* 
         *   Data types -- for printing values nicely
         */
#define DTYP_unknown   0    /* ?? */
#define DTYP_int       1    /* Dec integer */
#define DTYP_IP        2    /* 32-bit IP address (host order) */
#define DTYP_bits      3    /* Hex */
#define DTYP_EtherA    4    /* Ethernet Address */
#define DTYP_packet    5    /* Packet   */
#define DTYP_IPsock    6    /* Host, port pair */
    
    int  dleng ;
    int  datatyp2;
    int  dleng2;
};   

    /*
     *  Define external data common to all object classes
     */
#define OBJ struct object_rep
OBJ {
    char   obj_name[MAX_OBJNAME];  /* Name of object */
    int    obj_totlength;  /* Total length of the 
                              rest of this response segment */
    struct Obj_state obj_state;
    int    obj_class;       /* Class code */
};

    /*****************************************************************
     *
     *    XDR Description of a Request to statd 
     *
     *****************************************************************  
    
    union switch(Req_code) {      -- Request Code --
     
    case READ_op:
    case REACL_op:
    case CLEAR_op:
    case SHOW_op:
    case DETACH_op:
        string Request<> ;   -- Parm String --
        
    case SUBNET_op:  /* Parm string is empty for show subnets, else
                      * it is 8 bytes of address and mask (u_char).

        string Request<> ;   -- Parm String --
    
    case ATTACH_op:
        --   Generally, this is an (operator, operand) expression in postfix
         *   order.  Interpretation is straight-forward using a stack
         *   machine.
         *
         *   The operands are invocation specifications encoded in XDR as:
         *
        string Att_Field_name_1<>;
        string Att_Field_name_2<>;  -- zero-length for unary op --
        string Att_ObjName<>;       -- zero-length for unnamed object --
        int    Att_Classno;
         *
         *   with the following external representation: */
         
struct invokes {
    char  inv_field1[MAX_FLDNAME];  /* Name of Field 1 */
    char  inv_field2[MAX_FLDNAME];  /* Name of Field 2 */
    char  inv_objname[MAX_OBJNAME]; /* Name of object */
    int   inv_classno; /* Class number */
    int   inv_nparms;  /* Number long words in parameter value array */
    u_long *inv_parmp; /* Addr of parameter value array */
} ;
        /*  The postfix operators are StartList, AppendList, If, 
         *    Ifnot, Record, or Error.
         */
            

    /*****************************************************************
     *
     *    XDR Description of a Response from statd 
     *
     *****************************************************************
        
    union switch(int Resp_code) {
    
    case 1:   -- Error --
        string Resp_Error<127> ;  
        
    case 0:   -- OK --
    
        union switch (int Resp_op) {   --  May be multiple repetitions of this
                                       --  for READ SHOW responses; after last
                                       --  repetition there will be Resp_op=0.          
        case 0:                 
                --  In this case, we depart from XDR... we allow any number
                --  of responses to the same READ or SHOW request, each
                --  beginning with the same Resp_op descriminant value;
                --  following the last one, union descriminant will be 0.           
        case DETACH_op:
            string Resp_comment<>;
                            
        case ATTACH_op:
            string Resp_comment<>;
                
        case CLEAR_op:
            string Resp_comment<>;
                                
        case SHOWnames_op:
            string Resp_comment<>;
                
        case READ_op:
            string Resp_objname<MAX_OBJNAME> ;  -- Object name --
            
            int   totlength;  -- Total length of the rest of
                                 this response segment --
            
            struct Obj_state ; -- standard prefix --
                
            union switch (int Resp_objclass)  { 
                 -- Select by Class of object --                  */
        
/***********************************************************************        
 *          case FOOBJ:    -- Frequency: Only --
 */
#define FOr_SIZE(N,L) (2 + (N)*(1+WORDS(L)))*sizeof(u_long)                 
#define MAX_FONO  256 /* Max number predefined FREQ_ONLY bins */
#define FODE struct only_dataelement

/*              u_long   FOr_other ;      */

                    /* FREQ_ONLY element */ 
                FODE {
                    u_long   fod_count; 
                    u_char   fod_value[MAX_DLENG];  /* Value for this bin */
    /* Note: the real representation of value is XDR opaque, ie byte string padded
     * to nearest fullword.
     */
                }       /* FOr_list<>  */ ;

            
/***********************************************************************        
 *          case FAOBJ:   -- Frequency: All --
 */             
#define FADE struct all_dataelement 
#define FAr_SIZE(N, L) (1 + (N)*(2+WORDS(L)))*sizeof(u_long)

                     /* FREQ_ALL data element */    
                FADE {
                    FODE   fad_fode;
                    long   fad_time;   /* Last Incr: Secs since Jan 1, 1970 */
                }       /*  FAr_list<> */ ;                 
            
#define fad_count fad_fode.fod_count
#define fad_value fad_fode.fod_value

            
/***********************************************************************        
 *          case MAOBJ:   -- Matrix: All --
 */             
#define MADE struct ma_dataelement 
#define MAr_SIZE(N, L)  (1 + (N)*(2+WORDS(L)))*sizeof(u_long)

                     /* matrix_all data element */  
                MADE {
                    u_long mad_count;
                    long mad_time;   /* Last Incr: Secs since Jan 1, 1970 */
                    u_char mad_value[2*MAX_DLENG];  /* Concatenation of
                                                       pair of values */
    /* Note: the real representation of value is XDR opaque, ie byte string padded
     * to nearest fullword.
     */
                }       /*  MAr_list<> */ ;                 
            
         
/***********************************************************************        
 *          case FOBOBJ:    -- Frequency Only - Bytes --
 */
#define FOBr_SIZE(N,L) (6 + (N)*(3+WORDS(L)))*sizeof(u_long)                 
#define FOBDE struct fob_dataelement

/*              u_long   FOBr_other ;     # default packets (not in any bin)
                u_long   FOBr_othHbytes;  Total bytes for default packets
                u_long   FOBr_othLbytes;
                u_long   FOBr_totHbytes;  Total bytes including defaults packets
                u_long   FOBr_totLbytes; 
    */

                    /* freq-only-bytes element */ 
                FOBDE {
                    u_long   fob_count;
                    u_long   fob_Hbyte;   /* Higher-order byte count */ 
                    u_long   fob_Lbyte;   /* Low-order 3 bytes of count */ 
                    u_char   fob_value[MAX_DLENG];  /* Value for this bin */
    /* Note: the real representation of value is XDR opaque, ie byte string padded
     * to nearest fullword.
     */
                }       /* FOBr_list<>  */ ;
 
            
/***********************************************************************        
 *          case FABOBJ:   -- Frequency All - Bytes --
 */             
       /* Same network representation as MABOBJ, following: */
            
/***********************************************************************        
 *          case MABOBJ:   -- Matrix All/Sym - Bytes --
 */             
#define MFBr_SIZE(N, L) (3+ (N)*(4+WORDS(L)))*sizeof(u_long)
#define MFBDE struct mfb_dataelement 
 
          /*    u_long   MFBr_Hbytes;
                u_long   MFBr_Lbytes;      */

                     /* matrix_all data element */  
                MFBDE {
                    u_long mfbd_count;  /* Freq count */
                    long   mfbd_time;   /* Last Incr: Secs since Jan 1, 1970 */
                    u_long mfbd_Hbyte;  /* High-order byte count           */
                    u_long mfbd_Lbyte;  /* Low order 3 bytes of byte count */
                    u_char mfbd_value[2*MAX_DLENG];  /* Value(s) */
    /* Note: the real representation of value is XDR opaque, ie byte string padded
     * to nearest fullword.
     */
                }       /*  MFBr_list<> */ ;                 
            
    
/***********************************************************************        
 *          case HIOBJ: -- Histogram --
 */
#define HistDATA struct hist_data
#define HIr_SIZE(n)  (1 + n)*sizeof(u_long)+sizeof(HistDATA)
#define MAX_HIBINS 1024
#define HistE u_long    /* Element (bin) */

                HistDATA {
                    u_long Hist_scalef ,
                           Hist_avg ,
                           Hist_min ,
                           Hist_max ,
                           Hist_default ;
                    };
                    
/*                  HistE HIr_count<MAX_HIBINS>;  -- bins -- 
 */

/***********************************************************************        
 *          case P2OBJ:   -- Histogram: Powers of 2 -- 
 */

#define P2DATA HistDATA
#define P2r_SIZE(n)   (1 + n)*sizeof(u_long)+sizeof(P2DATA)
#define MAX_P2BINS 32

/*              P2DATA ;                    
                HistE   P2r_count<MAX_P2BINS> ;  -- bins --
*/                          


/***********************************************************************        
 *          case WSOBJ:   -- Working Set -- Cache Misses for cache sizes
 *                              increasing as Powers of 2 -- 
 */

/*              u_long   WSr_distinct;
                u_long   WSr_count<MAX_P2BINS> ;  -- bins --
*/                          

/***********************************************************************    
 *          case BPOBJ:  -- Binary Packets --
 *
 *   NOTE:  The Resp_std.datatype field is meaningless for this class.
 *    The entire packet header is included, for display in simple hex.
 *    The XDR format is specified in sobjbp.c module.
 */
                                             

/***********************************************************************        
 *          case SFOBJ:  -- Set Filter --
 *
                u_long SFr_trueno;
 */
#define SFr_SIZE  sizeof(u_long)


/***********************************************************************    
 *          case RFOBJ:  -- Range Filter --
 *
                u_long RFr_trueno;
 */
#define RFr_SIZE  sizeof(u_long)
/***********************************************************************    
 *          case SELECTOBJ:  -- Select Object --
 *
 *         (Send only standard data)
 */
#define SELr_SIZE  0


/***********************************************************************
             } -- End of switch on Resp_objclass and READ response  --
             
 ***********************************************************************
          
        case SHOW_op:
                
            string Resp_fieldname<>;  -- Field AT which evaluation happens --
            
                   --  Generally, there follows an operator-prefix 
                   *   description of the interpretive execution trees.
                   *   Operands are invocations as defined earlier as
                   *   struct invokes under ATTACH. Operators are If, Record.
                   *   Each sublist is delimited by (StartTlist, EndofResp)
                   *   pair or (StartFlist, EndofResp) pair.                   
                 
        }  -- End of switch on Resp_op --
            
    } -- End of OK response --
                 
****/               
    
#define RESP_OK 0
#define RESP_ERROR 1
     
#define endof(x) (x + strlen(x))
#define log(s,x) {if (x) fprintf(x,s);}
extern FILE *logfp, *tracefp;

#define NONAME  "(no name)"
#define INFINITY 0x7FFFFFFF

#ifndef NET2
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#endif

    /* Supply definitions missing in RT systems */
#ifndef LITTLEEND
#ifndef ntohl
#define ntohl(x) (x)
#endif
#ifndef htonl
#define htonl(x) (x)
#endif
#endif
