
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

 
/*   PACKET STATISTICS COLLECTION PROGRAM
 *
 *   $Header: /nfs/u5/braden/NNStat/src/RCS/packet.h,v 3.2 92/12/02 16:22:35 braden Rel $
 */

#include <net/if.h>
#if !defined(BSD4_3) || defined(SUNOS4)
#include <netinet/in.h>
#endif
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>

		/* Fixed Structure of a Packet */
		
struct packet {
	struct  ether_header pk_eheader;
	union   {
		struct ether_arp pk_arphdr;
		struct ip_pkt {
			struct ip pk_iphdr ;
			   /* IP header is variable-length.  Followed by union ip_data */
		} ip_struct ;
	} ether_data ;
			
} ;
		
	  /* Contents of IP datagram */
		
union ip_data {
	struct icmp pk_icmphdr ;
	struct tcphdr pk_tcphdr ;
	struct udphdr pk_udphdr ;
} ;
