/*
 * java.net.SocketOutputStream.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <native.h>
#include "../native/java.io/FileDescriptor.h"
#include "../native/java.io/FileOutputStream.h"
#include "java.net/SocketImpl.h"
#include "java.net/SocketOutputStream.h"
#include "nets.h"

void
java_net_SocketOutputStream_socketWrite(struct Hjava_net_SocketOutputStream* this, HArray* buf, long offset, long len)
{
	int r;

	r = threadedWrite(unhand(unhand(unhand(this)->impl)->fd)->fd, &buf->data[offset], len);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}
