/*
 * instruction.h
 * Format of a partially translated instruction.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __instruction_h
#define __instruction_h

#include "gtypes.h"
#include "bytecode.h"

struct _nativeReg;

typedef enum {
	t_any,
	t_int,
	t_long,
	t_float,
	t_double,
	t_objref,
} operandType;
 
typedef enum {
	i_hard			= 0,
	i_soft			= 1,
	i_sync			= 2,
} encoding;

typedef enum {
	i_null			= 0,
	i_endblock		= 1,
} instnType;

typedef struct _operand {
	bool			valid;
	operandType		type;
	struct _nativeReg*	reg;
} operand;

#define	MAXIN			8
#define	MAXOUT			8
#define	MAXVAL			8

typedef struct _instn {
	instnType		type;
	operand			in[MAXIN];
	operand			out[MAXOUT];
	bytecode		op;
	int			value[MAXVAL];
	float			fvalue;
	int			addr;
} instn;

struct _methods;

void	dumpInstn(struct _methods*);
void	dumpExceptions(struct _methods*);
void	dumpSwitches(struct _methods*);
int	calculateAddresses(struct _methods*);
void	output(instn*, int);

typedef struct _nativeInstn {
	int		in;
	int		out;
	int		size;
	encoding	coding;
	void*		func;
} nativeInstn;

typedef struct _nativeReg {
        char*           name;
	int		regno;
        int             stack;
        operand*        lastWrite;
} nativeReg;

extern nativeInstn instnTable[];

/* Include machine specific instruction details */
#include "md.h"

#endif
