/*
 * readClassConfig.h
 * Various bits of information in a Java class file.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __readclassconfig_h
#define __readclassconfig_h

#include <stdio.h>

typedef FILE classFile;
typedef void classes;
typedef void methods;

extern FILE* include;
extern FILE* stub;
extern char className[];
extern char superName[];

extern char* translateSig(char*, FILE*, int*);
extern char* translateSigType(char*, char*);

/*
 * Add a class.
 */
#define	ADDCLASS(this, super, access, constants)			\
	if (super != 0) {						\
		int s;							\
		char* snm;						\
		snm = (char*)constants->data[constants->data[super]];	\
		for (s = 0; snm[s] != 0; s++) {				\
			if (snm[s] == '/') {				\
				superName[s] = '_';			\
			}						\
			else {						\
				superName[s] = snm[s];			\
			}						\
		}							\
		if (strcmp(superName, "java_lang_Object") == 0) {	\
			superName[0] = 0;				\
		}							\
	}

/*
 * Read and process a field.
 */
#define	READFIELD_START()						\
	fprintf(include, "/* DO NOT EDIT THIS FILE - it is machine generated */\n");\
	fprintf(include, "#include <native.h>\n");			\
	fprintf(include, "/* Header for class %s */\n", className);	\
	fprintf(include, "\n");						\
	fprintf(include, "#ifndef _Included_%s\n", className);		\
	fprintf(include, "#define _Included_%s\n", className);		\
	fprintf(include, "\n");						\
	fprintf(include, "typedef struct Class%s {\n", className);	\
	if (superName[0] != 0) {					\
		fprintf(include, "  struct Class%s super;\n\n", superName);\
	}

#define	READFIELD_END()							\
	fprintf(include, "} Class%s;\n", className);			\
	fprintf(include, "HandleTo(%s);\n\n", className)

#define	READFIELD(fp, this)						\
	do {								\
		field_info f;						\
									\
		readu2(&f.access_flags, fp);				\
		readu2(&f.name_index, fp);				\
		readu2(&f.signature_index, fp);				\
									\
		/* Ignore statics */					\
		if (f.access_flags & ACC_STATIC) {			\
			continue;					\
		}							\
		fprintf(include, "  ");					\
		translateSig((char*)constant_pool->data[f.signature_index], include, 0);\
		fprintf(include, " %s;\n", (char*)constant_pool->data[f.name_index]);\
	} while(0)

/*
 * Read and process a method.
 */
#define	READMETHOD(fp, this)						\
	do {								\
		method_info m;						\
		char* name;						\
		char* sig;						\
		char* str;						\
		char* ret;						\
		char type;						\
		int j;							\
		char rtype;						\
		int args;						\
		int isStatic;						\
									\
		readu2(&m.access_flags, fp);				\
		readu2(&m.name_index, fp);				\
		readu2(&m.signature_index, fp);				\
									\
		/* Only generate stubs for native methods */		\
		if (!(m.access_flags & ACC_NATIVE)) {			\
			continue;					\
		}							\
		args = 0;						\
		isStatic = 1;						\
		if (!(m.access_flags & ACC_STATIC)) {			\
			isStatic = 0;					\
		}							\
		/* Generate method prototype */				\
		name = (char*)constant_pool->data[m.name_index];	\
		sig = (char*)constant_pool->data[m.signature_index];	\
		ret = strchr(sig,')');					\
		ret++;							\
		fprintf(include, "extern ");				\
		translateSig(ret, include, 0);				\
		fprintf(include, " %s_%s(", className, name);		\
		str = sig + 1;						\
		if (!isStatic) {					\
			args++;						\
			fprintf(include, "struct H%s*", className);	\
			if (str[0] != ')') {				\
				fprintf(include, ", ");			\
			}						\
		}							\
		while (str[0] != ')') {					\
			str = translateSig(str, include, &args);	\
			if (str[0] != ')') {				\
				fprintf(include, ", ");			\
			}						\
		}							\
		fprintf(include, ");\n");				\
		/* Generate method stub */				\
		fprintf(stub, "\n/* SYMBOL: %s %s%s */\n", className, name, sig);\
		translateSigType(ret, &rtype);				\
									\
		switch (rtype) {					\
		case 'p':						\
			fprintf(stub, "void*\n");			\
			break;						\
		case 'i':						\
			fprintf(stub, "long\n");			\
			break;						\
		case 'd':						\
			fprintf(stub, "long long /* double */\n");	\
			break;						\
		case 'f':						\
			fprintf(stub, "int /* float */\n");		\
			break;						\
		case 'l':						\
			fprintf(stub, "long long\n");			\
			break;						\
		case 'v':						\
			fprintf(stub, "void\n");			\
			break;						\
		default:						\
			abort();					\
		}							\
		fprintf(stub, "Kaffe_%s_%s_stub(int _S_)\n", className, name);\
		fprintf(stub, "{\n");					\
		fprintf(stub, "\textern ");				\
		translateSig(ret, stub, 0);				\
		fprintf(stub, " %s_%s();\n", className, name);		\
		fprintf(stub, "\tstack_item* _P_ = (stack_item*)&_S_;\n");\
		fprintf(stub, "\t");					\
		if (rtype != 'v') {					\
			translateSig(ret, stub, 0);			\
			fprintf(stub, " ret = ");			\
		}							\
		fprintf(stub, "%s_%s(", className, name);		\
		str = sig + 1;						\
		if (!isStatic) {					\
			fprintf(stub, "_P_[%d].p", args-1);		\
			args--;						\
			if (str[0] != ')') {				\
				fprintf(stub, ", ");			\
			}						\
		}							\
		for (j = args-1; str[0] != ')'; j--) {			\
			str = translateSigType(str, &type);		\
			/* This is horrid - but basically just copy */	\
			/* the data one-for-one.		    */	\
			if (type == 'l' || type == 'd') {		\
				fprintf(stub, "_P_[%d].i, _P_[%d].i", j-1, j);\
				j--;					\
			}						\
			else {						\
				fprintf(stub, "_P_[%d].i", j);		\
			}						\
			if (str[0] != ')') {				\
				fprintf(stub, ", ");			\
			}						\
		}							\
		fprintf(stub, ");\n");					\
		if (rtype == 'f') {					\
			fprintf(stub, "\treturn *(int*)&ret;\n");	\
		}							\
		else if (rtype == 'd') {				\
			fprintf(stub, "\treturn *(long long*)&ret;\n");	\
		}							\
		else if (rtype != 'v') {				\
			fprintf(stub, "\treturn ret;\n");		\
		}							\
		fprintf(stub, "}\n");					\
	} while(0)

#endif
