/*
 * i386-netbsd.1.x-md.h
 * FreeBSD i386 specific information (registers, exceptions, etc.)
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __i386_freebsd_md_h
#define __i386_freebsd_md_h

/* Nr. of registers used to map stack */
#define	NRREG		4

#define	REG_eax		0
#define	REG_ecx		1
#define	REG_edx		2
#define	REG_ebx		3
#define	REG_esp		4
#define	REG_ebp		5
#define	REG_esi		6
#define	REG_edi		7

#define	REG_BASE	REG_ebp
#define	REG_STACK	REG_esp

#define	INSTRUCTION_PUSH(r)						\
	asm__pushl_R(r->regno)

#define	INSTRUCTION_POP(r)						\
	asm__popl_R(r->regno)

#define	INSTRUCTION_PROLOGUE(sz)					\
	asm__pushl_R(REG_ebp);						\
	asm__movl_RxR(REG_esp, REG_ebp);				\
	asm__subl_VxR((sz)*4, REG_esp);

#define	INSTRUCTION_MONITORENTER(m)					\
	if (m->accflags & ACC_STATIC) {					\
		asm__pushl_V(m->class);					\
	}								\
	else {								\
		asm__movl_VoRoxR(4 * ((m->ins+1)+1), REG_BASE, REG_eax);\
		asm__pushl_R(REG_eax);					\
	}								\
	asm__call_X(soft_monitorenter);					\
	asm__addl_VxR(4, REG_STACK)

#define	LOCAL_FIXUP(offset, nargs)					\
	((offset) >= (nargs) ? (nargs) - (offset) - 1: (nargs) - (offset) + 1)

#define	CALL_KAFFE_FUNCTION_VARARGS(f, o, a, ap)			\
	asm("	pushal							\n\
		movl %%esp,%%ebp					\n\
		pushl %1						\n\
1:		cmpl $0,%2						\n\
		je 2f							\n\
		pushl (%3)						\n\
		addl $4,%3						\n\
		subl $1,%2						\n\
		jmpl 1b							\n\
2:									\n\
		call *%0						\n\
		movl %%ebp,%%esp					\n\
		popal" : : "r" (f), "r" (o), "r" (a), "r" (ap))

#define	CALL_KAFFE_EXCEPTION(frame, info, obj)				\
	asm("	pushl %2						\n\
		movl %0,%%ebp						\n\
		jmpl *%1						\n\
		" : : "g" (frame->retbp), "r" (info.handler), "g" (obj))

/**/
/* Exception handling information */
/**/

typedef struct _exceptionFrame {
	int			retbp;
	int			retpc;
} exceptionFrame;

#define EXCEPTIONPROTO          int sig, int code, struct sigcontext* ctx  

#define	FIRSTFRAME(f)		(exceptionFrame*)(((int)&f) - 12)
#define EXCEPTIONFRAME(f,c)     (f).retbp = (c)->sc_ebp;                \
                                (f).retpc = (c)->sc_eip       
#define	NEXTFRAME(f)		(exceptionFrame*)((f)->retbp)
#define	FRAMEOKAY(f)		((f)->retbp >= (int)currentThread->eetop->stackBase\
				&& (f)->retbp < (int)currentThread->eetop->stackEnd)

/**/
/* Thread handling */
/**/

#define	THREADSTACKSIZE		(32 * 1024)

#define	THREADSWITCH(to, from)					\
	asm("	pushl $1f					\n\
		pushal						\n\
		movl %%esp,%0					\n\
		movl %1,%%esp					\n\
		popal						\n\
		ret						\n\
1:		nop						\n\
		" : : "g" (from->restorePoint), "g" (to->restorePoint))

#define	THREADINIT(to, func)					\
	asm("							\n\
		movl %0,-4(%1)					\n\
		movl $0,-8(%1)  # eax 				\n\
		movl $0,-12(%1) # ecx 				\n\
		movl $0,-16(%1) # edx 				\n\
		movl $0,-20(%1) # ebx 				\n\
		movl $0,-24(%1) # --- 				\n\
		movl $0,-28(%1) # ebp 				\n\
		movl $0,-32(%1) # esi 				\n\
		movl $0,-36(%1) # edi 				\n\
		" : : "r" (func), "r" (to->stackEnd));		\
		to->restorePoint = to->stackEnd - 36

#define	THREADINFO(ee)						\
		do {						\
			void** ptr;				\
			asm("movl %%ebp,%0" : "=r" (ptr));	\
			while (*ptr != 0) {			\
				ptr = (void**)*ptr;		\
			}					\
			(ee)->restorePoint = 0;			\
			(ee)->stackBase = (void*)ptr - THREADSTACKSIZE;	\
			(ee)->stackEnd = (void*)ptr;		\
		} while(0)

#define	THREADFRAMES(tid, cnt)					\
		do {						\
			void** ptr;				\
			cnt = 0;				\
			if (tid == currentThread) {		\
				asm("movl %%ebp,%0" : "=r" (ptr));\
			}					\
			else {					\
				ptr = ((void***)tid->eetop->restorePoint)[2];\
			}					\
			while (*ptr != 0) {			\
				cnt++;				\
				ptr = (void**)*ptr;		\
			}					\
		} while (0)

#endif
