/*                                             Manages Read and Write to and from the Network
                      MANAGES READ AND WRITE TO AND FROM THE NETWORK
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*//*

   This module defines the read and write functions to and from the network. As we are
   having reentrant function and a smarter network I/O this will get very small :-)
   
   This module is implemented by HTSocket.c, and it is a part of the W3C Reference
   Library.
   
 */
#ifndef HTSOCKET_H
#define HTSOCKET_H

#include "HTAccess.h"
#include "HTStream.h"
#include "HTAnchor.h"/*

Create an Input Buffer

   This function allocates a input buffer and binds it to the socket descriptor given as
   parameter.
   
 */
extern HTInputSocket* HTInputSocket_new PARAMS((SOCKFD file_number));/*

Free an Input Buffer

 */
extern void HTInputSocket_free PARAMS((HTInputSocket * isoc));/*

Read Data from a Socket

   This function has replaced many other functions for doing read from a socket. It
   automaticly converts from ASCII if we are on a NON-ASCII machine. This assumes that we
   do not use this function to read a local file on a NON-ASCII machine. The following
   type definition is to make life easier when having a state machine looking for a <CRLF>
   sequence.
   
 */
typedef enum _HTSocketEOL {
    EOL_ERR = -1,
    EOL_BEGIN = 0,
    EOL_FCR,
    EOL_FLF,
    EOL_DOT,
    EOL_SCR,
    EOL_SLF
} HTSocketEOL;

extern int HTSocketRead PARAMS((HTRequest * request, HTStream * target));/*

Read from an ANSI file Descriptor

   This function has replaced the HTParseFile() and HTFileCopy functions for read from an
   ANSI file descriptor.
   
 */
extern int HTFileRead   PARAMS((FILE * fp, HTRequest * request,
                                HTStream * target));/*

   
   ___________________________________
   [IMAGE] THE REST OF THE FUNCTION DEFINED IN THIS MODULE ARE GOING TO BE OBSOLETE SO DO
   NOT USE THEM - THEY ARE NOT REENTRANT.
   ___________________________________
   
HTCopy:  Copy a socket to a stream

   This is used by the protocol engines to send data down a stream, typically one which
   has been generated by HTStreamStack. Returns the number of bytes transferred.
   
 */
extern int HTCopy       PARAMS((SOCKFD          file_number,
                                HTStream *      sink));/*

HTFileCopy:  Copy a file to a stream

   This is used by the protocol engines to send data down a stream, typically one which
   has been generated by HTStreamStack. It is currently called by HTParseFile
   
 */
extern void HTFileCopy PARAMS((
        FILE*                   fp,
        HTStream*               sink));/*

HTCopyNoCR: Copy a socket to a stream, stripping CR characters.

   It is slower than HTCopy .
   
 */
extern void HTCopyNoCR PARAMS((
        SOCKFD                  file_number,
        HTStream*               sink));

/*

HTParseSocket: Parse a socket given its format

   This routine is called by protocol modules to load an object.  usesHTStreamStack and
   the copy routines above.  Returns HT_LOADED if succesful, <0 if not.
   
 */
extern int HTParseSocket PARAMS((
        HTFormat        format_in,
        SOCKFD          file_number,
        HTRequest *     request));
/*

HTParseFile: Parse a File through a file pointer

   This routine is called by protocols modules to load an object. uses HTStreamStack and
   HTFileCopy .  Returns HT_LOADED if succesful, <0 if not.
   
 */
#if 0
extern int HTParseFile PARAMS((
        HTFormat        format_in,
        FILE            *fp,
        HTRequest *     request));
#endif/*

  GET NEXT CHARACTER FROM BUFFER
  
 */
extern int HTInputSocket_getCharacter PARAMS((HTInputSocket* isoc));/*

  READ BLOCK FROM INPUT SOCKET
  
   Read *len characters and return a buffer (don't free) containing *len characters ( *len
   may have changed). Buffer is not NULL-terminated.
   
 */
extern char * HTInputSocket_getBlock PARAMS((HTInputSocket * isoc,
                                                  int *           len));

extern char * HTInputSocket_getLine PARAMS((HTInputSocket * isoc));
extern char * HTInputSocket_getUnfoldedLine PARAMS((HTInputSocket * isoc));
extern char * HTInputSocket_getStatusLine PARAMS((HTInputSocket * isoc));
extern BOOL   HTInputSocket_seemsBinary PARAMS((HTInputSocket * isoc));

#endif
/*

   End of definition module  */

