# include	<stdio.h>
# include	<sys/types.h>
# include	<sys/socket.h>
# include	<netinet/in.h>
# include	<arpa/inet.h>
# include	<netdb.h>
# include	<signal.h>
# include	<setjmp.h>
# include	<sccs.h>

SCCSID(@(#)lock.c	8.2	5/1/86)

int  start_up_lock_driver();

/*
** start_up_lock_driver
**	Attempt to start up a connection to the lock driver.
**	We connect to a know address (a socket server sits there).
**	If we get a connection on this location, than we are talking 
**	to the lock driver. If we timeout, then we assume the driver 
**	isn't there.
**
** Returns
**	File descriptor attached to the lock driver
**	-1 on any error.
**
** Trace Flags
**	28
*/
int
start_up_lock_driver()
{
	struct	sockaddr_in	addr;		/* address to attach to for server */
	register	int	to_driver;	/* we can talk to the lock driver on this one */
	struct		servent	*ing_ser;


	/*
	** Find out where the lock driver lives
	*/
	if ( (ing_ser = getservbyname("ingreslock",(char *)0)) == 0 )
	{
#		ifdef xATR1
		if ( tTf(28,4) )
			perror("set_up_lock getservbyname");
#		endif
		return ( -1 );
	}

	/*
	** Make our end of the socket
	*/
	if ( (to_driver = socket(AF_INET,SOCK_STREAM,0)) == -1 )
	{
#		ifdef xATR1
		if ( tTf(28,4) )
			perror("set_up_lock socket");
#		endif
		return ( -1 );
	}

	bzero((char *) &addr,sizeof (addr));
	addr.sin_addr.s_addr = inet_addr("127.0.0.1");
	addr.sin_family = AF_INET;
	addr.sin_port = ing_ser->s_port;


	/*
	** Connect to the lock_driver
	*/
	if ( connect(to_driver, (struct sockaddr *)&addr, sizeof (addr)) == -1 )
	{
#	ifdef xATR1
		if ( tTf(28,4) )
			perror("set_up_lock connect");
#	endif
		close(to_driver);
		return ( -1 );
	}
	return ( to_driver );
}/* start_up_lock_driver */


/*   ---- deleted by  K.Okamoto  -------------
struct servent *
getservbyname(name, proto)
	char *name, *proto;
{
	register struct servent *p;
	register char **cp;

	setservent(0);
	while (p = getservent()) {
		if (strcmp(name, p->s_name) == 0)
			goto gotname;
		for (cp = p->s_aliases; *cp; cp++)
			if (strcmp(name, *cp) == 0)
				goto gotname;
		continue;
gotname:
		if (proto == 0 || strcmp(p->s_proto, proto) == 0)
			break;
	}
	endservent();
	return (p);
}

-----------deleted by K.Okamoto  ------------------
*/
