/***************************************************************************/
/*  Module:      $Id: signal.c,v 1.2 1995/05/24 00:48:27 maf Exp $
/*  Description: signal handling code for sendpage
/*  Author:      maf
/* Copyright (c) 1995 Mark Fullmer and The Ohio State University
/***************************************************************************/

/*
$Log: signal.c,v $
 * Revision 1.2  1995/05/24  00:48:27  maf
 * added POSIX style signal handling with mysignal()
 *
 * Revision 1.1  1995/01/10  01:44:35  maf
 * Initial revision
 *
*/


#include <sys/types.h>
#include <signal.h>
#include "sendpage.h"

sig_hup(sig)
int sig;
{
	extern int need_readconfig;
	need_readconfig = 1;
}

sig_usr1(sig)
int sig;
{
	extern int need_runqueue;
	need_runqueue = 1;
}

sig_alrm(sig)
int sig;
{
	extern int need_runqueue;
	need_runqueue = 1;
}

sig_quit(sig)
int sig;
{
	extern int need_quit;
	need_quit = 1;
}

sig_pipe(sig)
int sig;
{
	extern int got_sigpipe;
	got_sigpipe = 1;
}

#ifdef POSIX_SIGNALS

/*********************************************************************/
/* Function: mysignal()
/*  POSIX style signals.
/*
/*	signal() has different semantics over different versions of unix.
/*	this emulates signal() with sigaction() to behave like BSD.
/*
/* From Stevens Advanced Programming in the UNIX environment */
/*
/*********************************************************************/
void *mysignal(signo, func)
	int signo;
	void *func;

{
	struct sigaction act, oact;
	
	act.sa_handler = (void*)func;
	sigemptyset(&act.sa_mask);
	act.sa_flags = 0;

	if (signo == SIGALRM) {
#ifdef	SA_INTERRUPT
	act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif
	} else {
#ifdef SA_RESTART
	act.sa_flags |= SA_RESTART; /* SVR4, 4.3+BSD */
#endif
	}

	if (sigaction(signo, &act, &oact) < 0)
		return SIG_ERR;

	return oact.sa_handler;
} /* signal */

#endif /* POSIX_SIGNALS */

