/**************************************************************************
 * MODULE:
 *  prefs
 *
 * DESCRIPTION:
 *  User preference routines
 *
 * AUTHOR:
 *  Salim Alam
 *  University of Colorado, Boulder
 *
 * MODIFICATION LOG:
 *  92.12.31 S.A. Fixed bug in saving prefs
 *
 *************************************************************************/

#include <X11/Xos.h>
#include <stdlib.h>
#include <stdio.h>
#include "prefs.h"

#define RCFILENAME	".xgetftprc"


#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif


int prefs_save(Prefs prefs)
/*
 * Save the preferences in prefs to $HOME/.xgetftprc
 *
 * Returns TRUE if successful, FALSE otherwise.
 */
{
    FILE *fp;
    char *home_path;
    char *complete_name;

    if ( (home_path = getenv("HOME")) == NULL )
    {
	fprintf(stderr, "prefs_save: can't find $HOME.\n");
	return FALSE;
    }

    complete_name = malloc(strlen(home_path) + strlen(RCFILENAME) + 2);

    sprintf(complete_name, "%s/%s", home_path, RCFILENAME);

    if ( (fp=fopen(complete_name, "w")) == NULL )
    {
	fprintf(stderr, "prefs_save: can't open file '%s'.\n", complete_name);
	free(complete_name);
	return FALSE;
    }

    /*
     * Save the preferences strings
     */

    if (prefs.reuse_dir)
	fprintf(fp, "REUSE_DIR\n");
    if (prefs.cache_view)
	fprintf(fp, "CACHE_VIEW\n");
    if (prefs.reuse_view)
	fprintf(fp, "REUSE_VIEW\n");
    if (prefs.autosave_dir)
	fprintf(fp, "AUTOSAVE_DIR\n");
    if (prefs.confirm)
	fprintf(fp, "CONFIRM\n");


    fclose(fp);
    free(complete_name);
    return TRUE;
}


int prefs_load(Prefs *pprefs)
/*
 * Save the preferences in prefs to $HOME/.xgetftprc
 *
 * Returns TRUE if successful, FALSE otherwise.
 */
{
    FILE *fp;
    char *home_path;
    char *complete_name;
    char pref_str[50];

    if ( (home_path = getenv("HOME")) == NULL )
    {
	fprintf(stderr, "prefs_load: can't find $HOME.\n");
	return FALSE;
    }

    complete_name = malloc(strlen(home_path) + strlen(RCFILENAME) + 2);

    sprintf(complete_name, "%s/%s", home_path, RCFILENAME);

    if ( (fp=fopen(complete_name, "r")) == NULL )
    {
	fprintf(stderr, "prefs_load: can't open file '%s'.\n", complete_name);
	free(complete_name);
	return FALSE;
    }

    pprefs->reuse_dir = 0;
    pprefs->cache_view = 0;
    pprefs->reuse_view = 0;
    pprefs->autosave_dir = 0;
    pprefs->confirm = 0;

    while (!feof(fp))
    {
	if (fgets(pref_str, 48, fp) == NULL)
	    break;
	
	if (strcmp(pref_str, "REUSE_DIR\n") == 0)
	    pprefs->reuse_dir = 1;
	if (strcmp(pref_str, "CACHE_VIEW\n") == 0)
	    pprefs->cache_view = 1;
	if (strcmp(pref_str, "REUSE_VIEW\n") == 0)
	    pprefs->reuse_view = 1;
	if (strcmp(pref_str, "AUTOSAVE_DIR\n") == 0)
	    pprefs->autosave_dir = 1;
	if (strcmp(pref_str, "CONFIRM\n") == 0)
	    pprefs->confirm = 1;
    }

    fclose(fp);
    free(complete_name);
    return TRUE;
}


void prefs_print(Prefs prefs, char *name)
{
    printf("%s.reuse_dir = %d\n", name, prefs.reuse_dir);
    printf("%s.cache_view = %d\n", name, prefs.cache_view);
    printf("%s.reuse_view = %d\n", name, prefs.reuse_view);
    printf("%s.autosave_dir = %d\n", name, prefs.autosave_dir);
    printf("%s.confirm = %d\n\n", name, prefs.confirm);
}
