/************************************************************************
 * HEADER:
 *  control
 ***********************************************************************/

#include <sys/types.h>

/*
 * FTP Type definitions
 */
#define typASCII	0
#define typIMAGE	1

extern int ftp_curr_type;


/*
 * CreateFunc is a pointer to a function that takes a string
 * and returns a void.  This function will be called once for
 * every string in a given directory.  It should have an internal
 * state that keeps track of the strings. 
 *
 * InitFunc allocates the memory needed.  Its parameter is the
 * number of items that will need to be created.
 *
 */
typedef void (*CreateFunc) (char *);
typedef void (*InitFunc) (int);

/*
 * Prototypes
 */
int
ctrl_login(char *host, char *user, char *pass);

int
ctrl_start_session(InitFunc init_str, CreateFunc add_str, time_t *ptime);

int
ctrl_down_dir(int index);

int
ctrl_up_dir(void);

void
ctrl_set_type(int);

int 
ctrl_get_selection(char *path, int index, char *newname);

int 
ctrl_get_file(char *path, int index, char *newname);

FILE *
ctrl_view_file(int index);

int 
ctrl_get_directory(char *path, int index);

void
ctrl_logout(void);

void 
ctrl_save_cache(void);

int
ctrl_load_cache(time_t *ptime);

int
ctrl_delete_cache(void);

char *
ctrl_get_item_name(int item);

void
ctrl_delete_file_cache(void);

