/*
 * Xchrom.c -- a Chrom-A-Chron clock widget.
 * Copyright (c) Olaf Heimburger 1990
 * Last edited: Fri Aug 24 08:36:25 1990 by olafh (Olaf Heimburger) on GECKO
 */
#ifndef _XtXchromP_h
#define _XtXchromP_h

#include <X11/CoreP.h>
#include "Xchrom.h"

typedef struct {
    Pixel        foreground;
    Pixel        color[NUMFIELDS];
    /* non-resources (e.g. user can't set) */
    XtIntervalId IntervalId;
    GC           Colors[NUMFIELDS + 1];
    Pixmap	 ColorPixmap;
    XArc         Slices[NUMFIELDS + 1];
    int          SavedHour;
    int          SavedMin;
    int          ArcSize;
    Dimension    SquareSize;
    Pixmap       WdwPixmap;
    int          Offset;
} XchromPart;

typedef struct _XchromRec {
    CorePart	core;
    XchromPart	xchrom;
} XchromRec;

typedef struct {int dummy;} XchromClassPart;

typedef struct _XchromClassRec {
    CoreClassPart	core_class;
    XchromClassPart	xchrom_class;
} XchromClassRec;

extern XchromClassRec xchromClassRec;

#endif _XtXchromP_h
