#include <tk.h>

extern int Ical_Init(Tcl_Interp*);
static int beep_proc(ClientData, Tcl_Interp*, int, char**);

int Icalx_Init(Tcl_Interp* tcl) {
    if (Ical_Init(tcl) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /* Load necessary Tk support code */

    Tk_Window mainWindow = Tk_MainWindow(tcl);

    Tk_SetClass(mainWindow, "Ical");
    Tcl_CreateCommand(tcl, "wbeep", beep_proc, (ClientData) mainWindow, 0);

    return TCL_OK;
}

/*
 * Beep.
 *
 *	wbeep [-100..100]
 */
static int beep_proc(ClientData c, Tcl_Interp* tcl,int argc,char* argv[]){
    Tk_Window tkwin = (Tk_Window) c;

    if (argc != 2) {
	Tcl_SetResult(tcl, "illegal number of arguments to wbeep", TCL_STATIC);
	return TCL_ERROR;
    }

    int i;
    if (Tcl_GetInt(tcl, argv[1], &i) != TCL_OK) {
	return TCL_ERROR;
    }

    if ((i < -100) || (i > 100)) {
	Tcl_SetResult(tcl, "invalid volume", TCL_STATIC);
	return TCL_ERROR;
    }

    XBell(Tk_Display(tkwin), i);

    Tcl_SetResult(tcl, "", TCL_STATIC);
    return TCL_OK;
}
