.TH AFAUTH 1 "Release 1" "AF Version 3" .SH NAME AFauFileName,
AFauReadAuth, AFauLockAuth, AFauUnlockAuth, AFauWriteAuth,
AFauGetAuthByAddr \- AF authority database routines .SH SYNOPSIS .B
"#include <AF/AFauth.h>" 
.PP 
.nf 
.ta .5i 2i 
typedef struct xauth {
	unsigned short	family;
	unsigned short	address_length;
	const char	*address;
	unsigned short	number_length;
	const char	*number;
	unsigned short	name_length;
	const char	*name;
	unsigned short	data_length;
	const char	*data;
} AFauth;

.ft B
char *AFauFileName ()

.ft B
AFauth *AFauReadAuth (auth_file)
.ft I
	FILE *auth_file;

.ft B
int AFauWriteAuth (auth_file, auth)
.ft I
	FILE *auth_file;
	AFauth *auth;

.ft B 
AFauth *AFauGetAuthByAddr (\kAfamily,
\h'|\nAu'address_length, address,
\h'|\nAu'number_length, number)
.ft I
	unsigned short family;
	unsigned short address_length;
	char *address;
	unsigned short number_length;
	char *number;

.ft B
int AFauLockAuth (file_name, retries, timeout, dead)
.ft I
	char *file_name;
	int retries;
	int timeout;
	long dead;

.ft B
int AFauUnlockAuth (file_name)
.ft I
	char *file_name;

.ft B
AFauDisposeAuth (auth)
.ft I
	AFauth *auth;

.ft R
.SH DESCRIPTION
.PP
\fBAFauFileName\fP generates the default authorization file name by first
checking the AFauTHROTIY environment variable if set, else it returns
$HOME/.AFauthority.  This name is statically allocated and should
not be freed.
.PP
\fBAFauReadAuth\fP reads the next entry from \fIauth_file\fP.  The entry is
\fBnot\fP statically allocated and should be freed by calling
\fIAFauDisposeAuth\fP.
.PP
\fBXuWriteAuth\fP writes an authorization entry to \fIauth_file\fP.  It
returns 1 on success, 0 on failure.
.PP
\fBAFauGetAuthByAddr\fP searches for an entry which matches the given network
address/display number pair.  The entry is \fBnot\fP statically allocated
and should be freed by calling \fIAFauDisposeAuth\fP
.PP
\fBAFauLockAuth\fP does the work necessary to synchronously update an
authorization file.  First it makes to file names, one with ``-c'' appended
to \fIfile_name\fP, the other with ``-l'' appended.  If the ``-c'' file
already exists and is more than \fIdead\fP seconds old, \fIAFauLockAuth\fP
removes it and the associated ``-l'' file.  To prevent possible
synchronization troubles with NFS, a \fIdead\fP value of zero forces the
files to be removed.  \fIAFauLockAuth\fP makes \fIretries\fP attempts to
create and link the file names, pausing \fItimeout\fP seconds between each
attempt.  \fIAFauLockAuth\fP returns a collection of values depending on the
results:
.nf
.ta .5i 2i

	LOCK_ERROR	A system error occurred, either a file_name
		which is too long, or an unexpected failure from
		a system call.  errno may prove useful.

	LOCK_TIMEOUT	\fIretries\fP attempts failed

	LOCK_SUCCESS	The lock succeeded.

.fi
.PP
\fBAFauUnlockAuth\fP undoes the work of \fIAFauLockAuth\fP by unlinking both 
the ``-c'' and ``-l'' file names.
.PP
\fBAFauDisposeAuth\fP frees storage allocated to hold an authorization entry.
.SH "SEE ALSO"
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology, 1993, Digital Equipment Corporation
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Keith Packard, MIT X Consortium
