.ds xL AFlib \- C Language AF Interface
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AFGetProperty 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAFGetProperty, AFListProperties, AFChangeProperty, AFDeleteProperty\fR \- obtain and change properties
.SH SYNTAX
\fB#include <AF/AFlib.h>\fP
.br
int \fBAFGetProperty\fP\^(AC \fIac\fP, AAtom \fIproperty\fP\^, long \fIlong_offset\fP\^, 
.br
                    long \fIlong_length\fP\^, ABool \fIdelete\fP\^, AAtom \fIreq_type\fP\^, 
.br
                    AAtom \fI*actual_type_return\fP\^, int \fI*actual_format_return\fP\^, 
.br
                    unsigned long \fI*nitems_return\fP\^, 
.br
                    unsigned long \fI*bytes_after_return\fP\^, 
.br
                    unsigned char \fI**prop_return\fP\^)
.LP
AAtom *\fBAFListProperties\fP\^(\^AC \fIac\fP, int \fI*num_prop_return\fP\^)
.LP
\fBAFChangeProperty\fP\^(\^AC \fIac\fP, AAtom \fIproperty\fP\^, AAtom \fItype\fP\^, int \fIformat\fP\^, 
.br
                    int \fImode\fP\^, unsigned char \fI*data\fP\^, int \fInelements\fP\^)
.LP
\fBAFDeleteProperty\fP\^(\^AC \fIac\fP, AAtom \fIproperty\fP\^)
.SH ARGUMENTS
.IP \fIactual_format_return\fP 1i
Returns the actual format of the property.
.IP \fIactual_type_return\fP 1i
Returns the atom identifier  that defines the actual type of the property.
.IP \fIbytes_after_return\fP 1i
Returns the number of bytes remaining to be read in the property if 
a partial read was performed.
.IP \fIdata\fP 1i
Specifies the property data.
.IP \fIdelete\fP 1i
Specifies a Boolean value that determines whether the property is deleted.
.IP \fIac\fP 1i
Specifies the device to use (via an audio context).
.IP \fIformat\fP 1i
Specifies whether the data should be viewed as a list
of 8-bit, 16-bit, or 32-bit quantities.
Possible values are 8, 16, and 32.
This information allows the AF server to correctly perform
byte-swap operations as necessary.
If the format is 16-bit or 32-bit,
you must explicitly cast your data pointer to an (unsigned char *) in the call
to 
.ZN AFChangeProperty .
.IP \fIlong_length\fP 1i
Specifies the length in 32-bit multiples of the data to be retrieved.
.IP \fIlong_offset\fP 1i
Specifies the offset in the specified property (in 32-bit quantities) 
where the data is to be retrieved.
.IP \fImode\fP 1i
Specifies the mode of the operation.
You can pass
.ZN APropModeReplace ,
.ZN APropModePrepend ,
or
.ZN APropModeAppend .
.IP \fInelements\fP 1i
Specifies the number of elements of the specified data format.
.IP \fInitems_return\fP 1i
Returns the actual number of 8-bit, 16-bit, or 32-bit items 
stored in the prop_return data.
.IP \fInum_prop\fP 1i
Specifies the length of the properties array.
.IP \fInum_prop_return\fP 1i
Returns the length of the properties array.
.IP \fInpositions\fP 1i
Specifies the rotation amount.
.IP \fIprop_return\fP 1i
Returns the data in the specified format.
.IP \fIproperty\fP 1i
Specifies the property name.
.IP \fIproperties\fP 1i
Specifies the array of properties that are to be rotated.
.IP \fIreq_type\fP 1i
Specifies the atom identifier associated with the property type or
.ZN AAnyPropertyType .
.IP \fItype\fP 1i
Specifies the type of the property.
The AF server does not interpret the type but simply
passes it back to an application that later calls 
.ZN AFGetProperty .
.SH DESCRIPTION
The
.ZN AFGetProperty
function returns the actual type of the property; the actual format of the property;
the number of 8-bit, 16-bit, or 32-bit items transferred; the number of bytes remaining
to be read in the property; and a pointer to the data actually returned.
.ZN AFGetProperty
sets the return arguments as follows:
.IP \(bu 5
If the specified property does not exist for the specified device,
.ZN AFGetProperty 
returns 
.ZN None
to actual_type_return and the value zero to 
actual_format_return and bytes_after_return.
The nitems_return argument is empty.
In this case, the delete argument is ignored.
.IP \(bu 5
If the specified property exists 
but its type does not match the specified type,
.ZN AFGetProperty 
returns the actual property type to actual_type_return, 
the actual property format (never zero) to actual_format_return, 
and the property length in bytes (even if the actual_format_return is 16 or 32) 
to bytes_after_return.
It also ignores the delete argument.
The nitems_return argument is empty.
.IP \(bu 5
If the specified property exists and either you assign 
.ZN AAnyPropertyType 
to the req_type argument or the specified type matches the actual property type,
.ZN AFGetProperty 
returns the actual property type to actual_type_return and the actual
property format (never zero) to actual_format_return. 
It also returns a value to bytes_after_return and nitems_return, by 
defining the following
values:
.IP
.nf
	N = actual length of the stored property in bytes
	     (even if the format is 16 or 32)
	I = 4 * long_offset
	T = N - I
	L = MINIMUM(T, 4 * long_length)
	A = N - (I + L)
.fi
.IP
The returned value starts at byte index I in the property (indexing
from zero), and its length in bytes is L.
If the value for long_offset causes L to be negative,
a
.ZN BadValue
error results. 
The value of bytes_after_return is A, 
giving the number of trailing unread bytes in the stored property.
.LP
.ZN AFGetProperty
always allocates one extra byte in prop_return 
(even if the property is zero length) 
and sets it to ASCII null so that simple properties consisting of characters
do not have to be copied into yet another string before use.
If delete is 
.ZN True 
and bytes_after_return is zero, 
.ZN AFGetProperty
deletes the property 
from the device and generates a 
.ZN PropertyNotify 
event on the device.
.LP
The function returns
.ZN Success
if it executes successfully.
To free the resulting data,
use
.ZN Afree .
.LP
.ZN AFGetProperty
can generate
.ZN BadAtom ,
.ZN BadValue ,
and
.ZN BadAC 
errors.
.LP
.\" $Header: /crl/audio/AF/lib/AFman/RCS/AFGetProperty.man,v 1.12 1994/05/02 12:27:28 tml Exp $
The
.ZN AFListProperties
function returns a pointer to an array of atom properties that are defined for 
the specified device or returns NULL if no properties were found.
To free the memory allocated by this function, use
.ZN Afree .
.LP
.ZN AFListProperties
can generate a
.ZN BadAC 
error.
.LP
The
.ZN AFChangeProperty
function alters the property for the specified device and
causes the AudioFIle server to generate a
.ZN PropertyNotify
event on that device.
.ZN AFChangeProperty
performs the following:
.IP \(bu 5
If mode is
.ZN APropModeReplace ,
.ZN AFChangeProperty
discards the previous property value and stores the new data.
.IP \(bu 5
If mode is
.ZN APropModePrepend
or
.ZN APropModeAppend ,
.ZN AFChangeProperty
inserts the specified data before the beginning of the existing data
or onto the end of the existing data, respectively.
The type and format must match the existing property value,
or a
.ZN BadMatch
error results.
If the property is undefined, 
it is treated as defined with the correct type and
format with zero-length data.
.LP
The lifetime of a property is not tied to the storing client.
Properties remain until explicitly deleted,
or until the server resets.
The maximum size of a property is server dependent and can vary dynamically
depending on the amount of memory the server has available.
(If there is insufficient space, a
.ZN ABadAlloc
error results.)
.LP
.ZN AFChangeProperty
can generate
.ZN ABadAlloc ,
.ZN ABadAtom ,
.ZN ABadMatch ,
.ZN ABadValue ,
and
.ZN ABadAC 
errors.
.LP
The
.ZN AFDeleteProperty
function deletes the specified property only if the
property was defined on the specified device
and causes the AF server to generate a
.ZN PropertyNotify
event on the device unless the property does not exist.
.LP
.ZN AFDeleteProperty
can generate
.ZN ABadAtom
and
.ZN ABadAC 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN ABadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN ABadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.ZN ABadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN ABadAC
A value for a audio context argument is not valid.
.SH "SEE ALSO"
AF(1)
.br

.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
