/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.Builder;
import nts.builder.VertBuilder;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.FileName;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.CntxLog;
import nts.io.CntxLoggableEnum;
import nts.io.Log;
import nts.io.Loggable;
import nts.io.Name;
import nts.node.AnyBoxNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.FontMetric;
import nts.node.HBoxNode;
import nts.node.HorizIterator;
import nts.node.Language;
import nts.node.LinesShape;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.RuleNode;
import nts.node.SizesEvaluator;
import nts.node.TreatBox;
import nts.node.TreatNode;
import nts.node.TypeSetter;
import nts.node.VBoxNode;
import nts.node.VertIterator;
import nts.node.WordBuilder;
import nts.typo.CharHandler;
import nts.typo.FontMetricEquiv;
import nts.typo.NullFontMetric;
import nts.typo.Paragraph;
import nts.typo.TypoCommand;

public abstract class TypoCommand
extends Command {
    private static TypoHandler typoHandler;
    private static FontMetricEquiv currFontMetric;
    private static Config config;
    public static final int BOOLP_TRACING_LOST_CHARS;
    public static final TreatNode APPENDER;
    public static final int GLUEP_SPACE;
    public static final int GLUEP_XSPACE;
    public static final int DIMP_LINE_SKIP_LIMIT;
    public static final int GLUEP_LINE_SKIP;
    public static final int GLUEP_BASELINE_SKIP;
    public static final int INTP_SHOW_BOX_DEPTH;
    public static final int INTP_SHOW_BOX_BREADTH;
    public static final int INTP_HBADNESS;
    public static final int DIMP_HFUZZ;
    public static final int DIMP_OVERFULL_RULE;
    public static final int INTP_VBADNESS;
    public static final int DIMP_VFUZZ;
    private static final HBoxPacker hPacker;
    private static final VBoxPacker vPacker;
    public static final int DIMP_BOX_MAX_DEPTH;
    public static final int DIMP_SPLIT_MAX_DEPTH;
    public static final int GLUEP_SPLIT_TOP_SKIP;
    public static final int INTP_OUTPUT_BOX_NUM;
    public static final int BOOLP_TRACING_OUTPUT;
    public static final int DIMP_H_OFFSET;
    public static final int DIMP_V_OFFSET;

    public static final Builder getBld() {
        return Builder.top();
    }

    public static void illegalCase(Command cmd, Builder bld) {
        CommandBase.error("CantUseIn", cmd, bld);
    }

    public void illegalCase(Builder bld) {
        TypoCommand.illegalCase(this, bld);
    }

    public static TypoHandler getTypoHandler() {
        return typoHandler;
    }

    public static void setTypoHandler(TypoHandler hand) {
        typoHandler = hand;
    }

    public static FontMetric getCurrFontMetric() {
        return currFontMetric.get();
    }

    public static void setCurrFontMetric(FontMetric val, boolean glob) {
        currFontMetric.set(val, glob);
    }

    public static void makeStaticData() {
        currFontMetric = new FontMetricEquiv();
    }

    public static void writeStaticData(ObjectOutputStream output) throws IOException {
        output.writeObject(currFontMetric);
    }

    public static void readStaticData(ObjectInputStream input) throws IOException, ClassNotFoundException {
        currFontMetric = (FontMetricEquiv)input.readObject();
    }

    public static void setTypoConfig(Config conf) {
        config = conf;
    }

    public static Config getTypoConfig() {
        return config;
    }

    public static void charWarning(FontMetric metric, CharCode code) {
        if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_LOST_CHARS)) {
            CommandBase.diagLog.startLine().add("Missing character: There is no ").add(code).add(" in font ").add(metric.getName()).add('!').startLine();
        }
    }

    public static void appendCharsTo(Builder bld, WordBuilder word) {
        block2: {
            CharCode code;
            do {
                Token tok;
                Command cmd;
                if ((code = (cmd = CommandBase.meaningOf(tok = CommandBase.nextExpToken())).charCodeToAdd()) == null) {
                    word.close(!cmd.isNoBoundary());
                    cmd.execute(tok);
                    break block2;
                }
                bld.adjustSpaceFactor(code.spaceFactor());
            } while (word.add(code));
            TypoCommand.charWarning(TypoCommand.getCurrFontMetric(), code);
        }
    }

    public static void appendChar(Builder bld, CharCode code) {
        WordBuilder word = TypoCommand.getCurrFontMetric().getWordBuilder(APPENDER, true, bld.willBeBroken());
        bld.adjustSpaceFactor(code.spaceFactor());
        TypoCommand.fixLanguage(bld);
        if (word.add(code)) {
            TypoCommand.appendCharsTo(bld, word);
        } else {
            TypoCommand.charWarning(TypoCommand.getCurrFontMetric(), code);
        }
    }

    public static void fixLanguage(Builder bld) {
        Language lang;
        if (bld.willBeBroken() && (lang = bld.getCurrLang()) != null && TypoCommand.getTypoConfig().languageDiffers(lang)) {
            bld.setCurrLang(TypoCommand.getTypoConfig().getLanguage());
        }
    }

    public static void appendNormalSpace(Builder bld) {
        Glue skip = CommandBase.getConfig().getGlueParam(GLUEP_SPACE);
        if (skip.isZero()) {
            bld.addSkip(TypoCommand.getCurrFontMetric().getNormalSpace());
        } else {
            bld.addSkip(skip, CommandBase.getConfig().getGlueName(GLUEP_SPACE));
        }
    }

    private static void addBoxToBuilder(Builder bld, Node node) {
        Dimen dim = bld.getPrevDepth();
        if (dim != null && dim.moreThan(VertBuilder.IGNORE_DEPTH)) {
            CommandBase.Config cfg = CommandBase.getConfig();
            Glue bls = cfg.getGlueParam(GLUEP_BASELINE_SKIP);
            dim = bls.getDimen().minus(dim).minus(node.getHeight());
            if (dim.lessThan(cfg.getDimParam(DIMP_LINE_SKIP_LIMIT))) {
                bld.addSkip(cfg.getGlueParam(GLUEP_LINE_SKIP), cfg.getGlueName(GLUEP_LINE_SKIP));
            } else {
                bld.addSkip(bls.resizedCopy(dim), cfg.getGlueName(GLUEP_BASELINE_SKIP));
            }
        }
        bld.addBox(node);
    }

    public static void appendBox(Builder bld, Node box) {
        TypoCommand.addBoxToBuilder(bld, box);
        bld.buildPage();
    }

    public static void appendBox(Builder bld, Node box, boolean page) {
        TypoCommand.addBoxToBuilder(bld, box);
        if (page) {
            bld.buildPage();
        }
    }

    public static void appendBox(Builder bld, Node box, NodeEnum mig) {
        TypoCommand.addBoxToBuilder(bld, box);
        bld.addNodes(mig);
        bld.buildPage();
    }

    public static void appendBox(Builder bld, Node box, NodeEnum mig, boolean page) {
        TypoCommand.addBoxToBuilder(bld, box);
        bld.addNodes(mig);
        if (page) {
            bld.buildPage();
        }
    }

    public static FontMetric scanFontMetric() {
        Token tok = CommandBase.nextExpNonSpacer();
        Command cmd = CommandBase.meaningOf(tok);
        if (cmd.hasFontMetricValue()) {
            return cmd.getFontMetricValue();
        }
        CommandBase.backToken(tok);
        CommandBase.error("MissingFontIdent");
        return NullFontMetric.METRIC;
    }

    public static void scanBox(TreatBox proc) {
        Token tok = CommandBase.nextNonRelax();
        Command cmd = CommandBase.meaningOf(tok);
        if (cmd.hasBoxValue()) {
            proc.execute(cmd.getBoxValue(), NodeList.EMPTY_ENUM);
        } else if (cmd.canMakeBoxValue()) {
            cmd.makeBoxValue(proc);
        } else {
            CommandBase.backToken(tok);
            CommandBase.error("BoxExpected");
        }
    }

    public static void addBoxOn(Log log, Box box) {
        int depth = CommandBase.getConfig().getIntParam(INTP_SHOW_BOX_DEPTH);
        int breadth = CommandBase.getConfig().getIntParam(INTP_SHOW_BOX_BREADTH);
        box.addOn(log, depth, breadth);
        log.endLine();
    }

    public static void addItemsOn(Log log, CntxLoggableEnum items) {
        int depth = CommandBase.getConfig().getIntParam(INTP_SHOW_BOX_DEPTH);
        int breadth = CommandBase.getConfig().getIntParam(INTP_SHOW_BOX_BREADTH);
        CntxLog.addItems(log, items, depth, breadth);
        log.endLine();
    }

    public static void addBoxOnDiagLog(String desc, Box box) {
        CommandBase.diagLog.startLine().add(desc);
        TypoCommand.addBoxOn(CommandBase.diagLog, box);
        CommandBase.diagLog.startLine().endLine();
    }

    public static void addBoxOnDiagLog(Box box) {
        TypoCommand.addBoxOn(CommandBase.diagLog, box);
        CommandBase.diagLog.startLine().endLine();
    }

    public static void addItemsOnDiagLog(String desc, CntxLoggableEnum items) {
        CommandBase.diagLog.startLine().add(desc);
        TypoCommand.addItemsOn(CommandBase.diagLog, items);
        CommandBase.diagLog.startLine().endLine();
    }

    public static void addItemsOnDiagLog(CntxLoggableEnum items) {
        TypoCommand.addItemsOn(CommandBase.diagLog, items);
        CommandBase.diagLog.startLine().endLine();
    }

    public static HBoxNode packHBox(NodeList list, Dimen desired) {
        return TypoCommand.packHBox(list, desired, true);
    }

    public static HBoxNode packHBox(NodeList list, Dimen desired, boolean exactly) {
        return hPacker.packHBox(list, desired, exactly);
    }

    public static VBoxNode packVBox(NodeList list, Dimen desired) {
        return TypoCommand.packVBox(list, desired, true);
    }

    public static VBoxNode packVBox(NodeList list, Dimen desired, Dimen maxDepth) {
        return TypoCommand.packVBox(list, desired, true, maxDepth);
    }

    public static VBoxNode packVBox(NodeList list, Dimen desired, boolean exactly) {
        return TypoCommand.packVBox(list, desired, exactly, null);
    }

    public static VBoxNode packVBox(NodeList list, Dimen desired, boolean exactly, Dimen maxDepth) {
        return vPacker.packVBox(list, desired, exactly, maxDepth);
    }

    public static void shipOut(Box box) {
        boolean tracing = CommandBase.getConfig().getBoolParam(BOOLP_TRACING_OUTPUT);
        int[] nums = TypoCommand.getTypoConfig().currPageNumbers();
        if (tracing) {
            CommandBase.normLog.startLine().endLine().add("Completed box being shipped out");
        }
        CommandBase.normLog.sepRoom(9).add('[');
        if (nums.length > 0) {
            int i = 0;
            while (true) {
                CommandBase.normLog.add(nums[i++]);
                if (i >= nums.length) break;
                CommandBase.normLog.add('.');
            }
        }
        CommandBase.normLog.flush();
        if (tracing) {
            CommandBase.normLog.add(']');
            TypoCommand.addBoxOnDiagLog(box);
        }
        Dimen hOffset = CommandBase.getConfig().getDimParam(DIMP_H_OFFSET);
        Dimen vOffset = CommandBase.getConfig().getDimParam(DIMP_V_OFFSET);
        Dimen height = box.getHeight().plus(box.getDepth());
        Dimen width = box.getWidth().plus(box.getLeftX());
        if (box.getHeight().moreThan(Dimen.MAX_VALUE) || box.getDepth().moreThan(Dimen.MAX_VALUE) || vOffset.plus(height).moreThan(Dimen.MAX_VALUE) || hOffset.plus(width).moreThan(Dimen.MAX_VALUE)) {
            CommandBase.error("PageTooLarge");
            if (!tracing) {
                TypoCommand.addBoxOnDiagLog("The following box has been deleted:", box);
            }
        } else {
            TypeSetter setter = TypoCommand.getTypoHandler().getSetter();
            if (setter != null) {
                setter.startPage(vOffset, hOffset, height, width, nums);
                setter.moveDown(box.getHeight());
                setter.moveRight(box.getLeftX());
                box.typeSet(setter);
                setter.endPage();
            }
        }
        if (!tracing) {
            CommandBase.normLog.add(']');
        }
        CommandBase.normLog.flush();
        TypoCommand.getTypoConfig().resetOutput();
    }

    public abstract void addOn(Log var1);

    static {
        BOOLP_TRACING_LOST_CHARS = CommandBase.newBoolParam();
        APPENDER = new 1();
        GLUEP_SPACE = CommandBase.newGlueParam();
        GLUEP_XSPACE = CommandBase.newGlueParam();
        DIMP_LINE_SKIP_LIMIT = CommandBase.newDimParam();
        GLUEP_LINE_SKIP = CommandBase.newGlueParam();
        GLUEP_BASELINE_SKIP = CommandBase.newGlueParam();
        INTP_SHOW_BOX_DEPTH = CommandBase.newIntParam();
        INTP_SHOW_BOX_BREADTH = CommandBase.newIntParam();
        INTP_HBADNESS = CommandBase.newIntParam();
        DIMP_HFUZZ = CommandBase.newDimParam();
        DIMP_OVERFULL_RULE = CommandBase.newDimParam();
        INTP_VBADNESS = CommandBase.newIntParam();
        DIMP_VFUZZ = CommandBase.newDimParam();
        hPacker = new HBoxPacker();
        vPacker = new VBoxPacker();
        DIMP_BOX_MAX_DEPTH = CommandBase.newDimParam();
        DIMP_SPLIT_MAX_DEPTH = CommandBase.newDimParam();
        GLUEP_SPLIT_TOP_SKIP = CommandBase.newGlueParam();
        INTP_OUTPUT_BOX_NUM = CommandBase.newIntParam();
        BOOLP_TRACING_OUTPUT = CommandBase.newBoolParam();
        DIMP_H_OFFSET = CommandBase.newDimParam();
        DIMP_V_OFFSET = CommandBase.newDimParam();
    }

    public static class HorizCharHandler
    implements CharHandler {
        public void handle(Builder bld, CharCode code, Token src) {
            TypoCommand.appendChar(bld, code);
        }

        public void handleSpace(Builder bld, Token src) {
            int sf = bld.getSpaceFactor();
            if (sf == 1000) {
                TypoCommand.appendNormalSpace(bld);
            } else if (sf > 0) {
                Dimen extra;
                Glue skip;
                if (sf >= 2000 && !(skip = CommandBase.getConfig().getGlueParam(GLUEP_XSPACE)).isZero()) {
                    bld.addSkip(skip, CommandBase.getConfig().getGlueName(GLUEP_XSPACE));
                    return;
                }
                skip = CommandBase.getConfig().getGlueParam(GLUEP_SPACE);
                if (skip.isZero()) {
                    skip = TypoCommand.getCurrFontMetric().getNormalSpace();
                }
                Dimen dim = skip.getDimen();
                if (sf >= 2000 && (extra = TypoCommand.getCurrFontMetric().getDimenParam(6)) != null) {
                    dim = dim.plus(extra);
                }
                skip = Glue.valueOf(dim, skip.getStretch().times(sf, 1000), skip.getStrOrder(), skip.getShrink().times(1000, sf), skip.getShrOrder());
                bld.addSkip(skip);
            }
        }
    }

    public static class VertCharHandler
    implements CharHandler {
        public void handle(Builder bld, CharCode code, Token src) {
            CommandBase.backToken(src);
            Paragraph.start(true);
        }

        public void handleSpace(Builder bld, Token src) {
        }
    }

    public static abstract class AnyBoxPacker {
        public boolean check(SizesEvaluator pack) {
            int badness = pack.getBadness();
            TypoCommand.getTypoConfig().setLastBadness(badness);
            boolean serious = false;
            switch (pack.getReport()) {
                case 1: {
                    serious = this.underfull(badness);
                    break;
                }
                case 2: {
                    serious = this.tight(badness);
                    break;
                }
                case 3: {
                    serious = this.overfull(pack.getOverfull());
                    break;
                }
            }
            return serious;
        }

        public void reportBox(AnyBoxNode box) {
            if (!AnyBoxPacker.takingOverLocationReported(CommandBase.normLog)) {
                this.reportLocation(CommandBase.normLog);
                CommandBase.normLog.endLine();
            }
            TypoCommand.addBoxOnDiagLog(box);
        }

        protected boolean underfull(int badness) {
            if (badness > CommandBase.getConfig().getIntParam(this.getBadnessParam())) {
                CommandBase.normLog.endLine().add(badness > 100 ? "Underfull" : "Loose").add(' ').addEsc(this.getName()).add(" (badness ").add(badness).add(") ");
                return true;
            }
            return false;
        }

        protected boolean tight(int badness) {
            if (badness > CommandBase.getConfig().getIntParam(this.getBadnessParam())) {
                CommandBase.normLog.endLine().add("Tight ").addEsc(this.getName()).add(" (badness ").add(badness).add(") ");
                return true;
            }
            return false;
        }

        protected boolean overfull(Dimen excess) {
            if (CommandBase.getConfig().getIntParam(this.getBadnessParam()) < 100 || CommandBase.getConfig().getDimParam(this.getFuzzParam()).lessThan(excess)) {
                CommandBase.normLog.endLine().add("Overfull ").addEsc(this.getName()).add(" (").add(excess.toString("pt")).add(" too ").add(this.getDim()).add(") ");
                return true;
            }
            return false;
        }

        protected static boolean takingOverLocationReported(Log log) {
            if (TypoCommand.getTypoConfig().activeOutput()) {
                log.add("has occurred while \\output is active");
                return true;
            }
            return false;
        }

        protected void reportLocation(Log log) {
            log.add("detected at line ").add(CommandBase.currLineNumber());
        }

        protected abstract String getName();

        protected abstract String getDim();

        protected abstract int getBadnessParam();

        protected abstract int getFuzzParam();
    }

    public static class HBoxPacker
    extends AnyBoxPacker {
        public HBoxNode packHBox(NodeList list, Dimen desired, boolean exactly) {
            SizesEvaluator pack = new SizesEvaluator();
            HorizIterator.summarize(list.nodes(), pack);
            Dimen size = pack.getBody().plus(pack.getDepth());
            boolean empty = list.isEmpty();
            if (exactly) {
                pack.evaluate(desired.minus(size), empty);
                size = desired;
            } else {
                pack.evaluate(desired, empty);
                size = size.plus(desired);
            }
            BoxSizes sizes = new BoxSizes(pack.getWidth(), size, pack.getLeftX(), pack.getHeight());
            HBoxNode hbox = new HBoxNode(sizes, pack.getSetting(), list);
            if (pack.getReport() == 3) {
                this.addOverfullRule(list, pack.getOverfull());
            }
            if (this.check(pack)) {
                this.reportBox(hbox);
            }
            return hbox;
        }

        protected void addOverfullRule(NodeList list, Dimen excess) {
            if (CommandBase.getConfig().getDimParam(DIMP_OVERFULL_RULE).moreThan(0) && CommandBase.getConfig().getDimParam(this.getFuzzParam()).lessThan(excess)) {
                BoxSizes sizes = new BoxSizes(null, CommandBase.getConfig().getDimParam(DIMP_OVERFULL_RULE), null, Dimen.ZERO);
                list.append(new RuleNode(sizes));
            }
        }

        public void reportBox(AnyBoxNode box) {
            if (!AnyBoxPacker.takingOverLocationReported(CommandBase.normLog)) {
                this.reportLocation(CommandBase.normLog);
            }
            CommandBase.normLog.endLine();
            box.addListShortlyOn(CommandBase.normLog);
            CommandBase.normLog.endLine();
            TypoCommand.addBoxOnDiagLog(box);
        }

        protected String getName() {
            return "hbox";
        }

        protected String getDim() {
            return "wide";
        }

        protected int getBadnessParam() {
            return INTP_HBADNESS;
        }

        protected int getFuzzParam() {
            return DIMP_HFUZZ;
        }
    }

    public static class VBoxPacker
    extends AnyBoxPacker {
        public VBoxNode packVBox(NodeList list, Dimen desired, boolean exactly, Dimen maxDepth) {
            SizesEvaluator pack = new SizesEvaluator();
            VertIterator.summarize(list.nodes(), pack);
            if (maxDepth != null) {
                pack.restrictDepth(maxDepth);
            }
            Dimen size = pack.getBody().plus(pack.getHeight());
            boolean empty = list.isEmpty();
            if (exactly) {
                pack.evaluate(desired.minus(size), empty);
                size = desired;
            } else {
                pack.evaluate(desired, empty);
                size = size.plus(desired);
            }
            BoxSizes sizes = new BoxSizes(size, pack.getWidth(), pack.getDepth(), pack.getLeftX());
            VBoxNode vbox = new VBoxNode(sizes, pack.getSetting(), list);
            if (this.check(pack)) {
                this.reportBox(vbox);
            }
            return vbox;
        }

        protected String getName() {
            return "vbox";
        }

        protected String getDim() {
            return "high";
        }

        protected int getBadnessParam() {
            return INTP_VBADNESS;
        }

        protected int getFuzzParam() {
            return DIMP_VFUZZ;
        }
    }

    public static interface FontDimen {
        public Dimen get();

        public void set(Dimen var1);
    }

    public static interface TypoHandler {
        public FontMetric getMetric(FileName var1, Dimen var2, Num var3, Name var4, Loggable var5);

        public FontDimen getFontDimen(FontMetric var1, int var2);

        public TypeSetter getSetter();
    }

    public static interface Config {
        public void setLastBadness(int var1);

        public void setOutputPenalty(int var1);

        public int[] currPageNumbers();

        public void checkParagraph(Token var1);

        public void resetParagraph();

        public void setMarginSkipsShrinkFinite();

        public boolean activeOutput();

        public boolean pendingOutput();

        public void resetOutput();

        public LinesShape linesShape();

        public Language getLanguage();

        public Language getLanguage(int var1);

        public boolean languageDiffers(Language var1);

        public boolean patternsAllowed();

        public void preparePatterns();
    }
}

