/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.Builder;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.DelFractionNoad;
import nts.noad.Delimiter;
import nts.noad.EmptyField;
import nts.noad.Field;
import nts.noad.FractionNoad;
import nts.noad.Noad;
import nts.noad.NoadList;
import nts.noad.NoadListField;
import nts.noad.NodeField;
import nts.noad.OrdNoad;
import nts.node.Box;
import nts.node.BoxLeaders;
import nts.node.BoxSizes;
import nts.node.HKernNode;
import nts.node.HLeadRuleNode;
import nts.node.HLeadersNode;
import nts.node.HSkipNode;
import nts.node.Leaders;
import nts.node.NamedHSkipNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.RuleNode;

public abstract class MathBuilder
extends Builder {
    protected NoadList list;
    protected final int startLine;
    protected final Noad leftDelim;
    private NoadList numerator = null;
    private Dimen thickness;
    private Delimiter fractLeft = null;
    private Delimiter fractRight = null;

    public void addNoad(Noad noad) {
        this.list.append(noad);
    }

    public Noad lastNoad() {
        return this.list.lastNoad();
    }

    public void removeLastNoad() {
        this.list.removeLastNoad();
    }

    public void replaceLastNoad(Noad noad) {
        this.list.replaceLastNoad(noad);
    }

    public void addNode(Node node) {
        this.list.append(node);
    }

    public void addNodes(NodeEnum nodes) {
        this.list.append(nodes);
    }

    public Node lastNode() {
        return this.list.lastNode();
    }

    public void removeLastNode() {
        this.list.removeLastNode();
    }

    public Node lastSpecialNode() {
        return this.list.lastSpecialNode();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public boolean unBox(Box box) {
        return false;
    }

    public boolean isMath() {
        return true;
    }

    public boolean isCharAllowed() {
        return true;
    }

    public boolean forbidsThirdPartOfDiscretionary() {
        return true;
    }

    public void addKern(Dimen kern) {
        this.addNode(new HKernNode(kern));
    }

    public void addSkip(Glue skip) {
        this.addNode(new HSkipNode(skip));
    }

    public void addNamedSkip(Glue skip, String name) {
        this.addNode(new NamedHSkipNode(skip, name));
    }

    public void addRule(BoxSizes sizes) {
        this.addNode(new RuleNode(sizes));
    }

    public void addLeaders(Glue skip, Leaders lead) {
        this.addNode(new HLeadersNode(skip, lead));
    }

    public void addLeadRule(Glue skip, BoxSizes sizes, String desc) {
        this.addNode(new HLeadRuleNode(skip, sizes, desc));
    }

    public BoxLeaders.Mover getBoxLeadMover() {
        return HLeadersNode.BOX_MOVER;
    }

    public void addBox(Node box) {
        this.list.append(new OrdNoad(new NodeField(box)));
    }

    public boolean canTakeLastBox() {
        return false;
    }

    private FractionNoad makeFraction(NoadList num, Field den) {
        return this.fractLeft != null ? new DelFractionNoad(new NoadListField(num), den, this.thickness, this.fractLeft, this.fractRight) : new FractionNoad(new NoadListField(num), den, this.thickness);
    }

    public boolean alreadyFractioned() {
        return this.numerator != null;
    }

    public boolean isEmpty() {
        return this.list.isEmpty() && !this.alreadyFractioned();
    }

    public void fractione(Dimen thickness) {
        this.numerator = this.getList();
        this.list = new NoadList();
        this.thickness = thickness;
    }

    public void fractione(Dimen thickness, Delimiter left, Delimiter right) {
        this.fractione(thickness);
        this.fractLeft = left;
        this.fractRight = right;
    }

    public NoadList getList() {
        return this.numerator == null ? this.list : new NoadList(this.makeFraction(this.numerator, new NoadListField(this.list)));
    }

    protected void specialShow(Log log, int depth, int breadth) {
        CntxLog.addItems(log, (this.alreadyFractioned() ? this.list : this.fakeLeftDelim(this.list)).noads(), depth, breadth);
        log.endLine();
        if (this.alreadyFractioned()) {
            log.add("this will be denominator of:");
            CntxLog.addItem(log, this.makeFraction(this.fakeLeftDelim(this.numerator), EmptyField.FIELD), depth, breadth);
        }
    }

    private NoadList fakeLeftDelim(NoadList list) {
        if (this.leftDelim == null) {
            return list;
        }
        NoadList faked = new NoadList(list.length() + 1);
        return faked.append(this.leftDelim).append(list);
    }

    public void setEqNo(Node node, boolean left) {
    }

    protected MathBuilder(int startLine, NoadList list, Noad leftDelim) {
        this.startLine = startLine;
        this.list = list;
        this.leftDelim = leftDelim;
    }

    protected MathBuilder(int startLine, NoadList list) {
        this(startLine, list, null);
    }

    protected MathBuilder(int startLine, Noad leftNoad) {
        this(startLine, new NoadList(), leftNoad);
    }

    protected MathBuilder(int startLine) {
        this(startLine, new NoadList());
    }
}

