/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.Builder;
import nts.command.CommandBase;
import nts.command.SimpleGroup;
import nts.command.Token;
import nts.io.CharCode;
import nts.math.FormulaBuilder;
import nts.math.MathBuilder;
import nts.math.MathPrim;
import nts.math.MathShiftToken;
import nts.noad.ConvStyle;
import nts.noad.Conversion;
import nts.noad.Delimiter;
import nts.noad.MathOffNode;
import nts.noad.MathOnNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.FontMetric;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.MathWordBuilder;
import nts.node.NamedHSkipNode;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.TreatNode;
import nts.typo.TypoCommand;

public class FormulaGroup
extends SimpleGroup {
    public static final int DIMP_MATH_SURROUND = CommandBase.newDimParam();
    public static final int INTP_DELIMITER_FACTOR = CommandBase.newIntParam();
    public static final int DIMP_NULL_DELIMITER_SPACE = CommandBase.newDimParam();
    public static final int DIMP_DELIMITER_SHORTFALL = CommandBase.newDimParam();
    public static final int DIMP_SCRIPT_SPACE = CommandBase.newDimParam();
    public static final byte TEXT_SIZE = 0;
    public static final byte SCRIPT_SIZE = 1;
    public static final byte SCRIPT_SCRIPT_SIZE = 2;
    public static final byte NUMBER_OF_FONT_SIZES = 3;
    protected MathBuilder builder;

    public void start() {
        Builder.push(this.builder);
    }

    public void stop() {
        Builder.pop();
        Dimen surr = CommandBase.getConfig().getDimParam(DIMP_MATH_SURROUND);
        Builder bld = TypoCommand.getBld();
        bld.addNode(new MathOnNode(surr));
        if (FormulaGroup.necessaryParamsDefined()) {
            bld.addNodes(Conversion.madeOf(this.builder.getList().noads(), new FormulaStyle(1, bld.willBeBroken())).nodes());
        }
        bld.addNode(new MathOffNode(surr));
        bld.resetSpaceFactor();
    }

    public Token expectedToken() {
        return MathShiftToken.TOKEN;
    }

    public static boolean expectAnotherMathShift() {
        Token tok = CommandBase.nextExpToken();
        if (!CommandBase.meaningOf(tok).isMathShift()) {
            CommandBase.backToken(tok);
            CommandBase.error("BadFormulaEnd");
            return false;
        }
        return true;
    }

    private static boolean isScriptSize(byte size) {
        return size >= 1;
    }

    public static boolean necessaryParamsDefined() {
        if (!FormulaGroup.necessaryParamsDefined((byte)2, FontMetric.ALL_MATH_SYMBOL_DIMEN_PARAMS)) {
            CommandBase.error("InsufSymFonts");
            return false;
        }
        if (!FormulaGroup.necessaryParamsDefined((byte)3, FontMetric.ALL_MATH_EXTENSION_DIMEN_PARAMS)) {
            CommandBase.error("InsufExtFonts");
            return false;
        }
        return true;
    }

    public static boolean necessaryParamsDefined(byte fam, int[] idxs) {
        byte s = 0;
        while (s < 3) {
            if (!MathPrim.getMathConfig().familyFont(s, fam).definesDimenParams(idxs)) {
                return false;
            }
            s = (byte)(s + 1);
        }
        return true;
    }

    protected FormulaGroup(MathBuilder builder) {
        this.builder = builder;
    }

    public FormulaGroup(FormulaBuilder builder) {
        this((MathBuilder)builder);
    }

    public FormulaGroup() {
        this(new FormulaBuilder(CommandBase.currLineNumber()));
    }

    protected static class FormulaStyle
    extends ConvStyle {
        protected byte fontSize;
        protected final boolean penalties;

        protected void setupFontSize() {
            switch (this.style) {
                case 3: {
                    this.fontSize = (byte)2;
                    break;
                }
                case 2: {
                    this.fontSize = 1;
                    break;
                }
                default: {
                    this.fontSize = 0;
                    break;
                }
            }
        }

        protected FontMetric fetchFontMetric(byte fam) {
            return MathPrim.getMathConfig().familyFont(this.fontSize, fam);
        }

        private void metricError(byte fam, CharCode code) {
            CommandBase.error("UndefFamily", CommandBase.esc(MathPrim.getMathConfig().familyName(this.fontSize, fam)), CommandBase.num(fam), code);
        }

        public Node fetchCharNode(byte fam, CharCode code) {
            FontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return null;
            }
            Node node = metric.getCharNode(code);
            if (node == null) {
                TypoCommand.charWarning(metric, code);
            }
            return node;
        }

        public Node fetchLargerNode(byte fam, CharCode code) {
            FontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return null;
            }
            Node node = metric.getLargerNode(code);
            if (node == null) {
                TypoCommand.charWarning(metric, code);
            }
            return node;
        }

        public Box fetchFittingWidthBox(byte fam, CharCode code, Dimen desired) {
            FontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return null;
            }
            Box box = metric.getFittingWidthBox(code, desired);
            if (box == null) {
                TypoCommand.charWarning(metric, code);
            }
            return box;
        }

        public Node fetchSufficientNode(Delimiter delimiter, Dimen desired) {
            Dimen maxSize = Dimen.ZERO;
            Node maxNode = null;
            boolean large = false;
            byte fam = delimiter.getSmallFam();
            CharCode code = delimiter.getSmallCode();
            block0: while (true) {
                if (code != null) {
                    byte s = this.fontSize;
                    while (s >= 0) {
                        Dimen size;
                        FontMetric metric = MathPrim.getMathConfig().familyFont(s, fam);
                        Node node = metric.getSufficientNode(code, desired);
                        if (node != null && (size = node.getHeight().plus(node.getDepth())).moreThan(maxSize)) {
                            maxSize = size;
                            maxNode = node;
                            if (!size.lessThan(desired)) break block0;
                        }
                        s = (byte)(s - 1);
                    }
                }
                if (large) break;
                large = true;
                fam = delimiter.getLargeFam();
                code = delimiter.getLargeCode();
            }
            return maxNode != null ? maxNode : new HBoxNode(new BoxSizes(Dimen.ZERO, CommandBase.getConfig().getDimParam(DIMP_NULL_DELIMITER_SPACE), Dimen.ZERO, Dimen.ZERO), GlueSetting.NATURAL, NodeList.EMPTY);
        }

        public Dimen getXHeight(byte fam) {
            return this.fetchFontMetric(fam).getDimenParam(4);
        }

        public Dimen skewAmount(byte fam, CharCode code) {
            Dimen skew;
            CharCode skewCode;
            FontMetric metric = this.fetchFontMetric(fam);
            Num skewCharNum = metric.getNumParam(1);
            if (skewCharNum != null && (skewCode = Token.makeCharCode(skewCharNum.intVal())) != null && (skew = metric.getKernBetween(code, skewCode)) != null) {
                return skew;
            }
            return Dimen.ZERO;
        }

        public Dimen delimiterSize(Dimen height, Dimen depth) {
            Dimen max = height.max(depth);
            Dimen size = max.over(500).times(CommandBase.getConfig().getIntParam(INTP_DELIMITER_FACTOR));
            max = max.times(2).minus(CommandBase.getConfig().getDimParam(DIMP_DELIMITER_SHORTFALL));
            return max.max(size);
        }

        public Dimen scriptSpace() {
            return CommandBase.getConfig().getDimParam(DIMP_SCRIPT_SPACE);
        }

        public Node getSpacing(byte left, byte right) {
            MathPrim.MathSpacer spacer = MathPrim.getMathConfig().mathSpacing(left, right);
            Glue space = spacer.getGlue(this.fontSize);
            return space.isZero() ? null : new NamedHSkipNode(this.muToPt(space), spacer.getName());
        }

        public Num getPenalty(byte left, byte right) {
            return this.penalties ? MathPrim.getMathConfig().mathPenalty(left, right) : null;
        }

        public boolean isScript() {
            return FormulaGroup.isScriptSize(this.fontSize);
        }

        public ConvStyle makeNew(byte style) {
            return new FormulaStyle(style, false, this.penalties);
        }

        protected ConvStyle deriveNew(byte style, boolean cramped) {
            return new FormulaStyle(style, cramped, false);
        }

        public MathWordBuilder getWordBuilder(byte fam, TreatNode proc) {
            FontMetric metric = this.fetchFontMetric(fam);
            return metric.isNull() ? null : metric.getMathWordBuilder(proc);
        }

        public boolean forcedItalCorr(byte fam) {
            return this.fetchFontMetric(fam).getDimenParam(1).isZero();
        }

        protected FormulaStyle(byte style, boolean cramped, boolean penalties) {
            super(style, cramped);
            this.penalties = penalties;
        }

        public FormulaStyle(byte style, boolean penalties) {
            this(style, false, penalties);
        }
    }
}

