/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import java.util.HashMap;
import java.util.Vector;
import nts.base.Dimen;
import nts.base.IntPairKey;

public class AlignSizesMatrix {
    private final Vector diagonal;
    private final HashMap matrix;

    public int size() {
        return this.diagonal.size();
    }

    public Dimen get(int i) {
        return i < this.diagonal.size() ? (Dimen)this.diagonal.get(i) : null;
    }

    public Dimen get(int i, int j) {
        return i != j ? (Dimen)this.matrix.get(new IntPairKey(i, j)) : this.get(i);
    }

    public Dimen set(int i, int j, Dimen value) {
        if (i != j) {
            return this.matrix.put(new IntPairKey(i, j), value);
        }
        if (i >= this.diagonal.size()) {
            this.diagonal.setSize(i + 1);
        }
        return this.diagonal.set(i, value);
    }

    public void setMax(int i, int j, Dimen value) {
        if (i != j) {
            IntPairKey key = new IntPairKey(i, j);
            Dimen old = (Dimen)this.matrix.get(key);
            if (old == null || value.moreThan(old)) {
                this.matrix.put(key, value);
            }
        } else if (i >= this.diagonal.size()) {
            this.diagonal.setSize(i + 1);
            this.diagonal.set(i, value);
        } else {
            Dimen old = (Dimen)this.diagonal.get(i);
            if (old == null || value.moreThan(old)) {
                this.diagonal.set(i, value);
            }
        }
    }

    public AlignSizesMatrix() {
        this.diagonal = new Vector();
        this.matrix = new HashMap();
    }

    public AlignSizesMatrix(int initialSize) {
        this.diagonal = new Vector(initialSize);
        this.matrix = new HashMap();
    }
}

