#!/bin/sh
#
# shell script to convert LaTeX, SliTeX, and TeX documents to ascii text
#
# Copyright (C) 1988 by Olivetti Research Center
#
# Author:
#	Pehong Chen
#	Olivetti Research Center
#	Menlo Park, California
#	(chen@orc.olivetti.com)
#

tmp=./#TMP#
txt=
stdout=
maxcount=3

trap "rm -f $src
rm -f $dvi
rm -f $log
if test -d "$tmp"; then
	mv $tmp/* .
	rm -rf $tmp
fi" 0 1 2 15

TEXFONTS=.:/silo/tex/tfm
export TEXFONTS

prog="`basename $0`"
version="Olivetti Version 1.2"
date="<10 Jan 1989>"
default="$prog [-e] [-s<starting page>] [-m<no. of pages>] <filename>"

if test $# -eq 0; then
	echo "Argument missing."
	echo "$default"
	exit 1
fi

echo "This is $prog, a TeX-to-ascii converter, $version $date" >&2
/bin/echo -n "Checking arguments and backing up files" >&2

src=
format=latex
convert=dvidoc
flags=-e
sp=
np=

while test $# -gt 0; do
	/bin/echo -n "." >&2
	case $1 in
	-s[0-9]*)
		flags="$flags $1"
		sp="`echo $1 | sed 's/-s//'`"
		;;
	-m[0-9]*)
		flags="$flags $1"
		np="`echo $1 | sed 's/-m//'`"
		;;
	-o)
		stdout=TRUE
		;;
	-*)
		echo "..falied" >&2
		echo "Unknown option $1." >&2
		echo "$default" >&2
		exit 1
		;;
	*)
		if test -z "$1"; then
			echo "..falied" >&2
			echo "No source file specified." >&2
			echo "$default" >&2
			exit 1
		fi
		src="$1"
		;;
	esac
	shift
done

/bin/echo -n "." >&2
if test -r "$src"; then
	base=`echo $src | sed 's/\..*//'`
else
	if test -r "$src.tex"; then
		base=$src
		src="$src.tex"
	else
		echo ".falied" >&2
		echo "Failed to find file $src or $src.tex." >&2
		echo "$default" >&2
		exit 1
	fi
fi

dvi=$base.dvi
log=$base.log
txt=$base.txt
err=$base.err
tmpsrc=$tmp/$src
tmpdvi=$tmp/$dvi
tmplog=$tmp/$log

rm -rf $tmp
mkdir $tmp

/bin/echo -n "." >&2
if test -r "$src"; then
	mv -f $src $tmpsrc
fi

/bin/echo -n "." >&2
if test -r "$dvi"; then
	mv -f $dvi $tmpdvi
fi

/bin/echo -n "." >&2
if test -r "$log"; then
	mv -f $log $tmplog
fi

for i in *.aux
do
	/bin/echo -n "." >&2
	if test -r "$i"; then
		cp $i $tmp
	fi
done

/bin/echo -n "." >&2
if test "`egrep "\\documentstyle.*{.*}" $tmpsrc`"; then
	/bin/echo -n "." >&2
	if test "`egrep "\\documentstyle.*{slides}" $tmpsrc`"; then
		format=slitex
	fi
	/bin/echo -n "." >&2
	sed 's/\(\\documentstyle\[.*\),dvidoc\(.*\]\)/\1\2/
	s/\(\\documentstyle\[\)dvidoc,\(.*\]\)/\1\2/
	s/\(\\documentstyle\[.*\)\]/\1,dvidoc\]/
	s/\(\\setlength{\\textwidth}\)/% \1/
	s/^\(\\textwidth\)/% \1/
	s/\\documentstyle{/\\documentstyle[dvidoc]{/' < $tmpsrc > $src
else
	/bin/echo -n "." >&2
	format=tex
	echo "\\input $convert" > $src
	cat $tmpsrc >> $src
fi
echo "done" >&2

echo "Reformatting $src for plain text output..." >&2
count=0
base=`basename $src .tex`
bibdone=""
inddone=""
while test $count -le $maxcount; do
	rerun=""
	$format $src >&2
	if test $count -eq 0; then
		if test ! "$bibdone" -a "`grep \^\\\\bibdata $base.log`" != ""; then
			bibtex $base >&2
			rerun="yes"
			bibdone="yes"
		fi
	        if test ! "$inddone" -a -r $base.idx; then
			makeindex $base >&2
			rerun="yes"
			inddone="yes"
		fi
	fi
	grep 'Rerun to get cross-references right.' $base.log >/dev/null && rerun="yes"
	if test ! "$rerun"; then
		break
	fi
        count=${count}1
done

if test -s "$dvi"; then
	if test "$sp" -a "$np"; then
		/bin/echo -n "Converting dvi to ascii text from page $sp for $np pages..." >&2
	else if test "$sp"; then
		/bin/echo -n "Converting dvi to ascii text from page $sp to the end..." >&2
	else if test "$np"; then
		/bin/echo -n "Converting dvi to ascii text from page 1 for $np pages >&2
..."
	else
		/bin/echo -n "Converting from dvi to ascii text..." >&2
	fi fi fi

	$convert $flags $dvi 1>$txt 2>&2
	echo "done" >&2
	if test -s "$txt"; then
		echo "Corresponding ascii text written in $txt." >&2
	fi
	if test -s "$err"; then
		echo "Conversion error log written in $err." >&2
	fi
else
	echo "Formatting aborted, no text file generated." >&2
fi

echo "Original files restored from backups." >&2

if test "$stdout" -a -s "$txt"; then
	cat $txt >&1
	rm -f "$txt"
fi
