extern int          frame_width;
extern int          frame_height;
extern long         frame_size;
extern int          frame_valid;

#ifndef IBMPC
extern byte huge   *frame_buffer;
#define frame_or(a,x)   frame_buffer[a] |= (x)
#define frame_get(a)    frame_buffer[a]
#define frame_set(p,l)  frame_buffer = p
#define frame_and(a,x)  frame_buffer[a] &= (x)
#define frame_ptr(a)    (frame_buffer+(a))
#define frame_poke(a,x) frame_buffer[a] = (x)
#define frame_clr()     memset((char*)frame_buffer,0,frame_size)
#define frame_max()     op.pixmem
#ifndef AMIGA
#define frame_alloc(s)  mem_alloc(s,"Frame-Buffer")
#define frame_free(p,s) mem_free(p,s)
#else
extern void *(*frame_alloc)( long );
extern void (*frame_free)( void *, long );
#endif
#else
extern void         (*frame_or)(long a, byte x);
extern byte         (*frame_get)(long a);
extern void         (*frame_set)(byte huge *p, long len);
extern void         (*frame_poke)(long a, byte x);
extern void         (*frame_and)(long a, byte x);
extern byte huge *  (*frame_ptr)(long a);
extern void         (*frame_clr)(void);
extern void huge *  (*frame_alloc)(long);
extern void         (*frame_free)(void huge*,long);
extern long         frame_max(void);

extern long get_extended(void);
extern void movetoe(byte huge *p, long address, long len);
extern void movefrome(byte huge *p, long address, long len);

#endif

