---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, marges, geometry, vmargin, chngpage, 
              truncate, typearea, narrow
---

# Comment modifier les marges d'un document ?

Si vous êtes impatient de faire les réglages de marge par vous-même 
et que vous avez lu les mises en garde décrites dans la question 
"[](modifier_les_parametres_de_page)", il est important que 
vous commenciez par vous familiariser avec les paramètres de mise 
en page de LaTeX dans la documentation disponible 
[libre](/1_generalites/documentation/documents/documents_sur_latex2e) 
ou [payante](/1_generalites/documentation/livres/documents_sur_latex). 
Cette FAQ liste également les différents paramètres à la question 
"[](liste_des_parametres_de_page)".

Si votre besoin de changement de présentation est propre à une seule partie
de votre document, vous pouvez vous tourner vers la question 
"[](modifier_les_marges_en_cours_de_document)".


## Avec l'extension <ctanpkg:geometry>

L'extension <ctanpkg:geometry> permet de redéfinir les marges d'un document
ou de définir la mise en page. Plusieurs possibilités existent :

```
\documentclass[a4paper,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage[margin=2.5cm]{geometry}

\begin{document}
\lipsum[1-5]
\end{document}
```

Ce choix est équivalent à plusieurs autres possibilités :

```{noedit}
\usepackage[hmargin=2.5cm, vmargin=2.5cm]{geometry}
équivalent à
\usepackage[margin={2.5cm,2.5cm}]{geometry}
équivalent à
\usepackage[left=2.5cm, right=2.5cm, top=2.5cm, bottom=2.5cm]{geometry}
```

Vous pouvez même configurer différemment les marges sur les pages paires 
et impaires (en jouant sur les marges *intérieures* et *extérieures* 
des pages) :

```
\documentclass[a4paper,french,twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage[inner=1.0in,% Marge intérieure
              outer=0.5in,% Marge extérieure
              top=0.4in,
              bottom=0.75in,
              bindingoffset=0.2in% Marge de reliure
             ]{geometry}

\begin{document}
\lipsum[1-12]
\end{document}
```

L'exemple ci-dessous permet de voir l'effet de l'option `nohead`, 
qui supprime l'en-tête d'un document.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{geometry}

  \geometry{scale=1.0, nohead}

\begin{document}
\lipsum[1-5]
\end{document}
```


## Avec l'extension <ctanpkg:vmargin>

L'extension <ctanpkg:vmargin> de Volker Kuhlmann, datant de 2004, 
permet de redéfinir les marges de la totalité du document 
grâce à la commande : `\setmarginsrb{1}{2}{3}{4}{5}{6}{7}{8}` où

- `1` est la marge gauche ;
- `2` est la marge en haut ;
- `3` est la marge droite ;
- `4` est la marge en bas ;
- `5` fixe la hauteur de l'en-tête ;
- `6` fixe la distance entre l'en-tête et le texte ;
- `7` fixe la hauteur du pied de page ;
- `8` fixe la distance entre le texte et le pied de page.

Vous pouvez également utiliser des valeurs calculées à partir 
du papier utilisé, comme par exemple : `\setpapersize{A4}`

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{vmargin}

  \setpapersize{A4}
  \setmarginsrb{40mm}{30mm}{70mm}{30mm}{0cm}{0mm}{0cm}{0mm}

\begin{document}
\lipsum[1-5]
\end{document}
```


## Avec l'extension <ctanpkg:typearea>

L'extension <ctanpkg:typearea> appartient à l'ensemble 
<ctanpkg:KOMA-script>. Elle se base sur des principes de construction
issus de techniques typographiques utilisant des grilles. 
Elle présente, en conséquence, une syntaxe assez différente 
de celle des autres extensions.

La page est analysée :
- en tenant compte d'une marge de reliure, `BCOR`, retranchée 
  de la page car ne pouvant contenir de texte ;
- en scindant la page restante en `DIV` rangées de même taille 
  et `DIV` colonnes de même taille ;

Puis les marges (et donc la zone de texte) sont définies ainsi :
- la première rangée sert pour la marge de haut de page 
  tandis que les deux dernières rangées servent de marge 
  de bas de page ;
- la marge intérieure (proche de la reluire) est constituée 
  d'une colonne et la marge extérieure de deux colonnes 
  (pour les documents recto-verso).

En voici un exemple d'utilisation :

```
\documentclass[twoside,BCOR=40mm,DIV=12,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{typearea}

\begin{document}
\lipsum[1-8]
\end{document}
```

La [documentation de l'extension](texdoc:koma-script) précise amplement
les possibilités de construction de la page et de ses marges, 
afin de mieux adapter cette technique, par exemple, 
selon la taille des caractères.


## Avec l'extension <ctanpkg:chngpage>

:::{todo} Remplacer par <ctanpkg:changepage>
:::

:::{warning}
L’extension <ctanpkg:chngpage> est classée comme 
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). 
Ce qui suit est informatif. L'extension <ctanpkg:changepage> doit 
être utilisée pour la remplacer pour tout nouveau document.
:::

L'environnement `adjustwidth` de l'extension <ctanpkg:chngpage> 
permet de modifier localement les marges d'un document. Il prend 
deux arguments : la marge gauche et la marge droite (ces arguments 
peuvent prendre des valeurs négatives). 
En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{chngpage}

\begin{document}
\begin{adjustwidth}{2cm}{-1cm}
  Ceci permet d'augmenter la marge gauche de 2cm
  et de diminuer celle de droite de 1cm.
\end{adjustwidth}
À comparer avec un texte qui occupe toute
la largeur de la page, comme celui-ci par exemple.
\end{document}
```

L'environnement `narrow`, de Keith Reckdahl, se concentre 
sur une fonctionnalité tout à fait similaire.

Une copie de cette extension `narrow` (sans numéro de version) 
est mise à disposition [ici](/_static/old_extensions/narrow.sty),
son code contenant une très courte documentation. 
La voici réutilisée en reportant son code dans notre exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

  % Le code de l'extension narrow
  \newenvironment{narrow}[2]{%
    \begin{list}{}{%
      \setlength{\topsep}{0pt}%
      \setlength{\leftmargin}{#1}%
      \setlength{\rightmargin}{#2}%
      \setlength{\listparindent}{\parindent}%
      \setlength{\itemindent}{\parindent}%
      \setlength{\parsep}{\parskip}%
      }%
    \item[]}{\end{list}}

\begin{document}
\begin{narrow}{1.0cm}{0.5cm} 
\lipsum[1-5]
\end{narrow}
\end{document}
```


## Avec l'extension <ctanpkg:anysize>

:::{warning}
L’extension <ctanpkg:anysize>, datant de 1994, est classée comme 
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). 
Les extensions <ctanpkg:geometry> et <ctanpkg:typearea> proposent 
des fonctionnalités similaires et doivent être privilégiées.

L'utilisation de l'extension<ctanpkg:anysize> peut même poser 
des difficultés, comme le montre la question 
"[Why are margins unequal?](https://tex.stackexchange.com/q/204943)" 
sur [Tex Stack Exchange](https://tex.stackexchange.com/).
:::


## Avec les commandes de base

Si vous préférez une intervention plus directe, vous pouvez vous tourner 
vers la question "[](modifier_les_parametres_de_page)".


:::{sources}
[Changing the margins in LaTeX](faquk:FAQ-changemargin)
:::