/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.datastructure.FloatArrayList;
import korlibs.datastructure.IntArrayList;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.lang.StringExtKt;
import korlibs.io.util.BaseStrReader;
import korlibs.io.util.NumberParser;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 Z2\u00020\u0001:\u0003Z[\\B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u0003J\u0018\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u0006H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0006\u0010/\u001a\u00020+J\b\u00100\u001a\u00020+H\u0016J\u0018\u00101\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\b\b\u0002\u00102\u001a\u00020\u0006J\u0010\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000204J0\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u000307j\b\u0012\u0004\u0012\u00020\u0003`82\u0018\b\u0002\u00105\u001a\u0012\u0012\u0004\u0012\u00020\u000307j\b\u0012\u0004\u0012\u00020\u0003`8J\u0010\u00109\u001a\u00020:2\b\b\u0002\u00105\u001a\u00020:J\u000e\u0010;\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010<\u001a\u00020\u0003J\u0010\u0010=\u001a\u00020\u00032\b\b\u0002\u0010>\u001a\u00020\fJ\u001d\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\f0AH\u0086\bJ\u0010\u0010?\u001a\u00020\u00032\u0006\u0010B\u001a\u00020+H\u0016J\u000e\u0010C\u001a\u00020\u00032\u0006\u0010B\u001a\u00020+J\u001d\u0010D\u001a\u00020\u00032\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\f0AH\u0086\bJ\u0006\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0006H\u0016J\b\u0010H\u001a\u00020\u0000H\u0016J\u000e\u0010I\u001a\u00020F2\u0006\u0010B\u001a\u00020+J\u000e\u0010J\u001a\u00020F2\u0006\u0010B\u001a\u00020+J\u0016\u0010K\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006J\u0018\u0010L\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u001a\u0010M\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\fH\u0016J\u0010\u0010O\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u0003J\b\u0010P\u001a\u0004\u0018\u00010\u0003J\u000e\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u0006J\u0010\u0010S\u001a\u00020T2\b\b\u0002\u0010R\u001a\u00020TJ\u0010\u0010U\u001a\u0004\u0018\u00010\u00032\u0006\u0010V\u001a\u00020WJ\u0010\u0010X\u001a\u0004\u0018\u00010\u001b2\u0006\u0010V\u001a\u00020WJ\u0010\u0010Y\u001a\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lkorlibs/io/util/StrReader;", "Lkorlibs/io/util/BaseStrReader;", "str", "", "file", "pos", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "available", "getAvailable", "()I", "eof", "", "getEof", "()Z", "getFile", "()Ljava/lang/String;", "length", "getLength", "getPos", "setPos", "(I)V", "getStr", "tempCharArray", "", "clone", "createRange", "Lkorlibs/io/util/StrReader$TRange;", "start", "end", "range", "Lkotlin/ranges/IntRange;", "endBuffering", "matchLit", "lit", "matchLitListRange", "lits", "Lkorlibs/io/util/StrReader$Literals;", "matchLitRange", "matchStartEnd", "peek", "count", "peekChar", "", "peekOffset", "offset", "posSkip", "read", "readChar", "readFixedSizeInt", "radix", "readFloats", "Lkorlibs/datastructure/FloatArrayList;", "list", "readIds", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "readInts", "Lkorlibs/datastructure/IntArrayList;", "readRange", "readRemaining", "readStringLit", "reportErrors", "readUntil", "filter", "Lkotlin/Function1;", "char", "readUntilIncluded", "readWhile", "reset", "", "skip", "skipSpaces", "skipUntil", "skipUntilIncluded", "slice", "substr", "tryLit", "consume", "tryLitRange", "tryReadId", "tryReadInt", "default", "tryReadNumber", "", "tryRegex", "v", "Lkotlin/text/Regex;", "tryRegexRange", "unread", "Companion", "Literals", "TRange", "korio"})
@SourceDebugExtension(value={"SMAP\nStrReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader\n+ 2 StrReader.kt\nkorlibs/io/util/BaseStrReader\n+ 3 _FastArrayIterators.kt\nkorlibs/datastructure/iterators/_FastArrayIteratorsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n52#2,5:510\n52#2,5:515\n52#2,3:520\n103#2,4:523\n56#2:527\n52#2,3:528\n109#2,2:531\n56#2:533\n103#2,4:537\n103#2,4:542\n33#3,3:534\n1#4:541\n*S KotlinDebug\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader\n*L\n241#1:510,5\n242#1:515,5\n243#1:520,3\n243#1:523,4\n243#1:527\n244#1:528,3\n244#1:531,2\n244#1:533\n446#1:537,4\n498#1:542,4\n282#1:534,3\n*E\n"})
public final class StrReader
extends BaseStrReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String str;
    @NotNull
    private final String file;
    private int pos;
    @NotNull
    private final char[] tempCharArray;
    private final int length;

    public StrReader(@NotNull String str, @NotNull String file, int pos) {
        this.str = str;
        this.file = file;
        this.pos = pos;
        this.tempCharArray = new char[this.str.length()];
        this.length = this.str.length();
    }

    public /* synthetic */ StrReader(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "file";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, string2, n);
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getAvailable() {
        return this.length - this.getPos();
    }

    @Override
    public boolean getEof() {
        return this.getPos() >= this.str.length();
    }

    public final void reset() {
        this.setPos(0);
    }

    @NotNull
    public final TRange createRange(@NotNull IntRange range) {
        return this.createRange(range.getStart(), range.getEndInclusive() + 1);
    }

    @NotNull
    public final TRange createRange(int start, int end2) {
        return new TRange(start, end2, this);
    }

    public static /* synthetic */ TRange createRange$default(StrReader strReader, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = strReader.getPos();
        }
        if ((n3 & 2) != 0) {
            n2 = strReader.getPos();
        }
        return strReader.createRange(n, n2);
    }

    @NotNull
    public final TRange readRange(int length) {
        TRange range = new TRange(this.getPos(), this.getPos() + length, this);
        this.setPos(this.getPos() + length);
        return range;
    }

    @Override
    @NotNull
    public String endBuffering(int start) {
        return this.slice(start, this.getPos());
    }

    @Override
    @NotNull
    public StrReader skipSpaces() {
        super.skipSpaces();
        return this;
    }

    @NotNull
    public final String slice(int start, int end2) {
        if (start == end2) {
            return "";
        }
        String string = this.str.substring(start, end2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Override
    @NotNull
    public String peek(int count2) {
        return this.substr(this.getPos(), count2);
    }

    @Override
    public char peekChar() {
        return this.getHasMore() ? this.str.charAt(this.getPos()) : (char)'\u0000';
    }

    public final void skipUntil(char c) {
        int skipPos = StringsKt.indexOf$default((CharSequence)this.str, c, this.getPos(), false, 4, null);
        this.setPos(skipPos >= 0 ? skipPos : this.length);
    }

    public final void skipUntilIncluded(char c) {
        this.skipUntil(c);
        if (this.getHasMore() && this.peekChar() == c) {
            this.skip(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String readUntil(char c) {
        BaseStrReader this_$iv = this;
        boolean $i$f$slice = false;
        int start$iv = this_$iv.startBuffering();
        try {
            boolean bl = false;
            this.skipUntil(c);
        }
        finally {
            String string = this_$iv.endBuffering(start$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readUntilIncluded(char c) {
        BaseStrReader this_$iv = this;
        boolean $i$f$slice = false;
        int start$iv = this_$iv.startBuffering();
        try {
            boolean bl = false;
            this.skipUntilIncluded(c);
        }
        finally {
            String string = this_$iv.endBuffering(start$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readWhile(@NotNull Function1<? super Character, Boolean> filter2) {
        boolean $i$f$readWhile = false;
        BaseStrReader this_$iv = this;
        boolean $i$f$slice = false;
        int start$iv = this_$iv.startBuffering();
        try {
            boolean bl = false;
            BaseStrReader this_$iv2 = this;
            boolean $i$f$skipWhile = false;
            while (this_$iv2.getHasMore()) {
                if (filter2.invoke(Character.valueOf(this_$iv2.peekChar())).booleanValue()) {
                    this_$iv2.readChar();
                }
            }
        }
        finally {
            InlineMarker.finallyStart(1);
            String string = this_$iv.endBuffering(start$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readUntil(@NotNull Function1<? super Character, Boolean> filter2) {
        boolean $i$f$readUntil = false;
        BaseStrReader this_$iv = this;
        boolean $i$f$slice = false;
        int start$iv = this_$iv.startBuffering();
        try {
            boolean bl = false;
            BaseStrReader this_$iv2 = this;
            boolean $i$f$skipUntil = false;
            while (this_$iv2.getHasMore()) {
                if (!filter2.invoke(Character.valueOf(this_$iv2.peekChar())).booleanValue()) {
                    this_$iv2.readChar();
                }
            }
        }
        finally {
            InlineMarker.finallyStart(1);
            String string = this_$iv.endBuffering(start$iv);
        }
    }

    @NotNull
    public final StrReader unread(int count2) {
        this.setPos(this.getPos() - count2);
        return this;
    }

    public static /* synthetic */ StrReader unread$default(StrReader strReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return strReader.unread(n);
    }

    @Override
    public char readChar() {
        return this.getHasMore() ? this.str.charAt(this.posSkip(1)) : (char)'\u0000';
    }

    public final char read() {
        return this.getHasMore() ? this.str.charAt(this.posSkip(1)) : (char)'\u0000';
    }

    private final int posSkip(int count2) {
        int out = this.getPos();
        this.setPos(this.getPos() + count2);
        return out;
    }

    @NotNull
    public final String readRemaining() {
        return this.read(this.getAvailable());
    }

    @Override
    @NotNull
    public StrReader skip(int count2) {
        this.setPos(this.getPos() + count2);
        return this;
    }

    private final String substr(int pos, int length) {
        String string = this.str.substring(Math.min(pos, this.length), Math.min(pos + length, this.length));
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Override
    @Nullable
    public String tryLit(@NotNull String lit, boolean consume2) {
        if (!StringExtKt.substringEquals(StringCompanionObject.INSTANCE, this.str, this.getPos(), lit, 0, lit.length())) {
            return null;
        }
        if (consume2) {
            this.setPos(this.getPos() + lit.length());
        }
        return lit;
    }

    @Nullable
    public final TRange tryLitRange(@NotNull String lit) {
        return Intrinsics.areEqual(this.substr(this.getPos(), lit.length()), lit) ? this.readRange(lit.length()) : null;
    }

    @Nullable
    public final String matchLit(@NotNull String lit) {
        return BaseStrReader.tryLit$default(this, lit, false, 2, null);
    }

    @Nullable
    public final TRange matchLitRange(@NotNull String lit) {
        return this.tryLitRange(lit);
    }

    @Nullable
    public final TRange matchLitListRange(@NotNull Literals lits) {
        Integer[] $this$fastForEach$iv = lits.getLengths();
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.length) {
            int len = ((Number)$this$fastForEach$iv[n$iv++]).intValue();
            boolean bl = false;
            if (!lits.contains(this.substr(this.getPos(), len))) continue;
            return this.readRange(len);
        }
        return null;
    }

    @Nullable
    public final String tryRegex(@NotNull Regex v) {
        String string = this.str.substring(this.getPos());
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        MatchResult matchResult = Regex.find$default(v, string, 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        MatchGroup matchGroup = result2.getGroups().get(0);
        Intrinsics.checkNotNull(matchGroup);
        String m = matchGroup.getValue();
        this.setPos(this.getPos() + m.length());
        return m;
    }

    @Nullable
    public final TRange tryRegexRange(@NotNull Regex v) {
        String string = this.str.substring(this.getPos());
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        MatchResult matchResult = Regex.find$default(v, string, 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result2 = matchResult;
        MatchGroup matchGroup = result2.getGroups().get(0);
        Intrinsics.checkNotNull(matchGroup);
        return this.readRange(matchGroup.getValue().length());
    }

    @Nullable
    public final String matchStartEnd(@NotNull String start, @NotNull String end2) {
        if (!Intrinsics.areEqual(this.substr(this.getPos(), start.length()), start)) {
            return null;
        }
        int startIndex = this.getPos();
        int index = StringsKt.indexOf$default((CharSequence)this.str, end2, this.getPos(), false, 4, null);
        if (index < 0) {
            return null;
        }
        this.setPos(index + end2.length());
        return this.slice(startIndex, this.getPos());
    }

    @Override
    @NotNull
    public StrReader clone() {
        return new StrReader(this.str, this.file, this.getPos());
    }

    public final int readFixedSizeInt(int count2, int radix) {
        int readCount = Math.min(this.getAvailable(), count2);
        this.skip(readCount);
        return NumberParser.INSTANCE.parseInt(this.str, this.getPos() - readCount, this.getPos(), radix);
    }

    public static /* synthetic */ int readFixedSizeInt$default(StrReader strReader, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 10;
        }
        return strReader.readFixedSizeInt(n, n2);
    }

    @NotNull
    public final String readStringLit(boolean reportErrors) {
        char[] out = this.tempCharArray;
        int outp = 0;
        char quotec = this.read();
        char c = quotec;
        if (!(c == '\"' ? true : c == '\'')) {
            ExceptionsKt.invalidOp("Invalid string literal");
            throw new KotlinNothingValueException();
        }
        boolean closed = false;
        while (this.getHasMore()) {
            char c2 = this.read();
            if (c2 == '\\') {
                char c3;
                char cc = this.read();
                int n = outp++;
                char c4 = cc;
                if (c4 == '\\') {
                    c3 = 92;
                } else if (c4 == '/') {
                    c3 = 47;
                } else if (c4 == '\'') {
                    c3 = 39;
                } else if (c4 == '\"') {
                    c3 = 34;
                } else if (c4 == 'b') {
                    c3 = 8;
                } else if (c4 == 'f') {
                    c3 = 12;
                } else if (c4 == 'n') {
                    c3 = 10;
                } else if (c4 == 'r') {
                    c3 = 13;
                } else if (c4 == 't') {
                    c3 = 9;
                } else if (c4 == 'u') {
                    c3 = (char)this.readFixedSizeInt(4, 16);
                } else {
                    throw new IOException("Invalid char '" + cc + '\'');
                }
                out[n] = c3;
                continue;
            }
            if (c2 == quotec) {
                closed = true;
                break;
            }
            out[outp++] = c2;
        }
        if (!closed && reportErrors) {
            throw new RuntimeException("String literal not closed! '" + this.str + '\'');
        }
        return StringExtKt.String_fromCharArray(out, 0, outp);
    }

    public static /* synthetic */ String readStringLit$default(StrReader strReader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return strReader.readStringLit(bl);
    }

    public final int tryReadInt(int n) {
        int digitCount = 0;
        int integral = 0;
        int mult = 1;
        while (!this.getEof()) {
            char c = this.peekChar();
            if (c == '-') {
                this.skip(1);
                mult *= -1;
                continue;
            }
            boolean bl = '0' <= c ? c < ':' : false;
            if (!bl) break;
            int digit = c - 48;
            this.skip(1);
            ++digitCount;
            integral *= 10;
            integral += digit;
        }
        return digitCount == 0 ? n : integral;
    }

    public final double tryReadNumber(double d) {
        int end2;
        int start = this.getPos();
        BaseStrReader this_$iv = this;
        boolean $i$f$skipWhile = false;
        while (this_$iv.getHasMore()) {
            char it = this_$iv.peekChar();
            boolean bl = false;
            if (!(Intrinsics.compare(it, 48) >= 0 && Intrinsics.compare(it, 57) <= 0 || it == '+' || it == '-' || it == 'e' || it == 'E' || it == '.')) break;
            this_$iv.readChar();
        }
        if ((end2 = this.getPos()) == start) {
            return d;
        }
        return NumberParser.INSTANCE.parseDouble(this.str, start, end2);
    }

    public static /* synthetic */ double tryReadNumber$default(StrReader strReader, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = Double.NaN;
        }
        return strReader.tryReadNumber(d);
    }

    @Override
    public char peekOffset(int offset) {
        char c;
        CharSequence charSequence = this.str;
        int n = this.getPos() + offset;
        if (n >= 0 && n <= StringsKt.getLastIndex(charSequence)) {
            c = charSequence.charAt(n);
        } else {
            int it = n;
            boolean bl = false;
            c = '\u0000';
        }
        return c;
    }

    @NotNull
    public final FloatArrayList readFloats(@NotNull FloatArrayList list) {
        while (!this.getEof()) {
            int pos0 = this.getPos();
            float f = (float)StrReader.tryReadNumber$default(this.skipSpaces(), 0.0, 1, null);
            this.skipSpaces();
            int pos1 = this.getPos();
            if (pos1 == pos0) {
                throw new IllegalStateException(("Invalid number at " + pos0 + " in '" + this.str + '\'').toString());
            }
            list.add(f);
        }
        return list;
    }

    public static /* synthetic */ FloatArrayList readFloats$default(StrReader strReader, FloatArrayList floatArrayList, int n, Object object) {
        if ((n & 1) != 0) {
            floatArrayList = new FloatArrayList(7);
        }
        return strReader.readFloats(floatArrayList);
    }

    @NotNull
    public final ArrayList<String> readIds(@NotNull ArrayList<String> list) {
        while (!this.getEof()) {
            int pos0 = this.getPos();
            String string = this.skipSpaces().tryReadId();
            if (string == null) {
                string = "";
            }
            String id = string;
            this.skipSpaces();
            int pos1 = this.getPos();
            if (pos1 == pos0) {
                throw new IllegalStateException(("Invalid identifier at " + pos0 + " in '" + this.str + '\'').toString());
            }
            list.add(id);
        }
        return list;
    }

    public static /* synthetic */ ArrayList readIds$default(StrReader strReader, ArrayList arrayList, int n, Object object) {
        if ((n & 1) != 0) {
            arrayList = new ArrayList(7);
        }
        return strReader.readIds(arrayList);
    }

    @NotNull
    public final IntArrayList readInts(@NotNull IntArrayList list) {
        while (!this.getEof()) {
            int pos0 = this.getPos();
            int v = this.skipSpaces().tryReadInt(0);
            this.skipSpaces();
            int pos1 = this.getPos();
            if (pos1 == pos0) {
                throw new IllegalStateException(("Invalid int at " + pos0 + " in '" + this.str + '\'').toString());
            }
            list.add(v);
        }
        return list;
    }

    public static /* synthetic */ IntArrayList readInts$default(StrReader strReader, IntArrayList intArrayList, int n, Object object) {
        if ((n & 1) != 0) {
            intArrayList = new IntArrayList(7);
        }
        return strReader.readInts(intArrayList);
    }

    @Nullable
    public final String tryReadId() {
        int end2;
        int start = this.getPos();
        BaseStrReader this_$iv = this;
        boolean $i$f$skipWhile = false;
        while (this_$iv.getHasMore()) {
            char it = this_$iv.peekChar();
            boolean bl = false;
            if (!(Intrinsics.compare(it, 48) >= 0 && Intrinsics.compare(it, 57) <= 0 || Intrinsics.compare(it, 97) >= 0 && Intrinsics.compare(it, 122) <= 0 || Intrinsics.compare(it, 65) >= 0 && Intrinsics.compare(it, 90) <= 0 || it == '_' || it == '.')) break;
            this_$iv.readChar();
        }
        if ((end2 = this.getPos()) == start) {
            return null;
        }
        String string = this.str.substring(start, end2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lkorlibs/io/util/StrReader$Companion;", "", "()V", "literals", "Lkorlibs/io/util/StrReader$Literals;", "lits", "", "", "([Ljava/lang/String;)Lkorlibs/io/util/StrReader$Literals;", "korio"})
    @SourceDebugExtension(value={"SMAP\nStrReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,509:1\n37#2,2:510\n*S KotlinDebug\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Companion\n*L\n202#1:510,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Literals literals(String ... lits) {
            Collection $this$toTypedArray$iv = ArraysKt.toList(lits);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return Literals.Companion.fromList(thisCollection$iv.toArray(new String[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkorlibs/io/util/StrReader$Literals;", "", "lits", "", "", "map", "", "", "lengths", "", "([Ljava/lang/String;Ljava/util/Map;[Ljava/lang/Integer;)V", "getLengths", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "[Ljava/lang/String;", "contains", "lit", "matchAt", "str", "offset", "toString", "Companion", "korio"})
    @SourceDebugExtension(value={"SMAP\nStrReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Literals\n+ 2 _FastArrayIterators.kt\nkorlibs/datastructure/iterators/_FastArrayIteratorsKt\n*L\n1#1,509:1\n33#2,3:510\n*S KotlinDebug\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Literals\n*L\n335#1:510,3\n*E\n"})
    public static final class Literals {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String[] lits;
        @NotNull
        private final Map<String, Boolean> map;
        @NotNull
        private final Integer[] lengths;

        public Literals(@NotNull String[] lits, @NotNull Map<String, Boolean> map2, @NotNull Integer[] lengths) {
            this.lits = lits;
            this.map = map2;
            this.lengths = lengths;
        }

        @NotNull
        public final Integer[] getLengths() {
            return this.lengths;
        }

        public final boolean contains(@NotNull String lit) {
            return this.map.containsKey(lit);
        }

        @Nullable
        public final String matchAt(@NotNull String str, int offset) {
            Integer[] $this$fastForEach$iv = this.lengths;
            boolean $i$f$fastForEach = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEach$iv.length) {
                int len = ((Number)$this$fastForEach$iv[n$iv++]).intValue();
                boolean bl = false;
                String id = StringExtKt.substr(str, offset, len);
                if (!this.contains(id)) continue;
                return id;
            }
            return null;
        }

        @NotNull
        public String toString() {
            return "Literals(" + ArraysKt.joinToString$default(this.lits, (CharSequence)" ", null, null, 0, null, null, 62, null) + ')';
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lkorlibs/io/util/StrReader$Literals$Companion;", "", "()V", "fromList", "Lkorlibs/io/util/StrReader$Literals;", "lits", "", "", "([Ljava/lang/String;)Lkorlibs/io/util/StrReader$Literals;", "invoke", "korio"})
        @SourceDebugExtension(value={"SMAP\nStrReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Literals$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _FastArrayIterators.kt\nkorlibs/datastructure/iterators/_FastArrayIteratorsKt\n*L\n1#1,509:1\n37#2,2:510\n37#2,2:516\n11065#3:512\n11400#3,3:513\n33#4,3:518\n*S KotlinDebug\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$Literals$Companion\n*L\n319#1:510,2\n323#1:516,2\n323#1:512\n323#1:513,3\n325#1:518,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Literals invoke(String ... lits) {
                Collection $this$toTypedArray$iv = ArraysKt.toCollection(lits, (Collection)new ArrayList());
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return this.fromList(thisCollection$iv.toArray(new String[0]));
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Literals fromList(@NotNull String[] lits) {
                void $this$mapTo$iv$iv;
                String[] $this$map$iv = lits;
                boolean $i$f$map = false;
                String[] stringArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.length());
                }
                Collection $this$toTypedArray$iv = CollectionsKt.distinct(CollectionsKt.reversed(CollectionsKt.sorted((List)destination$iv$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Integer[] lengths = thisCollection$iv.toArray(new Integer[0]);
                LinkedHashMap map2 = new LinkedHashMap();
                String[] $this$fastForEach$iv = lits;
                boolean $i$f$fastForEach = false;
                int n$iv = 0;
                while (n$iv < $this$fastForEach$iv.length) {
                    String lit = $this$fastForEach$iv[n$iv++];
                    boolean bl = false;
                    ((Map)map2).put(lit, true);
                }
                return new Literals(lits, map2, lengths);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lkorlibs/io/util/StrReader$TRange;", "", "min", "", "max", "reader", "Lkorlibs/io/util/StrReader;", "(IILkorlibs/io/util/StrReader;)V", "file", "", "getFile", "()Ljava/lang/String;", "getMax", "()I", "getMin", "getReader", "()Lkorlibs/io/util/StrReader;", "text", "getText", "contains", "", "index", "displace", "offset", "endEmptyRange", "startEmptyRange", "toString", "Companion", "korio"})
    public static final class TRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int min;
        private final int max;
        @NotNull
        private final StrReader reader;

        public TRange(int min2, int max2, @NotNull StrReader reader) {
            this.min = min2;
            this.max = max2;
            this.reader = reader;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        @NotNull
        public final StrReader getReader() {
            return this.reader;
        }

        public final boolean contains(int index) {
            return index >= this.min && index <= this.max;
        }

        @NotNull
        public String toString() {
            return "" + this.min + ':' + this.max;
        }

        @NotNull
        public final String getFile() {
            return this.reader.getFile();
        }

        @NotNull
        public final String getText() {
            return this.reader.slice(this.min, this.max);
        }

        @NotNull
        public final TRange startEmptyRange() {
            return new TRange(this.min, this.min, this.reader);
        }

        @NotNull
        public final TRange endEmptyRange() {
            return new TRange(this.max, this.max, this.reader);
        }

        @NotNull
        public final TRange displace(int offset) {
            return new TRange(this.min + offset, this.max + offset, this.reader);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lkorlibs/io/util/StrReader$TRange$Companion;", "", "()V", "combine", "Lkorlibs/io/util/StrReader$TRange;", "a", "b", "combineList", "list", "", "createDummy", "korio"})
        @SourceDebugExtension(value={"SMAP\nStrReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$TRange$Companion\n+ 2 _FastArrayIterators.kt\nkorlibs/datastructure/iterators/_FastArrayIteratorsKt\n*L\n1#1,509:1\n28#2,3:510\n*S KotlinDebug\n*F\n+ 1 StrReader.kt\nkorlibs/io/util/StrReader$TRange$Companion\n*L\n356#1:510,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TRange combine(@NotNull TRange a, @NotNull TRange b) {
                return new TRange(Math.min(a.getMin(), b.getMin()), Math.max(a.getMax(), b.getMax()), a.getReader());
            }

            @Nullable
            public final TRange combineList(@NotNull List<TRange> list) {
                if (list.isEmpty()) {
                    return null;
                }
                TRange first2 = list.get(0);
                int min2 = 0;
                min2 = first2.getMin();
                int max2 = 0;
                max2 = first2.getMax();
                List<TRange> $this$fastForEach$iv = list;
                boolean $i$f$fastForEach = false;
                int n$iv = 0;
                while (n$iv < $this$fastForEach$iv.size()) {
                    TRange i = $this$fastForEach$iv.get(n$iv++);
                    boolean bl = false;
                    min2 = Math.min(min2, i.getMin());
                    max2 = Math.max(max2, i.getMax());
                }
                return new TRange(min2, max2, first2.getReader());
            }

            @NotNull
            public final TRange createDummy() {
                return new TRange(0, 0, new StrReader("", null, 0, 6, null));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

