
/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* SETTING.H --- Settings parameter block for communication between
   environment routines and canvas routines. */

typedef long SP;

#define MM2SP(MM)               ((SP)((double)(MM)/25.4*72.27*65536L+.5))
#define PT2SP(PT)               ((SP)((PT)*65536L+.5))


typedef enum { 
  sUNIT_LENGTH, 
  sFIGURE, 
  sCENTER, 
  sCAPTION, 
  sDOCUMENT,
  sZOOM_SMOOTH, 
  sTOOLS_RIGHT,
  sRULER_ON,
  sCROSSHAIRS_ON,

  sFILE_SHIFT,
  sAUTO_LOAD = sFILE_SHIFT,
  sBACKUP_FILE,

  sPICK_SHIFT,
  sFLASHING_PICK = sPICK_SHIFT,
  sOFF_SCREEN_PICK_WARN,
  sAUTO_DISPLACEMENT,
} SETTINGS_STATUS;

typedef enum  { 
  uERROR = -1, 
  uCM,  uEM,  uEX,  uIN,  uMM,  uPC,  uPT, uN
} UNITS_TYPE;

#define DEFAULT_EXT ".TEX"
#define NONAME "NO-NAME" DEFAULT_EXT

#ifndef MAXPATH
#define MAXPATH 80
#endif

/* Color array. */
typedef enum { 
  ccBACKGROUND, 
  ccTHIN, 
  ccTHICK, 
  ccPICK, 
  ccRULERS, 
  ccHAIRS,
  ccN
} COLOR_TYPE;

typedef int COLOR_VECTOR[ccN];

typedef struct {
  char edit_path[MAXPATH];
  unsigned status;
  char *caption;
  char *unitlength;
  UNITS_TYPE units;
  int pick_radius;
  int mouse_speed;
  int double_click_delta;
  int auto_redraw;
  COLOR_VECTOR color;
} SETTINGS_REC, *SETTINGS;

#define READ_SETTINGS   	(bit(sFIGURE)|bit(sCENTER)|bit(sCAPTION)|bit(sUNIT_LENGTH)|bit(sDOCUMENT))
#define FILE_SETTINGS		(bit(sAUTO_LOAD)|bit(sBACKUP_FILE))
#define PICK_SETTINGS		(bit(sFLASHING_PICK)|bit(sOFF_SCREEN_PICK_WARN)|bit(sAUTO_DISPLACEMENT))
#define set_read_settings(S,M)  ((S)->status = ((S)->status & ~READ_SETTINGS) | ((M) & READ_SETTINGS))
#define s_read_settings(S)	((S)->status & READ_SETTINGS)
#define set_file_settings(S,M)	((S)->status = ((S)->status & ~FILE_SETTINGS) | (((M) << sFILE_SHIFT) & FILE_SETTINGS))
#define s_file_settings(S)	(((S)->status & FILE_SETTINGS) >> sFILE_SHIFT)
#define set_pick_settings(S,M)	((S)->status = ((S)->status & ~PICK_SETTINGS) | (((M) << sPICK_SHIFT) & PICK_SETTINGS))
#define s_pick_settings(S)	(((S)->status & PICK_SETTINGS) >> sPICK_SHIFT)
#define set_units(S,U)          ((S)->units = (U))
#define set_edit_path(S,P)      (strcpy((S)->edit_path, (P)))
#define s_status_p(S,P) 	((S)->status & bit(P))

extern SETTINGS_REC settings[];
extern DIALOG_REC settings_dialog[];
extern MENU_REC options_menu[];

/* Units functions. */
void read_TeXlength_str(FILE *f, char *buf, int buf_len);
int str2TeXlength(char *str, SP *length_rtn, UNITS_TYPE *units_rtn);
void TeXlength2str(SP len, char *str, UNITS_TYPE u);

/* Settings functions. */
void set_caption(SETTINGS s, char *caption);
void set_unitlength(SETTINGS s, char *unitlength);
void settings2output_dialog(SETTINGS s);
void move_tools(int right_p);
void init_settings(char *initial_file, char *settings_path);
void close_settings(char *settings_path);
