{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$N-,E-,V-}
{$ENDIF}

Unit BibReach;

Interface

Uses
{$IFDEF WINDOWS}
  wobjects, wbibdisp, WinDos,
{$ELSE}
  Dos,objects, bibdisp,
{$ENDIF}
  bibvars, bibfile, bibstrg, bibutil, bibreadB, bibwild,
  bibtext, bibstrm, rc_strng, bibcache, lfnunit;


function  ReachRealEntry(Entry: EntryRecPtr; Pattern: PatRecPtr;
                         oreal: word): boolean;
procedure ReachEntry(Entry: EntryRecPtr; oreal,oentry: Word;
                     Place: longint; SayNew: Boolean);
procedure ReachNumber(Entry: EntryRecPtr; Pattern: PatRecPtr;
                      Rnum,Enum: word);
procedure ReachLabel(Entry: EntryRecPtr; Pattern: PatRecPtr;
                     match: string; CaseSen,RegExp,Exact: boolean;
                     var ok: boolean);
procedure RefreshEntry(Entry: EntryRecPtr);
procedure DeSuspend;


Implementation


procedure ReachEntrySlow(Entry: EntryRecPtr; oreal,oentry: Word);
var
  ok: boolean;
  OldVerbosity: Byte;
begin                            { ReachEntry }
  if not BibFileExists then Exit;
  if (entry^.entrynum=oentry) and (entry^.realnum=oreal) then exit;
  OldVerbosity:=Verbosity; Verbosity:=0;
  if entry^.realnum>oreal then
  begin
    ResetBib(Entry);
  end;
  entry^.entrynum:=entry^.realnum;
  ok:=true;
  if oreal-entry^.realnum>1 then
    GetEntry(Entry,Nil,oreal-1,false,Nil,ok);
  if ok then
  begin
    GetEntry(Entry,Nil,oreal,true,Nil,ok);
    entry^.entrynum:=oentry;
    if entry^.realnum<>oreal then ok:=false;
  end;
  if not ok then ResetBib(Entry);
  Verbosity:=OldVerbosity;
end;                            { ReachEntrySlow }

function ReachRealEntry(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        oreal: word): boolean;
var
  ok: boolean;
  OldVerbosity: Byte;
  i: longint;
begin
  ReachRealEntry:=false; ok:=true;
  if not BibFileExists then Exit;
  if not ActivePattern(Pattern) then
    ReachEntrySlow(Entry,oreal,oreal)
  else begin
    ResetBib(Entry);
    if oreal=0 then
    begin
      ReachRealEntry:=true; Exit;
    end;
    OldVerbosity:=Verbosity; Verbosity:=0;
    i:=0;
    repeat
      GetEntry(Entry,Nil,Entry^.entrynum+1,true,Pattern,ok);
      inc(i);
      if i>Entry^.EntryNum then ok:=false;
    until (not ok) or (Entry^.realnum>=oreal);
    Verbosity:=OldVerbosity;
  end;
  if (not ok) or (Entry^.realnum<>oreal) then ResetBib(Entry)
  else ReachRealEntry:=true;
end;                    { ReachRealEntry }

procedure ReachEntry(Entry: EntryRecPtr; oreal,oentry: Word;
                     Place: longint; SayNew: boolean);
var
  ok,OldAbort: boolean;
  i: LongInt;
  OldVerbosity: Byte;
begin
  if not BibFileExists then Exit;
  if Place<-1 then
  begin
    ReachEntrySlow(Entry,oreal,oentry); Exit;
  end;
  ResetBib(Entry);
  if (oreal=0) or (place<0) then Exit;
  if linked then
  begin
    BibInRing:=BibRingNum;
    while (BibInRing>1) and ((BibFiles^[BibRing[BibInRing]].realstart=0)
        or (BibFiles^[BibRing[BibInRing]].realstart>oreal)) do
      dec(BibInRing);
    CloseFile(bib);
    CurrentBibFile:=BibRing[BibInRing];
    bibname^:=BibFiles^[BibRing[BibInRing]].name;
    BibReadOnly:=BibFiles^[BibRing[BIbInRing]].RO;
    LFNAssign(bib,bibname^); ResetBibFile(bib,bibname^);
    SetTextBuf(bib,bibbuf^,FileBufSize);
  end;
  TextSeek(bib,Place);
  LastReadLine^:='';
  ReachedEol:=false;
  entry^.realnum:=oreal-1;
  entry^.entrynum:=oentry-1;
  ok:=true;
  OldVerbosity:=Verbosity; if not SayNew then Verbosity:=0;
  OldAbort:=AbortFlag; AbortFlag:=false;
  GetEntry(Entry,Nil,oentry,true,Nil,ok);
  AbortFlag:=OldAbort;
  Verbosity:=OldVerbosity;
end;                            { ReachEntry }

procedure ReachNumber(Entry: EntryRecPtr; Pattern: PatRecPtr;
                      Rnum,Enum: word);
begin
  DeSuspend;
  ReachEntrySlow(Entry,rnum,enum);
end;                                { ReachNumber }

procedure ReachLabel(Entry: EntryRecPtr; Pattern: PatRecPtr;
                     match: string; CaseSen,RegExp,Exact: boolean;
                     var ok: boolean);
var
  OldCurFile,i,OldInd: integer;
  found,quit,IndUse: boolean;
  OldEntNum,FromEnt,ToEnt,HighEnt: longint;
  T: TCacheSaveRec;

function Matches(s1,S2: string): boolean;
begin
  if RegExp then
    Matches:=PartMatch(S1,S2[1],length(S2),CaseSen)
  else if Exact then Matches:=(S1=S2)
  else begin
    if not CaseSen then StrLwr(S2);
    Matches:=(Pos(S1,S2)>0);
  end;
end;

function FindInIndex(Ind: integer; FromEnt,ToEnt: longint;
                     var T: TCacheSaveRec): boolean;
var
  IndexFile: PSafeBufStream;
  SRec: SortRecPtr;
  i: longint;
  found: boolean;
begin
  {
  if regexp then message('regexp');
  if casesen then message('casesen');
  if exact then message('exact');
  }
  IndexFile:=Nil; SRec:=Nil; found:=false; FindInIndex:=false;
  with T do
  begin
    Beg:=-1; ENum:=0; RNum:=0; 
  end;
  if ActivePattern(Pattern) or not EntryCache^.LinkedFiles[Ind].Indexed then Exit;
{  message('FII ['+num2str(Ind)+'] from '+num2str(FromEnt)+' to '+num2str(ToEnt));}
  with EntryCache^ do
  begin
    if FromEnt<=0 then FromEnt:=1
    else FromEnt:=FromEnt-BibFiles^[BibRing[Ind]].EntryStart;
    if ToEnt<=0 then ToEnt:=LinkedFiles[Ind].NEntries;
    New(IndexFile,Init(LinkedFiles[Ind].IndName,stOpenRead,WorkBufSize));
    New(SRec);
    IndexFile^.seek(LinkedFiles[Ind].EOHeader);
    for i:=1 to FromEnt do ReadSortRec(IndexFile,Srec^);
    i:=FromEnt;
    T.ENum:=BibFiles^[BibRing[Ind]].EntryStart+i;
    T.RNum:=T.ENum;
    T.Beg:=SRec^.place;
    while (not found) and (i<=ToEnt) and (IndexFile^.Status=stOK) do
    begin
      found:=Matches(match,Srec^.name);
      {
      if found then message('"'+match+'":"'+Srec^.name+'": matches')
      else message('"'+match+'":"'+Srec^.name+'": doesn''t match');}
      if not found then
      begin
        inc(i);
        if i<=ToEnt then
        begin
          ReadSortRec(IndexFile,Srec^);
          T.ENum:=BibFiles^[BibRing[Ind]].EntryStart+i;
          T.RNum:=T.ENum;
          T.Beg:=SRec^.place;
        end;
      end;
    end;
  end;
  if Srec<>Nil then Dispose(Srec);
  if IndexFile<>Nil then Dispose(IndexFile,Done);
  FindInIndex:=found;
end;                     { FindInIndex }

procedure NextFile(var Ind: integer);
begin
  FromEnt:=0;
  inc(Ind);
  if Ind>BibRingNum then Ind:=1;
  if Ind=OldCurFile then
  begin
    ToEnt:=OldEntNum-1;
    if ToEnt<=0 then
    begin
      quit:=true; Exit;
    end;
  end;
  if not (IndUse and EntryCache^.LinkedFiles[Ind].Indexed) then
  begin
    CloseFile(bib);
    BibInRing:=Ind;
    bibname^:=BibFiles^[BibRing[BibInRing]].name;
    BibReadOnly:=BibFiles^[BibRing[BIbInRing]].RO;
    LFNAssign(bib,bibname^); UnixBib:=IsUnixFile(bib,bibname^);
    ResetBibFile(bib,bibname^); SetTextBuf(bib,bibbuf^,FileBufSize);
    CurrentBibFile:=BibRing[BibInRing];
    AtStartOfFile:=true; 
    LastReadLine^:='';
    Entry^.EntryNum:=T.ENum; Entry^.RealNum:=T.RNum;
    Entry^.name:=''; Entry^.EntryType:=''; Entry^.nentry:=0;
    GetEntry(Entry,Nil,Entry^.EntryNum+1,false,Pattern,ok);
    Ind:=BibInRing;
  end;
end;                 { NextFile }

begin                       { ReachLabel }
  if not (RegExp or CaseSen or Exact) then StrLwr(match);
  IndUse:=not (ActivePattern(Pattern) or EditOnlyStrings) and EntryCache^.on;
  OldCurFile:=BibInRing; OldEntNum:=Entry^.EntryNum;
  found:=false; quit:=false;
  if IndUse and EntryCache^.LinkedFiles[BibInRing].Indexed then
  begin
    i:=BibInRing; FromEnt:=Entry^.EntryNum+1;
  end else
  begin
    GetEntry(Entry,Nil,Entry^.EntryNum+1,false,Pattern,ok);
    i:=BibInRing;
    FromEnt:=Entry^.EntryNum;
  end;
  ToEnt:=0;
  repeat
    if IndUse and EntryCache^.LinkedFiles[i].Indexed then
    begin
      found:=FindInIndex(i,FromEnt,ToEnt,T);
      if ToEnt<>0 then quit:=true
      else if not found then NextFile(i);
    end else
    begin
      OldInd:=i;
      HighEnt:=Entry^.EntryNum;
      repeat
        if ok and (BibInRing=i) and Matches(match,Entry^.name) then
        begin
          found:=true;
          T.ENum:=Entry^.EntryNum; T.RNum:=Entry^.RealNum;
          T.Beg:=Entry^.beginning;
        end else
        begin
          GetEntry(Entry,Nil,Entry^.EntryNum+1,false,Pattern,ok);
          i:=BibInRing;
          if HighEnt>=Entry^.EntryNum then
            EntryCache^.SetLast(HighEnt,Pattern)
          else HighEnt:=Entry^.EntryNum;
        end;
      until found or (i<>OldInd) or (Entry^.EntryNum=OldEntNum);
      if (not found) and (Entry^.EntryNum=OldEntNum) then
      begin
        quit:=true;
        if ok then
        begin
          {found:=Matches(match,Entry^.name);}
          T.ENum:=Entry^.EntryNum; T.RNum:=Entry^.RealNum;
          T.Beg:=Entry^.beginning;
        end;
      end;
    end;
  until found or quit;
  ok:=found;
  if found then ReachEntry(Entry,T.RNum,T.ENum,T.Beg,true);
end;                       { ReachLabel }

procedure DeSuspend;
var
  tmp: string[70];
begin                            { DeSuspend }
  if suspended and BibFileExists then
  begin
    { message(' Program was suspended '); }
    LFNReset(bib,0);
    if (DosError<>0) and (bibname^<>'') then
    begin
      tmp:=' I/O error '+num2str(DosError)+' while opening "'+bibname^+'". ';
      if DosError<>2 then tmp:=tmp+'May be locked. ';
      if not AskIf(tmp,'','Continue','Abort') then Halt(255);
    end;
    if SuspendedPos>-1 then TextSeek(bib,SuspendedPos);
    suspended:=false;
  end;
end;                            { DeSuspend }

procedure RefreshEntry(Entry: EntryRecPtr);
begin
  if Entry^.EntryNum=0 then Exit;
  ReachEntry(Entry,Entry^.RealNum,Entry^.EntryNum,Entry^.Beginning,false);
end;

end.
