/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorKt;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LCHuvColorSpaces;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\bf\u0018\u0000 32\u00020\u0001:\u00013J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H&J\b\u00102\u001a\u00020\u0000H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00064"}, d2={"Lcom/github/ajalt/colormath/Color;", "", "alpha", "", "getAlpha", "()F", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toHSL", "Lcom/github/ajalt/colormath/model/HSL;", "toHSV", "Lcom/github/ajalt/colormath/model/HSV;", "toAnsi16", "Lcom/github/ajalt/colormath/model/Ansi16;", "toAnsi256", "Lcom/github/ajalt/colormath/model/Ansi256;", "toCMYK", "Lcom/github/ajalt/colormath/model/CMYK;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toLAB", "Lcom/github/ajalt/colormath/model/LAB;", "toLCHab", "Lcom/github/ajalt/colormath/model/LCHab;", "toLUV", "Lcom/github/ajalt/colormath/model/LUV;", "toLCHuv", "Lcom/github/ajalt/colormath/model/LCHuv;", "toHWB", "Lcom/github/ajalt/colormath/model/HWB;", "toOklab", "Lcom/github/ajalt/colormath/model/Oklab;", "toOklch", "Lcom/github/ajalt/colormath/model/Oklch;", "toJzAzBz", "Lcom/github/ajalt/colormath/model/JzAzBz;", "toJzCzHz", "Lcom/github/ajalt/colormath/model/JzCzHz;", "toICtCp", "Lcom/github/ajalt/colormath/model/ICtCp;", "toHSLuv", "Lcom/github/ajalt/colormath/model/HSLuv;", "toHPLuv", "Lcom/github/ajalt/colormath/model/HPLuv;", "toArray", "", "clamp", "Companion", "colormath"})
public interface Color {
    @NotNull
    public static final Companion Companion = com.github.ajalt.colormath.Color$Companion.$$INSTANCE;

    public float getAlpha();

    @NotNull
    public ColorSpace<?> getSpace();

    @NotNull
    public RGB toSRGB();

    @NotNull
    public HSL toHSL();

    @NotNull
    public HSV toHSV();

    @NotNull
    public Ansi16 toAnsi16();

    @NotNull
    public Ansi256 toAnsi256();

    @NotNull
    public CMYK toCMYK();

    @NotNull
    public XYZ toXYZ();

    @NotNull
    public LAB toLAB();

    @NotNull
    public LCHab toLCHab();

    @NotNull
    public LUV toLUV();

    @NotNull
    public LCHuv toLCHuv();

    @NotNull
    public HWB toHWB();

    @NotNull
    public Oklab toOklab();

    @NotNull
    public Oklch toOklch();

    @NotNull
    public JzAzBz toJzAzBz();

    @NotNull
    public JzCzHz toJzCzHz();

    @NotNull
    public ICtCp toICtCp();

    @NotNull
    public HSLuv toHSLuv();

    @NotNull
    public HPLuv toHPLuv();

    @NotNull
    public float[] toArray();

    @NotNull
    public Color clamp();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/github/ajalt/colormath/Color$Companion;", "", "<init>", "()V", "colormath"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static HSL toHSL(@NotNull Color $this) {
            return $this.toSRGB().toHSL();
        }

        @NotNull
        public static HSV toHSV(@NotNull Color $this) {
            return $this.toSRGB().toHSV();
        }

        @NotNull
        public static Ansi16 toAnsi16(@NotNull Color $this) {
            return $this.toSRGB().toAnsi16();
        }

        @NotNull
        public static Ansi256 toAnsi256(@NotNull Color $this) {
            return $this.toSRGB().toAnsi256();
        }

        @NotNull
        public static CMYK toCMYK(@NotNull Color $this) {
            return $this.toSRGB().toCMYK();
        }

        @NotNull
        public static XYZ toXYZ(@NotNull Color $this) {
            return $this.toSRGB().toXYZ();
        }

        @NotNull
        public static LAB toLAB(@NotNull Color $this) {
            return $this.toXYZ().toLAB();
        }

        @NotNull
        public static LCHab toLCHab(@NotNull Color $this) {
            return $this.toLAB().toLCHab();
        }

        @NotNull
        public static LUV toLUV(@NotNull Color $this) {
            return $this.toXYZ().toLUV();
        }

        @NotNull
        public static LCHuv toLCHuv(@NotNull Color $this) {
            return $this.toLUV().toLCHuv();
        }

        @NotNull
        public static HWB toHWB(@NotNull Color $this) {
            return $this.toSRGB().toHWB();
        }

        @NotNull
        public static Oklab toOklab(@NotNull Color $this) {
            return $this.toXYZ().toOklab();
        }

        @NotNull
        public static Oklch toOklch(@NotNull Color $this) {
            return $this.toOklab().toOklch();
        }

        @NotNull
        public static JzAzBz toJzAzBz(@NotNull Color $this) {
            return $this.toXYZ().toJzAzBz();
        }

        @NotNull
        public static JzCzHz toJzCzHz(@NotNull Color $this) {
            return $this.toJzAzBz().toJzCzHz();
        }

        @NotNull
        public static ICtCp toICtCp(@NotNull Color $this) {
            return $this.toXYZ().toICtCp();
        }

        @NotNull
        public static HSLuv toHSLuv(@NotNull Color $this) {
            return ((LCHuv)ColorKt.convertTo($this, LCHuvColorSpaces.INSTANCE.getLCHuv65())).toHSLuv();
        }

        @NotNull
        public static HPLuv toHPLuv(@NotNull Color $this) {
            return ((LCHuv)ColorKt.convertTo($this, LCHuvColorSpaces.INSTANCE.getLCHuv65())).toHPLuv();
        }

        @NotNull
        public static Color clamp(@NotNull Color $this) {
            float[] values2 = $this.toArray();
            boolean clamped = false;
            int n = values2.length;
            for (int i = 0; i < n; ++i) {
                ColorComponentInfo info = $this.getSpace().getComponents().get(i);
                float f = info.getMin();
                float f2 = info.getMax();
                float f3 = values2[i];
                if (f <= f3 ? f3 <= f2 : false) continue;
                clamped = true;
                values2[i] = info.isPolar() ? values2[i] % (float)360 : RangesKt.coerceIn(values2[i], info.getMin(), info.getMax());
            }
            return clamped ? $this.getSpace().create(values2) : $this;
        }
    }
}

