/*
** Datei: DVIRDIMG.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>   
#include <string.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvimisc.h"

IMG_FILE *img_open(char *name, int *width, int *height, int *bytes,
		   int *pix_width, int *pix_height, char *path)
{
    FILE *fp;
    IMGHEADER header;
    IMG_FILE *img;
    int n;
    char filename[MAX_PATH_LEN];

    if ((fp=fopene(name,"rb",path,filename))==NULL) return NULL;
    if ( fread(&header,sizeof(header),1,fp)!=1 ) 
    {
	fclose(fp);
	return NULL;
    }
    xprint(0,"(%s",filename);
#ifdef TURN_INTS
    turn_word((char*)&header,sizeof(header)/2);
#endif
    if (header.im_headlength*2>sizeof(header))
    {
	long i=header.im_headlength*2-sizeof(header);
	while(i-->0) (void)getc(fp);
    }

    *width  = header.im_scanwidth;
    *height = header.im_nlines;
    *bytes  = n = (header.im_scanwidth+7)/8;
    *pix_height = header.im_pixheight;
    *pix_width  = header.im_pixwidth;

    img = (IMG_FILE*)mem_alloc(n+sizeof(IMG_FILE),"IMG-Data");
    img->img_fp = fp;
    img->img_header = header;
    img->img_bytes = n;
    img->img_repeat = 0;

    return img;
}

char *img_read(char *scan_line, register IMG_FILE *img)
{
    if (img->img_repeat<=0)
    {
	register int  c;
	register int  i, l;
	register char *b, *p;

	i = img->img_bytes;
	b = img->img_buffer;
	while(i>0)
	{
	    switch(c=getc(img->img_fp))
	    {
		case EOF : 
		    return NULL;

		case 0x00:
		    if ((c = getc(img->img_fp))==0)
		    {
			c=getc(img->img_fp);
			if (c!=255 || i!=img->img_bytes)
			    return NULL;
			/* 
			** Case: 00 00 FF XX 
			** Repeat Count := XX
			*/
			if ( (img->img_repeat=getc(img->img_fp))==EOF ) 
			    return NULL;
			img->img_repeat--;
			break;
		    }
		    /*
		    ** Case: 00 XX
		    ** Read pattern of length "im_patlen"
		    ** and repeat it XX times on the line
		    */
		    if (c==EOF) return NULL;
		    l = img->img_header.im_patlen;
		    if (i<l) return NULL;
		    if (fread(p=b,1,l,img->img_fp)!=l) return NULL;
		    b += l; i -= l;
		    for ( ;--c>0 && i>=l; b+=l, i-=l) memcpy(b,p,l);
		    break;

		case 0x80:
		    /*
		    ** Case: 80 XX
		    ** Read pattern of length "XX"
		    ** and draw it on the current line
		    */
		    if ( (c=getc(img->img_fp))==EOF ) return NULL;
		    if (i<c) return NULL;
		    if ( fread(b,1,c,img->img_fp)!=c ) return NULL;
		    b += c; i -= c;
		    break;

		default:
		    /* 
		    ** Case: XX (XX<>0 and XX<>80)
		    ** Draw XX bytes white or black, depending
		    ** on the most significant bit of XX
		    */
		    if (c & 128)
			for (c &= 127; c && i; c--,i--) *b++ = (char)0xFF;
		    else
			for (c &= 127; c && i; c--,i--) *b++ = (char)0x00;
		    break;
	    }
	}
    }
    else (img->img_repeat--);
    if (scan_line!=NULL) 
	memcpy(scan_line,img->img_buffer,img->img_bytes);
    return img->img_buffer;
}

void img_close(IMG_FILE *img)
{
    if (img!=NULL)
    {
	xprint(-1,")");
	fclose(img->img_fp);
	mem_free(img,sizeof(IMG_FILE)+img->img_bytes);
    }
}

