#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "dvi.h"
#include "dvidvi.h"
#include "dviframe.h"


#ifdef IBMPC
static byte huge *frame_buffer;
static long block_len, block_start, block_end;
static const long block_max = 32700l;
#else
byte huge   *frame_buffer;
#endif

#ifdef IBMPC

void        (*frame_or)(long a, byte x);
byte        (*frame_get)(long a);
void        (*frame_set)(byte huge *p, long len);
void        (*frame_poke)(long a, byte x);
void        (*frame_and)(long a, byte x);
byte huge * (*frame_ptr)(long a);
void        (*frame_clr)(void);
void huge * (*frame_alloc)(long);
void        (*frame_free)(void huge*,long);

extern byte huge * n_386_ptr(long);
extern void n_386_init(void far *);
extern void n_386_or(long a, byte x);

void huge * n_frame_alloc(long s)
{
    return mem_alloc(s, "Frame-Buffer");
}

void n_frame_free(void huge *p, long s)
{
    mem_free(p, s);
}

byte n_frame_get(long a)
{
    return *(frame_buffer+a);
}

void n_frame_or(long a, byte x)
{
    *(frame_buffer+a) |= x;
}

void n_frame_and(long a, byte x)
{
    *(frame_buffer+a) &= x;
}

void n_frame_poke(long a, byte x)
{
    *(frame_buffer+a) = x;
}

byte huge *n_frame_ptr(long a)
{
    return frame_buffer+a;
}

void n_frame_clr(void)
{
    long size = frame_size;
    byte huge *p = frame_buffer;
    while(size>0x7FFFl)
    {
	memset((void*)p,0,0x7fff);
	p += 0x7fff;
	size -= 0x7fff;
    }
    if (size>0) memset((void*)p,0,(size_t)size);
}

void n_frame_set(byte huge *p, long len)
{
    frame_buffer = p;
    block_len = 0;
    len = len;
    /* n_386_init(p); */
}

static void frame_swap(long a)
{
    movetoe(frame_buffer,block_start,block_len);
    block_start = a-(block_len/2l);
    if (block_start<0l) block_start = 0l;
    block_end = block_start + block_len;
    movefrome(frame_buffer,block_start,block_len);
}

void huge * e_frame_alloc(long s)
{
    if (s>block_max) s = block_max;
    return mem_alloc(s, "Frame-Buffer");
}

void e_frame_free(void huge *p, long s)
{
    if (s>block_max) s = block_max;
    mem_free(p, s);
}

void e_frame_or(long a, byte x)
{
    if (a<block_start || a>=block_end) frame_swap(a);
    *(frame_buffer+a-block_start) |= x;
}

byte e_frame_get(long a)
{
    if (a<block_start || a>=block_end) frame_swap(a);
    return *(frame_buffer+a-block_start);
}

void e_frame_and(long a, byte x)
{
    if (a<block_start || a>=block_end) frame_swap(a);
    *(frame_buffer+a-block_start) &= x;
}

void e_frame_poke(long a, byte x)
{
    if (a<block_start || a>=block_end) frame_swap(a);
    *(frame_buffer+a-block_start) = x;
}

byte huge *e_frame_ptr(long a)
{
    if (a<block_start || a+frame_width>=block_end) frame_swap(a);
    return frame_buffer+a-block_start;
}

void e_frame_clr(void)
{
    long size = frame_size, pos = 0;

    memset(frame_buffer,0,(size_t)block_len);

    while(size>=block_len)
    {
	movetoe(frame_buffer,pos,block_len);
	size -= block_len;
	pos += block_len;
    }
    if (size>0l) movetoe(frame_buffer,pos,size);
    block_start = 0l;
    block_end = block_len;
}

void e_frame_set(byte huge *p, long len)
{
    frame_buffer = p;
    if (len>=block_max) block_len = block_max;
    else block_len = len & ~1l;
    if (block_len == 0l)
	halt("Not enough memory for swapping");
}

long frame_max(void)
{
    long s = get_extended();
    if (s)
    {
	frame_or    = e_frame_or;
	frame_get   = e_frame_get;
	frame_set   = e_frame_set;
	frame_poke  = e_frame_poke;
	frame_and   = e_frame_and;
	frame_ptr   = e_frame_ptr;
	frame_clr   = e_frame_clr;
	frame_alloc = e_frame_alloc;
	frame_free  = e_frame_free;
    }
    else
    {
	frame_or    = n_frame_or;
	frame_get   = n_frame_get;
	frame_set   = n_frame_set;
	frame_poke  = n_frame_poke;
	frame_and   = n_frame_and;
	frame_ptr   = n_frame_ptr;
	frame_clr   = n_frame_clr;
	frame_alloc = n_frame_alloc;
	frame_free  = n_frame_free;
	s = op.pixmem;
    }
    return s;
}

#endif
