.TH BIBVIEW 1 "Jun 1993"
.SH NAME
bibview \- 
an X based graphical user interface for manipulating BibTeX databases 
.SH SYNOPSIS
\fBbibview  [standard options] [-file <bib file>] [-rcfile <conf file>] 
[-bibdir <directory>]\fP 
.SH DESCRIPTION
     
\fIBibview\fR facilitates the manipulation of BibTeX databases (in the 
following called BiB). It supports the user in making new entries,
searching for entries and moving entries from one BiB to another.
It is possible to work with more than one BiB simultaneously. 
New types can be defined and new fields can be added to existing types
in a configuration file.
.br
There are six types of windows in \fIbibview\fR:
.br
The \fImain window\fR contains menus for customizing \fIbibview\fR and
for working with BiBs on the file level.
.br
The \fIbibliography window\fR (one for every open BiB) contains commands
for manipulating the BiB.
.br
The \fIlist window\fR (at most one for every open BiB) shows a list of
entries. It displays the fields author, title, year, category and type.
The fields that are displayed and the layout of the fields can be
changed in the configuration file.
The entries of the list window can be sorted by all field by default.
The fields by which a list can be sorted can be set 
in the configuration file.
.br
The \fIcard window\fR (at most one for every entry) helps editing an entry. 
It contains boxes for each field of the entry (according to the type).
The fields can be edited by putting the mouse cursor into the card
window. The field with the input focus has no border. The input
focus can be changed using the <tab> key (move to next field), the
<esc> key (move to preceding field) or by clicking the right
mouse button in the new input field.
.br
The annote field of an entry can be edited in a separate window after
clicking 'annote' in the card window.
Macros in fields and the symbol for concatenation ('#') are marked
by a preceding '@'. The required fields are marked by bold lines.
A card window is displayed after clicking an entry in the list menu
(left mouse button), selecting a type in the `New` menu of a
bibliography window or duplicating an entry with the `Duplicate' menu
of the card window.
.br
The \fImacro window\fR (at most one for every open BiB) helps editing 
the STRING and PREAMBLE parts of a BiB. 
.br
The \fIerror window\fR (at most one for every BiB) is displayed
if a BiB cannot be opened because of syntax errors. The line with
the error is marked. The file can be edited and opened again.

.SH Main Window

The \fImain window\fR is displayed at the start of \fIbibview\fR.
It offers the following menus.
.br
\fBFile\fR:  Load and save BiBs. For choosing a name a file select box 
is displayed. The file select box initially shows the content of the 
current working directory or of the default directory defined in the
configuration file. A file is chosen by clicking a filename and
the OK button of the box or by entering a filename. 
.RS
.IP "\fINew\fR" 8
Create a new BiB.
.br
.IP "\fIOpen\fR" 8
Read an existing BiB.
.br
.IP "\fIClose\fR" 8
Close an open BiB.
.br
.IP "\fISave\fR" 8
Save an open BiB.
.br
.IP "\fISave as\fR" 8
Save an open BiB and select a new name for it.
.br
.IP "\fIQuit\fR" 8
Quit a bibview session.
.br
.RE

\fBServices\fR:
.br
.RS
.IP "\fIConsistency Check\fR" 8
Entries that don't contain all required fields
for that type are shown in the list window. If an entry contains a
crossreference, it is regarded as complete. (The crossreference is not
checked)
.br
.IP "\fIUnify\fR" 8
Insert all entries of one BiB in another. If there are
key conflicts, a new key is generated by appending a letter to
the inserted key so the the new key is unique.
.br
.IP "\fIPrint\fR" 8
A LaTeX file with the entries of a BiB is created. 
.br
.IP "\fIEdit Macros\fR" 8
Open \fImacro window\fR for editing the macros of a BiB.
.br
.IP "\fILoad Configuration\fR" 8
Load a configuration file. 
.RE

\fBOptions\fR: Change default options
.br
.RS
.IP "\fIBeep on Errors\fR" 8
Beep in case of an error (default: TRUE).
.br
.IP "\fIBackup\fR" 8
Before writing a BiB on disk, a backup of the file with the
ending '.bak,i' is created, where is is a number so that
existing backups are not deleted (default: TRUE).
.br
.IP "\fIIcons on Desktop\fR" 8
Icons of list and card windows are layed down
on the corresponding bibliography window (default: FALSE). This option 
doesn't work with all window managers.
.br
.IP "\fIAutom. Check\fR" 8
A consistency check takes place if a new BiB is
loaded (default: FALSE).
.br
.IP "\fIRequired Fields\fR" 8
When saving an entry, a warning is
displayed if it doesn't contain all fields required by
 BibTeX (default: FALSE).
.br
.IP "\fIIgnore Case\fR" 8
When searching for entries, uppercase/lowercase
distinctions are ignored during comparisons (default: TRUE).
.br
.IP "\fIPrint As Bib\fR" 8
When printing a file, a LaTeX file containing
\nocite commands is created, otherwise the format of the LaTeX file is 
fixed (default: TRUE). 
The default style file is alpha.  This default can be changed in the
[StyleFile] part of the configuration file.
.br
.IP "\fIDisplay Error Window\fR" 8
An error window is displayed if
a syntax error occurs (default: FALSE).
.RE
               
\fBWindow\fR: 
.br
.RS
.IP "\fICascade\fR" 8
The windows belonging to the same BiB (bibliography window,
macro window, card windows) are grouped together. This doesn't work with
all window managers.
.RE

\fBHelp\fR:
.br 
Help texts are offered to the following topics:
.br
.RS
\fISurvey\fR
.br
\fIMain Window\fR
.br
\fIBibliography Window\fR
.br
\fIList Window\fR
.br
\fICard Window\fR
.br
\fIMacro and Error Window\fR
.br
\fIProgram Info\fR
.RE

.SH Bibliography Window

The menu bar of the bibliography window contains functions for
manipulating the corresponding BiB:

.RS
.IP "\fBNew\fR:" 8
Create a new entry. The type of the entry must be chosen
from a pulldown menu. An entry of a type different from the 
standard BibTeX types can be made with the item 'OwnType'
of this menu. The type can be entered in the field 'Owntype'
of the card window.

.br
.IP "\fBSearch\fR:" 8
Search for all entries that fullfill certain conditions. A window is displayed
in which for every field a regular expression can be entered. The result of
the search (the entries that match all regular expressions) is shown
in the list window.
.br
If a regular expression is entered in the field \fIAllfields\fR,
the entries matching the expression in any field are displayed.
.br
A search for user defined fields can be made by entering a
field name (no regular expression allowed, case not ignored)
and a regular expression.
.br
.IP "\fBList\fR:" 8
All entries of the BiB are shown in the \fIlist window\fR. The \fIcard 
window\fR is displayed after clicking the corresponding entry.
.br
.IP "\fBMacros\fR:" 8
The \fImacro window\fR for editing STRING and PREAMBLE macros is
displayed.
.br
.IP "\fBPrint\fR:" 8
A LaTeX file with the entries of the list is created
.br
.IP "\fBSave\fR:" 8
Save the BiB on disk. The BiB remains loaded.
.br
.IP "\fBClose\fR:" 8
Close the BiB.
.RE

.SH List Window
The \fIlist window\fR is displayed after clicking the menu 
item \fIlist\fR of the bibliography window, as result of a search
or as result of a consistency check. The menu bar of the \fIlist window\fR
offers the following commands:
.br
.RS
.IP "\fBSave\fR:" 8
The entries of the list are saved as a new BiB.
.br
.IP "\fBSort\fR:" 8
The entries of the list are sorted. The way in which the list is
sorted can be chosen from a menu.
.br
.IP "\fBCopy\fR:" 8
The entries of the list can be inserted into another BiB.
.br
.IP "\fBPrint\fR:" 8
A LaTeX file with the entries of the list is created.
.br
.IP "\fBClose\fR:" 8
The \fIlist\fR window is closed.
.RE

.SH Card Window

The menu bar of the \fIcard window\fR offers the following commands:
.br
.RS
.IP "\fBDuplicate\fR:" 8 
A new card window is opened in which the field contents (except
mainkey) are taken from the actual card window. The actual card
window must have been saved, otherwise the new card window
is empty.
.br
.IP "\fBUser Data\fR:" 8
The \fIcard window\fR is extended with the
fields defined by the user.
.br
.IP "\fBAnnote\fR:" 8
The annote field of an entry can be edited in a window.
.br
.IP "\fBDelete\fR:" 8
The entry is deleted from the BiB.
.br
.IP "\fBSave\fR:" 8
The entry is saved in the BiB.
.br
.IP "\fBCopy\fR:" 8
The entry is copied into another BiB.
.br
.IP "\fBClose\fR:" 8
Close the \fIcard window\fR.
.RE

.SH Macro Window

The menu bar of the \fImacro window\fR offers the following commands:
.br
.RS
.IP "\fBSave\fR:" 8
Save the macros and preambles of the \fImacro window\fR.
.br
.IP "\fBClose\fR:" 8
Close the \fImacro window\fR.
.RE

.SH Error Window

The menu bar of the \fIerror window\fR offers the following commands:
.br
.RS
.IP "\fBSave\fR:" 8
Save the content of the \fIerror window\fR.
.br
.IP "\fBClose\fR:" 8
Close the \fIerror window\fR.
.RE


.SH Configuration File

With the configuration file it is possible to customize \fIbibview\fR.
The standard configuration file is the file \fI.bibviewrc\fR in the
home directory of the user. The configuration file can contain
the following parts:
.br
\fB[Options]\fR: Lines of the form
.ti 5
\fB<option name> : <bool>\fR
.br
can be used to set the default of the options.
.br
<option name> can be \fBBeepOnError, IconsOnDesk, MakeBackups,
AutoCheckBib, RequiredFields, IgnoreCase, PrintAsBib\fR or
\fBDisplayErrWin\fR. 
.br
<bool> can be \fBtrue\fR or \fBfalse\fR.
.br
\fB[Types]\fR: This section of the configuration file is used
to define new types, change existing types or add fields 
to all types.
.br
Type definitions start with lines of the form
.ti 5
\fBt : <type name>\fR
.br
(define new type <type name> or add fields to the existing type
<type name>)
.ti 5
\fBtc : <type name>\fR
.br
(define new type <type name> or add fields to the existing type
<type name>, clearing already defined fields)
.ti 5
\fBt : all\fR
.br
(add the following fields to all defined types).
.br
A type definition is followed by a number of field definitions of
the form
.ti 5
\fBf : <field name>\fR
.br
(add <field name> to the newly defined type or to all types (if `all'
is specified))
.ti 5
\fBrf : <field name>\fR
.br
(add <field name> as required field
to the newly defined type or to all types (if `all' is specified)).
.br
\fB[UserFields]\fR: This section is used to define user defined fields
for certain types or for all types. It contains lines of the form
.ti 5
\fB<type name> : <field name>\fR
.br
or
.ti 5
\fBall : <field name>\fR
.br
\fB[SortFields]\fR: This section is used to define the fields by
which a list can be sorted. A sort order can be specified. 
The section contains lines of the form
.ti 5
\fB<field name>\fR
.br
or
.ti 5
\fB<field name> : <sort order>\fR
.br
If \fB$clear$\fR is used as <field name>, all already defined
sort fields are discarded.
.br
\fB<sort order>\fR can be \fBn\fR for names or \fBd\fR for dates.
If no sort order is specified, lexicographic order is used.
.br
\fB[SearchFields]\fR: This section is used to define the fields which are
displayed in the search window. 
The section contains lines of the form
.ti 5
\fB<field name>\fR
.br
If \fB$clear$\fR is used as <field name>, all already defined
search fields are discarded.
.br
\fB[ListFields]\fR: This section is used to define the fields which are
displayed in the list window and the layout of the list window. 
The section contains lines of the form
.ti 5
\fB<field name> : <field width>\fR
.br
<field name> can be \fBmainkey\fR, \fBcardtype\fR or
the field names defined by BibTeX or in previous \fB[Types]\fR sections.
.br
<field width> is the number of characters that is used to
display the field.
.br
\fB[Predefines]\fR: This section is used to define data that can be
used in the search window. It contains lines of the form
.ti 5
\fB<field name> : <data>\fR
.br
<field name> can be \fBallfields\fR, \fBmainkey\fR, 
\fBcardtype\fR or a field defined by BibTeX or in previous
\fB[Types]\fR sections.
.br
\fB[LatexHeader]\fR and \fB[LatexFooter]\fR: In these sections
header and footer of the LaTeX file produced by the \fBPrint\fR command
can be defined.
.br
\fB[BibDir]\fR: This section contains the absolute pathname of the
directory where the BibTeX files are.
.br
\fB[StyleFile]\fR: This section contains the style file that is
used in the LaTeX file produced by the \fBPrint\fR command.
.br
\fB[AnnoteField]\fR: This section contains the name of the field
with annotations.
.br
\fB[SortedBy]\fR: This section contains the name of the field
by which a list is sorted by default.
.br
\fB[Indent]\fR: This section contains information concerning the
layout of the BibTeX file produced by bibview.
.br 
It contains lines of the form
.ti 5
\fB<parameter> : <number>\fR
.br
<parameter> can be \fBFldIndent\fR (number of characters by
which the field names are indented), \fBContIndent\fR (number of
characters by which the first line of the field content is
indented), \fBNewlineIndent\fR (number of characters by which
the followin lines of the field content are indented) and
\fBMaxLinelen\fR (maximum length of a line when printing
files as LaTeX files with \nocite commands).
.br
The Options part is not
evaluated if a configuration file is loaded by 'Load Configuration'.
Options can be changed using the 'Options' menu.

.SH Resource File

The resources (width and height of windows, foreground, colours,
texts,...) can be customized with a file \fIBibView\fR in the
home directory. A sample file is included.

.SH OPTIONS

\fBstandard options\fR:
.br
The standard options are
-display, -geometry, -iconic and others.
.br
\fB-file <bib file>\fR:
.br
The BibTeX database <bib file> is loaded at the start of \fIbibview\fR.
.br
\fB-rcfile <configuration file>\fR:
.br
Instead of \fI.bibviewrc\fR in the home directory
the file <configuration file> is used.
.br
\fB-bibdir <directory>\fR:
.br
A search for BibTeX files starts in <directory>.
.SH LIMITATIONS
Because of a bug in the Athena List Widget there are problems
with files with more than ca. 1000 entries. 
The \fIconsistency check\fR is not sophisticated enough.
Entries are sorted only by BibTeX key.
.br
Ideas for more features are welcome.

.SH COPYRIGHT
Copyright 1992 Technische Universitaet Muenchen

.SH AUTHORS
Holger Martin, Peter Urban and Armin Liebl.
.br
Send bug reports and ideas for enhancement to
.br
liebla@informatik.tu-muenchen.de 

