untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2h76OAipWi3qSZUhwLv96vhZzSSVFnJHuTrfX8iwN/0sVdu00WUulA+7qO4djC6JJMbGEU6y5kyJHzF7H0pT5Qw=

OpenBSD 6.8 errata 030, Sep 27, 2021:

sshd(8) failed to clear supplemental groups when executing an
AuthorizedUsersCommand or AuthorizedPrincipalsCommand helper program.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 030_sshd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sshd(8)
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/auth.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/auth.c,v
retrieving revision 1.147
diff -u -p -u -r1.147 auth.c
--- usr.bin/ssh/auth.c	27 Aug 2020 01:07:09 -0000	1.147
+++ usr.bin/ssh/auth.c	16 Sep 2021 16:28:29 -0000
@@ -825,6 +825,12 @@ subprocess(const char *tag, struct passw
 		}
 		closefrom(STDERR_FILENO + 1);
 
+		if (geteuid() == 0 &&
+		    initgroups(pw->pw_name, pw->pw_gid) == -1) {
+			error("%s: initgroups(%s, %u): %s", tag,
+			    pw->pw_name, (u_int)pw->pw_gid, strerror(errno));
+			_exit(1);
+		}
 		/* Don't use permanently_set_uid() here to avoid fatal() */
 		if (setresgid(pw->pw_gid, pw->pw_gid, pw->pw_gid) == -1) {
 			error("%s: setresgid %u: %s", tag, (u_int)pw->pw_gid,
