untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2ieCl2PFUBepgAegqE46pIGlf1QQEjlWZa/Et2JiiF+qPogUzp/kRZKl5BZ0kxp+unDT88VKnwgoReazKcbDPgc=

OpenBSD 6.8 errata 003, October 29, 2020:

tmux has a stack overflow in CSI parsing.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 003_tmux.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install tmux:
    cd /usr/src/usr.bin/tmux
    make obj
    make
    make install

Index: usr.bin/tmux/input.c
===================================================================
RCS file: /cvs/src/usr.bin/tmux/input.c,v
diff -u -p -u -r1.183 input.c
--- usr.bin/tmux/input.c	19 Aug 2020 06:37:23 -0000	1.183
+++ usr.bin/tmux/input.c	29 Oct 2020 15:34:14 -0000
@@ -1976,8 +1976,13 @@ input_csi_dispatch_sgr_colon(struct inpu
 				free(copy);
 				return;
 			}
-		} else
+		} else {
 			n++;
+			if (n == nitems(p)) {
+				free(copy);
+				return;
+			}
+		}
 		log_debug("%s: %u = %d", __func__, n - 1, p[n - 1]);
 	}
 	free(copy);
