/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.actions;

import com.almworks.tracklink.PatternIndexer;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.findusages.FindUtils;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import javax.swing.Icon;

public class SearchAction
extends AnAction {
    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)DataKeys.PROJECT.getData(e.getDataContext());
        e.getPresentation().setEnabled(project != null && FindUtils.getPatternIndexer() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)DataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        String[] urls = this.getURLs(project);
        if (urls.length == 0) {
            return;
        }
        PatternIndexer patternIndexer = FindUtils.getPatternIndexer();
        if (patternIndexer != null) {
            CodeLinkType[] codeLinkTypes;
            for (CodeLinkType codeLinkType : codeLinkTypes = patternIndexer.getIndexPatterns()) {
                for (int j = 0; j < urls.length; ++j) {
                    Matcher matcher = codeLinkType.getPattern().matcher(urls[j]);
                    if (!matcher.matches()) continue;
                    urls[j] = matcher.replaceAll(codeLinkType.getReplacePattern());
                }
            }
        }
        FindUtils.findUsages(project, urls);
    }

    private String[] getURLs(Project project) {
        String url = Messages.showInputDialog((Project)project, (String)StringBundle.get("search.message", new Object[0]), (String)StringBundle.get("search.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (StringUtil.isEmpty((String)url)) {
            return new String[0];
        }
        String[] strings = url.split(",");
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }
}

